/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.data.internal.persistence.cdi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.data.internal.persistence.EntityDefiner;
import io.openliberty.data.internal.persistence.QueryInfo;
import io.openliberty.data.internal.persistence.RepositoryImpl;
import io.openliberty.data.internal.persistence.cdi.DataExtension;
import io.openliberty.data.internal.persistence.cdi.DataExtensionProvider;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.InterceptionFactory;
import jakarta.enterprise.inject.spi.Producer;
import jakarta.enterprise.inject.spi.ProducerFactory;
import jakarta.enterprise.inject.spi.configurator.AnnotatedMethodConfigurator;
import jakarta.enterprise.inject.spi.configurator.AnnotatedTypeConfigurator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class RepositoryProducer<R, P>
implements Producer<R> {
    private static final TraceComponent tc = Tr.register(RepositoryProducer.class, (String)"data", (String)"io.openliberty.data.internal.persistence.resources.CWWKDMessages");
    private final Bean<R> bean;
    private final Factory<P> factory;
    private final Map<R, R> intercepted = new ConcurrentHashMap<R, R>();
    static final long serialVersionUID = 3593496393318154762L;

    public RepositoryProducer(Bean<R> bean, Factory<P> factory) {
        this.bean = bean;
        this.factory = factory;
    }

    public void dispose(R repository) {
        R r = this.intercepted.remove(repository);
        if (r != null) {
            repository = r;
        }
        RepositoryImpl handler = (RepositoryImpl)Proxy.getInvocationHandler(repository);
        handler.beanDisposed();
    }

    @Trivial
    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    @Trivial
    @ManualTrace
    public R produce(CreationalContext<R> cc) {
        Class repositoryInterface = this.bean.getBeanClass();
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"produce", (Object[])new Object[]{cc, repositoryInterface.getName()});
        }
        InterceptionFactory interception = this.factory.beanMgr.createInterceptionFactory(cc, repositoryInterface);
        boolean intercept = false;
        AnnotatedTypeConfigurator configurator = interception.configure();
        for (Annotation anno : configurator.getAnnotated().getAnnotations()) {
            if (!this.factory.beanMgr.isInterceptorBinding(anno.annotationType())) continue;
            intercept = true;
            configurator.add(anno);
            if (!trace || !tc.isDebugEnabled()) continue;
            Tr.debug((Object)this, (TraceComponent)tc, (String)("add " + anno + " for " + configurator.getAnnotated().getJavaClass()), (Object[])new Object[0]);
        }
        for (AnnotatedMethodConfigurator method : configurator.methods()) {
            for (Annotation anno : method.getAnnotated().getAnnotations()) {
                if (!this.factory.beanMgr.isInterceptorBinding(anno.annotationType())) continue;
                intercept = true;
                method.add(anno);
                if (!trace || !tc.isDebugEnabled()) continue;
                Tr.debug((Object)this, (TraceComponent)tc, (String)("add " + anno + " for " + method.getAnnotated().getJavaMember()), (Object[])new Object[0]);
            }
        }
        Object instance = repositoryInterface.cast(Proxy.newProxyInstance(repositoryInterface.getClassLoader(), new Class[]{repositoryInterface}, this.factory.getHandler()));
        if (intercept) {
            Object r = interception.createInterceptedInstance(instance);
            this.intercepted.put(r, instance);
            instance = r;
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"produce", (Object)instance.toString());
        }
        return (R)instance;
    }

    @Trivial
    static class Factory<P>
    implements ProducerFactory<P> {
        private final BeanManager beanMgr;
        private final EntityDefiner entityDefiner;
        private final DataExtension extension;
        private RepositoryImpl<?> handler;
        private final ReentrantReadWriteLock handlerLock = new ReentrantReadWriteLock();
        private final Class<?> primaryEntityClass;
        private final DataExtensionProvider provider;
        private final Map<Class<?>, List<QueryInfo>> queriesPerEntityClass;
        private final Class<?> repositoryInterface;

        Factory(Class<?> repositoryInterface, BeanManager beanMgr, DataExtensionProvider provider, DataExtension extension, EntityDefiner entityDefiner, Class<?> primaryEntityClass, Map<Class<?>, List<QueryInfo>> queriesPerEntityClass) {
            this.beanMgr = beanMgr;
            this.entityDefiner = entityDefiner;
            this.extension = extension;
            this.primaryEntityClass = primaryEntityClass;
            this.provider = provider;
            this.queriesPerEntityClass = queriesPerEntityClass;
            this.repositoryInterface = repositoryInterface;
        }

        public <R> Producer<R> createProducer(Bean<R> bean) {
            return new RepositoryProducer(bean, this);
        }

        private RepositoryImpl<?> getHandler() {
            this.handlerLock.readLock().lock();
            try {
                if (this.handler == null) {
                    try {
                        this.handlerLock.readLock().unlock();
                        this.handlerLock.writeLock().lock();
                        if (this.handler == null) {
                            this.handler = new RepositoryImpl(this.provider, this.extension, this.entityDefiner, this.repositoryInterface, this.primaryEntityClass, this.queriesPerEntityClass);
                        }
                    }
                    finally {
                        this.handlerLock.readLock().lock();
                        this.handlerLock.writeLock().unlock();
                    }
                }
                RepositoryImpl<?> repositoryImpl = this.handler;
                return repositoryImpl;
            }
            finally {
                this.handlerLock.readLock().unlock();
            }
        }
    }
}

