/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.data.internal.persistence.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.beanvalidation.service.BeanValidation;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import io.openliberty.data.internal.persistence.EntityValidator;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Validator;
import jakarta.validation.executable.ExecutableValidator;
import jakarta.validation.metadata.BeanDescriptor;
import jakarta.validation.metadata.MethodDescriptor;
import java.lang.reflect.Method;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class EntityValidatorImpl
implements EntityValidator {
    private static final TraceComponent tc = Tr.register(EntityValidatorImpl.class, (String)"data", (String)"io.openliberty.data.internal.persistence.resources.CWWKDMessages");
    private final BeanDescriptor classDesc;
    private final ExecutableValidator methodValidator;
    static final long serialVersionUID = 3419724924580209715L;

    public EntityValidatorImpl(Object validationService, Class<?> repositoryInterface) {
        BeanValidation validation = (BeanValidation)validationService;
        ComponentMetaData cdata = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        if (cdata == null) {
            throw new IllegalStateException("No component metadata found on thread");
        }
        Validator validator = validation.getValidator(cdata);
        this.classDesc = validator.getConstraintsForClass(repositoryInterface);
        this.methodValidator = validator.forExecutables();
    }

    @Override
    @Trivial
    public boolean[] isValidatable(Method method) {
        boolean validateResult;
        MethodDescriptor methodDesc = this.classDesc.getConstraintsForMethod(method.getName(), (Class[])method.getParameterTypes());
        boolean validateParams = methodDesc != null && method.getParameterCount() > 0 && methodDesc.hasConstrainedParameters();
        boolean bl = validateResult = methodDesc != null && methodDesc.hasConstrainedReturnValue();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("isValidatable: " + method.getName()), (Object[])new Object[]{"validate params? " + validateParams, "validate result? " + validateResult});
        }
        return new boolean[]{validateParams, validateResult};
    }

    @Override
    public <T> void validateParameters(T object, Method method, Object[] args) {
        Set violations = this.methodValidator.validateParameters(object, method, args, new Class[0]);
        if (violations != null && !violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public <T> void validateReturnValue(T object, Method method, Object returnValue) {
        Set violations = this.methodValidator.validateReturnValue(object, method, returnValue, new Class[0]);
        if (violations != null && !violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }
}

