/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.tx.config.ConfigurationProviderManager;
import com.ibm.tx.util.Utils;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.recoverylog.spi.LeaseInfo;
import com.ibm.ws.recoverylog.spi.LeaseLogImpl;
import com.ibm.ws.recoverylog.spi.PeerLeaseData;
import com.ibm.ws.recoverylog.spi.PeerLeaseTable;
import com.ibm.ws.recoverylog.spi.SharedServerLeaseLog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.PrivilegedAction;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class FileSharedServerLeaseLog
extends LeaseLogImpl
implements SharedServerLeaseLog {
    static String _tranRecoveryLogDirStem;
    static String _localRecoveryIdentity;
    static File _leaseLogDirectory;
    static String _recoveryGroup;
    static File _serverInstallLeaseLogDir;
    boolean leaseLogWrittenInThisRun;
    static File _controlFile;
    private int _leaseTimeout;
    private LeaseLock _peerLeaseLock;
    private LeaseLock _localLeaseLock;
    private static final FileSharedServerLeaseLog _fileLeaseLog;
    private static final TraceComponent tc;
    static final long serialVersionUID = -1943800435614270311L;

    private FileSharedServerLeaseLog() {
    }

    @ManualTrace
    public static FileSharedServerLeaseLog getFileSharedServerLeaseLog(String logDirStem, String localRecoveryIdentity, String recoveryGroup) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getFileSharedServerLeaseLog", (Object[])new Object[]{logDirStem, localRecoveryIdentity, recoveryGroup});
        }
        if (_serverInstallLeaseLogDir == null) {
            FileSharedServerLeaseLog.setLeaseLog(logDirStem, localRecoveryIdentity, recoveryGroup);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getFileSharedServerLeaseLog", (Object)_fileLeaseLog);
        }
        return _fileLeaseLog;
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    private static void setLeaseLog(String tranRecoveryLogDirStem, String localRecoveryIdentity, String recoveryGroup) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setLeaseLog", (Object[])new Object[]{tranRecoveryLogDirStem, localRecoveryIdentity, recoveryGroup});
        }
        if (recoveryGroup == null) {
            recoveryGroup = "defaultGroup";
        }
        _recoveryGroup = recoveryGroup;
        try {
            File leasesDir = new File(tranRecoveryLogDirStem).getParentFile();
            _serverInstallLeaseLogDir = leasesDir.getCanonicalPath().equals(new File(System.getenv("WLP_USER_DIR") + File.separator + "servers" + File.separator + ConfigurationProviderManager.getConfigurationProvider().getServerName()).getCanonicalPath()) || localRecoveryIdentity == null || localRecoveryIdentity.trim().isEmpty() ? new File(System.getenv("WLP_USER_DIR") + File.separator + "shared" + File.separator + "leases" + File.separator + recoveryGroup) : new File(leasesDir.getCanonicalPath() + File.separator + "leases" + File.separator + recoveryGroup);
        }
        catch (IOException leasesDir) {
            void e;
            FFDCFilter.processException((Throwable)leasesDir, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog", (String)"148", null, (Object[])new Object[]{tranRecoveryLogDirStem, localRecoveryIdentity, recoveryGroup});
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog.setLeaseLog", (String)"139");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("_serverInstallLeaseLogDir: " + _serverInstallLeaseLogDir.getAbsolutePath()), (Object[])new Object[0]);
        }
        if (tranRecoveryLogDirStem != null) {
            _tranRecoveryLogDirStem = tranRecoveryLogDirStem;
            if (_leaseLogDirectory == null) {
                _leaseLogDirectory = _serverInstallLeaseLogDir;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Have instatiated directory: " + _leaseLogDirectory.getAbsolutePath()), (Object[])new Object[0]);
                }
                AccessController.doPrivileged(new PrivilegedAction<Void>(){
                    static final long serialVersionUID = 3085797037830036996L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public Void run() {
                        block9: {
                            if (_leaseLogDirectory.exists()) {
                                if (_leaseLogDirectory.isDirectory()) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)"Lease log directory is in place as expected, instantiate control file", (Object[])new Object[0]);
                                    }
                                    _controlFile = new File(_serverInstallLeaseLogDir + String.valueOf(File.separatorChar) + "control");
                                }
                            } else {
                                try {
                                    _controlFile = new File(_serverInstallLeaseLogDir + String.valueOf(File.separatorChar) + "control");
                                    if (_leaseLogDirectory.mkdirs()) {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)"Lease log directory has been created", (Object[])new Object[0]);
                                        }
                                        if (_controlFile.createNewFile() && tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)("Control has been created: " + _controlFile.getAbsolutePath()), (Object[])new Object[0]);
                                        }
                                    }
                                }
                                catch (IOException iOException) {
                                    void e;
                                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$1", (String)"185", (Object)this, (Object[])new Object[0]);
                                    if (!tc.isDebugEnabled()) break block9;
                                    Tr.debug((TraceComponent)tc, (String)("Caught an IOException: " + e), (Object[])new Object[0]);
                                }
                            }
                        }
                        return null;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$1", 1.class, null, null);
                    }
                });
            }
        }
        _localRecoveryIdentity = localRecoveryIdentity;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setLeaseLog");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @ManualTrace
    public void updateServerLease(String recoveryIdentity, String recoveryGroup, boolean isServerStartup) throws Exception {
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"updateServerLease", (Object[])new Object[]{recoveryIdentity, recoveryGroup, isServerStartup, _tranRecoveryLogDirStem, this});
            }
            try {
                if (recoveryIdentity.equals(_localRecoveryIdentity)) {
                    block15: {
                        if (this._localLeaseLock == null) break block14;
                        if (!this.leaseLogWrittenInThisRun) {
                            try {
                                String line;
                                ByteBuffer byteBuffer = null;
                                FileChannel fChannel = this._localLeaseLock.getFileChannel();
                                if (tc.isDebugEnabled()) {
                                    byteBuffer = ByteBuffer.allocate((int)fChannel.size());
                                    fChannel.position(0L);
                                    fChannel.read(byteBuffer);
                                    byteBuffer.flip();
                                    line = new String(byteBuffer.array());
                                    Tr.info((TraceComponent)tc, (String)"Originally {0} lease file length {1} contains {2}", (Object[])new Object[]{recoveryIdentity, line.length(), line});
                                }
                                byteBuffer = ByteBuffer.wrap(_tranRecoveryLogDirStem.getBytes());
                                fChannel.position(0L);
                                fChannel.write(byteBuffer);
                                byteBuffer = ByteBuffer.wrap(("\n" + this.getBackendURL()).getBytes());
                                fChannel.write(byteBuffer);
                                fChannel.force(false);
                                this.leaseLogWrittenInThisRun = true;
                                if (tc.isDebugEnabled()) {
                                    byteBuffer = ByteBuffer.allocate((int)fChannel.size());
                                    fChannel.position(0L);
                                    fChannel.read(byteBuffer);
                                    byteBuffer.flip();
                                    line = new String(byteBuffer.array());
                                    Tr.info((TraceComponent)tc, (String)"On writing {0} lease file length {1} contains {2}", (Object[])new Object[]{recoveryIdentity, line.length(), line});
                                }
                            }
                            catch (IOException byteBuffer) {
                                FFDCFilter.processException((Throwable)byteBuffer, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog", (String)"248", (Object)this, (Object[])new Object[]{recoveryIdentity, recoveryGroup, isServerStartup});
                                if (!tc.isDebugEnabled()) break block15;
                                Tr.debug((TraceComponent)tc, (String)"Caught I/O exception when trying to write to file", (Object[])new Object[0]);
                            }
                        }
                    }
                    final File leaseFile = this._localLeaseLock.getFile();
                    if (!this.leaseLogWrittenInThisRun) break block14;
                    boolean success = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
                        static final long serialVersionUID = 8219157404829751789L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public Boolean run() {
                            return leaseFile.setLastModified(System.currentTimeMillis());
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register((String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$2", 2.class, null, null);
                        }
                    });
                    if (!success) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Unable to set the last modification time for {0}", (Object[])new Object[]{leaseFile.getCanonicalPath()});
                        }
                        break block14;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Successfully modified time for {0}", (Object[])new Object[]{leaseFile.getCanonicalPath()});
                    }
                    break block14;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Don't modify time as this is not the local server", (Object[])new Object[0]);
                }
            }
            catch (OverlappingFileLockException leaseFile) {
                FFDCFilter.processException((Throwable)leaseFile, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog", (String)"276", (Object)this, (Object[])new Object[]{recoveryIdentity, recoveryGroup, isServerStartup});
                if (!tc.isDebugEnabled()) break block14;
                Tr.debug((TraceComponent)tc, (String)"{0} already appears to be locked in another thread", (Object[])new Object[]{this._localLeaseLock.getFile().getCanonicalPath()});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"updateServerLease");
        }
    }

    @Override
    @ManualTrace
    public void deleteServerLease(final String recoveryIdentity, boolean isPeerServer) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"deleteServerLease", (Object[])new Object[]{this, recoveryIdentity, isPeerServer});
        }
        final File leaseFile = new File(_serverInstallLeaseLogDir + File.separator + recoveryIdentity);
        AccessController.doPrivileged(new PrivilegedAction<Void>(){
            static final long serialVersionUID = -2977439280196795625L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Override
            public Void run() {
                if (FileSharedServerLeaseLog.access$000().isDebugEnabled()) {
                    Tr.debug((TraceComponent)FileSharedServerLeaseLog.access$000(), (String)"Block until we acquire the lock on the control file", (Object[])new Object[0]);
                }
                try {
                    theChannel = new RandomAccessFile(FileSharedServerLeaseLog._controlFile, "rw").getChannel();
                    try {
                        lock = theChannel.lock();
                        try {
                            attemptDelete = true;
                            if (!recoveryIdentity.equals(FileSharedServerLeaseLog._localRecoveryIdentity)) {
                                leaseTime = leaseFile.lastModified();
                                if (FileSharedServerLeaseLog.access$000().isDebugEnabled()) {
                                    Tr.debug((TraceComponent)FileSharedServerLeaseLog.access$000(), (String)("recoveryId: " + recoveryIdentity + ", leaseTime: " + Utils.traceTime((long)leaseTime)), (Object[])new Object[0]);
                                }
                                if (!(pld = new PeerLeaseData(recoveryIdentity, leaseTime, FileSharedServerLeaseLog.access$100(FileSharedServerLeaseLog.this))).isExpired()) {
                                    if (FileSharedServerLeaseLog.access$000().isDebugEnabled()) {
                                        Tr.debug((TraceComponent)FileSharedServerLeaseLog.access$000(), (String)"The lease file has not expired, do not attempt deletion", (Object[])new Object[0]);
                                    }
                                    attemptDelete = false;
                                }
                            }
                            if (attemptDelete) {
                                block40: {
                                    if (FileSharedServerLeaseLog.access$000().isDebugEnabled()) {
                                        Tr.debug((TraceComponent)FileSharedServerLeaseLog.access$000(), (String)("Prepare to delete file " + leaseFile.getName() + ", in dir " + FileSharedServerLeaseLog._serverInstallLeaseLogDir), (Object[])new Object[0]);
                                    }
                                    fileExists = false;
                                    success = false;
                                    try {
                                        path = FileSystems.getDefault().getPath(System.getenv("WLP_USER_DIR"), new String[]{"shared", "leases", FileSharedServerLeaseLog._recoveryGroup, recoveryIdentity});
                                        fileExists = Files.exists(path, new LinkOption[0]);
                                        if (FileSharedServerLeaseLog.access$000().isDebugEnabled()) {
                                            Tr.debug((TraceComponent)FileSharedServerLeaseLog.access$000(), (String)("Does nio path exist? " + fileExists), (Object[])new Object[0]);
                                        }
                                        if (fileExists) {
                                            Files.delete(path);
                                            success = true;
                                        }
                                    }
                                    catch (Exception path) {
                                        FFDCFilter.processException((Throwable)path, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$3", (String)"343", (Object)this, (Object[])new Object[0]);
                                        if (!FileSharedServerLeaseLog.access$000().isDebugEnabled()) break block40;
                                        Tr.debug((TraceComponent)FileSharedServerLeaseLog.access$000(), (String)("Caught exception in nio delete code " + ex), (Object[])new Object[0]);
                                    }
                                }
                                if (success) {
                                    if (FileSharedServerLeaseLog.access$000().isDebugEnabled()) {
                                        Tr.debug((TraceComponent)FileSharedServerLeaseLog.access$000(), (String)("Successfully deleted lease file " + leaseFile.getName()), (Object[])new Object[0]);
                                    }
                                } else if (FileSharedServerLeaseLog.access$000().isDebugEnabled()) {
                                    Tr.debug((TraceComponent)FileSharedServerLeaseLog.access$000(), (String)"Failed to delete lease file", (Object[])new Object[0]);
                                }
                            }
                            ** if (lock == null) goto lbl-1000
                        }
                        catch (Throwable attemptDelete) {
                            FFDCFilter.processException((Throwable)attemptDelete, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$3", (String)"306", (Object)this, (Object[])new Object[0]);
                            if (lock != null) {
                                try {
                                    lock.close();
                                }
                                catch (Throwable var4_14) {
                                    FFDCFilter.processException((Throwable)var4_14, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$3", (String)"306", (Object)this, (Object[])new Object[0]);
                                    attemptDelete.addSuppressed(var4_14);
                                }
                            }
                            throw attemptDelete;
                        }
lbl-1000:
                        // 1 sources

                        {
                            lock.close();
                        }
lbl-1000:
                        // 2 sources

                        {
                        }
                        ** if (theChannel == null) goto lbl-1000
                    }
                    catch (Throwable lock) {
                        FFDCFilter.processException((Throwable)lock, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$3", (String)"306", (Object)this, (Object[])new Object[0]);
                        if (theChannel != null) {
                            try {
                                theChannel.close();
                            }
                            catch (Throwable attemptDelete) {
                                FFDCFilter.processException((Throwable)attemptDelete, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$3", (String)"306", (Object)this, (Object[])new Object[0]);
                                lock.addSuppressed(attemptDelete);
                            }
                        }
                        throw lock;
                    }
lbl-1000:
                    // 1 sources

                    {
                        theChannel.close();
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                }
                catch (IOException fileNumber) {
                    block41: {
                        try {
                            FFDCFilter.processException((Throwable)fileNumber, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$3", (String)"356", (Object)this, (Object[])new Object[0]);
                            if (!FileSharedServerLeaseLog.access$000().isDebugEnabled()) break block41;
                            Tr.debug((TraceComponent)FileSharedServerLeaseLog.access$000(), (String)"Exception locking lease control file: ", (Object[])new Object[]{e});
                        }
                        catch (Throwable var7_18) {
                            fileNumber = FileSharedServerLeaseLog._serverInstallLeaseLogDir.listFiles().length;
                            if (FileSharedServerLeaseLog.access$000().isDebugEnabled()) {
                                Tr.debug((TraceComponent)FileSharedServerLeaseLog.access$000(), (String)("Number of files contained in " + FileSharedServerLeaseLog._serverInstallLeaseLogDir + " is " + fileNumber), (Object[])new Object[0]);
                            }
                            fileArray = FileSharedServerLeaseLog._serverInstallLeaseLogDir.listFiles();
                            for (i = 0; i < fileArray.length; ++i) {
                                if (!FileSharedServerLeaseLog.access$000().isDebugEnabled()) continue;
                                Tr.debug((TraceComponent)FileSharedServerLeaseLog.access$000(), (String)("Lease file residing at " + i + " is " + fileArray[i].getName()), (Object[])new Object[0]);
                            }
                            if (fileNumber == 1) {
                                AccessController.doPrivileged(new PrivilegedAction<Void>(){
                                    static final long serialVersionUID = -6748691759082102182L;
                                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                                    /*
                                     * WARNING - void declaration
                                     */
                                    @Override
                                    public Void run() {
                                        block15: {
                                            boolean success = false;
                                            try {
                                                block16: {
                                                    boolean attemptDelete = true;
                                                    if (!attemptDelete) break block15;
                                                    if (tc.isDebugEnabled()) {
                                                        Tr.debug((TraceComponent)tc, (String)("Prepare to delete control file in dir " + _serverInstallLeaseLogDir), (Object[])new Object[0]);
                                                    }
                                                    boolean fileExists = false;
                                                    Path path = null;
                                                    try {
                                                        path = FileSystems.getDefault().getPath(System.getenv("WLP_USER_DIR"), "shared", "leases", _recoveryGroup, "control");
                                                        fileExists = Files.exists(path, new LinkOption[0]);
                                                        if (tc.isDebugEnabled()) {
                                                            Tr.debug((TraceComponent)tc, (String)("Does nio path for control file exist? " + fileExists), (Object[])new Object[0]);
                                                        }
                                                        if (fileExists) {
                                                            Files.delete(path);
                                                            success = true;
                                                        }
                                                        if (success) {
                                                            if (tc.isDebugEnabled()) {
                                                                Tr.debug((TraceComponent)tc, (String)"Successfully deleted control file", (Object[])new Object[0]);
                                                            }
                                                            path = FileSystems.getDefault().getPath(System.getenv("WLP_USER_DIR"), "shared", "leases", _recoveryGroup);
                                                            fileExists = Files.exists(path, new LinkOption[0]);
                                                            if (tc.isDebugEnabled()) {
                                                                Tr.debug((TraceComponent)tc, (String)("Does nio path for recovery group directory exist? " + fileExists), (Object[])new Object[0]);
                                                            }
                                                            if (fileExists) {
                                                                Files.delete(path);
                                                                success = true;
                                                                if (tc.isDebugEnabled()) {
                                                                    Tr.debug((TraceComponent)tc, (String)"Successfully deleted recovery group directory", (Object[])new Object[0]);
                                                                }
                                                            }
                                                        } else if (tc.isDebugEnabled()) {
                                                            Tr.debug((TraceComponent)tc, (String)"Failed to delete control file", (Object[])new Object[0]);
                                                        }
                                                    }
                                                    catch (Exception exception) {
                                                        void ex;
                                                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$3$1", (String)"421", (Object)this, (Object[])new Object[0]);
                                                        if (!tc.isDebugEnabled()) break block16;
                                                        Tr.debug((TraceComponent)tc, (String)("Caught exception in nio control file delete code " + ex), (Object[])new Object[0]);
                                                    }
                                                }
                                                if (!success && tc.isDebugEnabled()) {
                                                    Tr.debug((TraceComponent)tc, (String)"Failed to delete recovery group directory", (Object[])new Object[0]);
                                                }
                                            }
                                            catch (SecurityException attemptDelete) {
                                                void se;
                                                FFDCFilter.processException((Throwable)attemptDelete, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$3$1", (String)"431", (Object)this, (Object[])new Object[0]);
                                                if (!tc.isDebugEnabled()) break block15;
                                                Tr.debug((TraceComponent)tc, (String)("Caught SecurityException " + se), (Object[])new Object[0]);
                                            }
                                        }
                                        return null;
                                    }

                                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                                    static {
                                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$3$1", 1.class, null, null);
                                    }
                                });
                            }
                            throw var7_18;
                        }
                    }
                    fileNumber = FileSharedServerLeaseLog._serverInstallLeaseLogDir.listFiles().length;
                    if (FileSharedServerLeaseLog.access$000().isDebugEnabled()) {
                        Tr.debug((TraceComponent)FileSharedServerLeaseLog.access$000(), (String)("Number of files contained in " + FileSharedServerLeaseLog._serverInstallLeaseLogDir + " is " + fileNumber), (Object[])new Object[0]);
                    }
                    fileArray = FileSharedServerLeaseLog._serverInstallLeaseLogDir.listFiles();
                    for (i = 0; i < fileArray.length; ++i) {
                        if (!FileSharedServerLeaseLog.access$000().isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)FileSharedServerLeaseLog.access$000(), (String)("Lease file residing at " + i + " is " + fileArray[i].getName()), (Object[])new Object[0]);
                    }
                    if (fileNumber == 1) {
                        AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                    }
                }
                fileNumber = FileSharedServerLeaseLog._serverInstallLeaseLogDir.listFiles().length;
                if (FileSharedServerLeaseLog.access$000().isDebugEnabled()) {
                    Tr.debug((TraceComponent)FileSharedServerLeaseLog.access$000(), (String)("Number of files contained in " + FileSharedServerLeaseLog._serverInstallLeaseLogDir + " is " + fileNumber), (Object[])new Object[0]);
                }
                fileArray = FileSharedServerLeaseLog._serverInstallLeaseLogDir.listFiles();
                for (i = 0; i < fileArray.length; ++i) {
                    if (!FileSharedServerLeaseLog.access$000().isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)FileSharedServerLeaseLog.access$000(), (String)("Lease file residing at " + i + " is " + fileArray[i].getName()), (Object[])new Object[0]);
                }
                if (fileNumber == 1) {
                    AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                }
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$3", 3.class, null, null);
            }
        });
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deleteServerLease", (Object)this);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    public boolean claimPeerLeaseForRecovery(String recoveryIdentityToRecover, String myRecoveryIdentity, LeaseInfo leaseInfo) throws Exception {
        boolean claimedLease;
        block22: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"claimPeerLeaseForRecovery", (Object[])new Object[]{recoveryIdentityToRecover, myRecoveryIdentity, this});
            }
            claimedLease = false;
            FileChannel fChannel = null;
            try {
                boolean attemptClaim = true;
                final File leaseFile = new File(_serverInstallLeaseLogDir + File.separator + recoveryIdentityToRecover);
                long newleaseTime = AccessController.doPrivileged(new PrivilegedAction<Long>(){
                    static final long serialVersionUID = -8885195929755161712L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public Long run() {
                        return leaseFile.lastModified();
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$4", 4.class, null, null);
                    }
                });
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"recoveryId: {0}, new leaseTime: {1}", (Object[])new Object[]{recoveryIdentityToRecover, Utils.traceTime((long)newleaseTime)});
                }
                PeerLeaseData pld = new PeerLeaseData(recoveryIdentityToRecover, newleaseTime, this._leaseTimeout);
                if (newleaseTime == 0L || !pld.isExpired()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"The lease file has not expired, or does not exist do not attempt recovery", (Object[])new Object[0]);
                    }
                    attemptClaim = false;
                }
                if (attemptClaim) {
                    if (this.lockPeerLease(recoveryIdentityToRecover)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Attempt to read lease file", (Object[])new Object[0]);
                        }
                        if ((fChannel = this._peerLeaseLock.getFileChannel()) != null) {
                            int newline;
                            long fileSize = fChannel.size();
                            ByteBuffer buffer = ByteBuffer.allocate((int)fileSize);
                            fChannel.read(buffer);
                            buffer.flip();
                            String line = new String(buffer.array());
                            if (tc.isDebugEnabled()) {
                                Tr.info((TraceComponent)tc, (String)("On reading " + recoveryIdentityToRecover + " lease file length " + line.length() + " contains " + line), (Object[])new Object[0]);
                            }
                            if ((newline = line.indexOf("\n")) > 0) {
                                line = line.substring(0, newline);
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("String is now " + line + "of length " + line.length()), (Object[])new Object[0]);
                            }
                            leaseInfo.setLeaseDetail(new File(line));
                            ByteBuffer myBackendURL = null;
                            long filePos = 0L;
                            if (newline > 0) {
                                fChannel.truncate(newline + 1);
                                myBackendURL = ByteBuffer.wrap(this.getBackendURL().getBytes());
                                filePos = newline + 1;
                            } else {
                                myBackendURL = ByteBuffer.wrap(("\n" + this.getBackendURL()).getBytes());
                                filePos = fileSize;
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Write in our own backendURL {0} from file position {1}", (Object[])new Object[]{myBackendURL, filePos});
                            }
                            fChannel.write(myBackendURL, filePos);
                            fChannel.force(false);
                            if (tc.isDebugEnabled()) {
                                buffer = ByteBuffer.allocate((int)fChannel.size());
                                fChannel.position(0L);
                                fChannel.read(buffer);
                                buffer.flip();
                                line = new String(buffer.array());
                                Tr.info((TraceComponent)tc, (String)("On writing " + recoveryIdentityToRecover + " lease file length " + line.length() + " contains " + line), (Object[])new Object[0]);
                            }
                            claimedLease = true;
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Lease Lock's channel was null", (Object[])new Object[0]);
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Failed to lock or read lease file", (Object[])new Object[0]);
                    }
                }
                leaseFile.setLastModified(newleaseTime);
            }
            catch (IOException attemptClaim) {
                void e;
                FFDCFilter.processException((Throwable)attemptClaim, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog", (String)"557", (Object)this, (Object[])new Object[]{recoveryIdentityToRecover, myRecoveryIdentity, leaseInfo});
                if (!tc.isDebugEnabled()) break block22;
                Tr.debug((TraceComponent)tc, (String)("Caught an IOException - " + e), (Object[])new Object[0]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"claimPeerLeaseForRecovery", (Object)claimedLease);
        }
        return claimedLease;
    }

    @Override
    @ManualTrace
    public void getLeasesForPeers(final PeerLeaseTable peerLeaseTable, String recoveryGroup) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getLeasesForPeers", (Object[])new Object[]{peerLeaseTable, recoveryGroup, this});
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){
            static final long serialVersionUID = -6266805889018710477L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            /*
             * Unable to fully structure code
             */
            @Override
            public Void run() {
                block20: {
                    try {
                        theChannel = new RandomAccessFile(FileSharedServerLeaseLog._controlFile, "rw").getChannel();
                        try {
                            lock = theChannel.tryLock();
                            try {
                                thePeerFiles = FileSharedServerLeaseLog._leaseLogDirectory.listFiles();
                                if (thePeerFiles != null) {
                                    for (File peerFile : thePeerFiles) {
                                        if (peerFile.isDirectory()) continue;
                                        recoveryId = peerFile.getName();
                                        if (!recoveryId.equals(FileSharedServerLeaseLog._controlFile.getName())) {
                                            leaseTime = peerFile.lastModified();
                                            if (FileSharedServerLeaseLog.access$000().isEventEnabled()) {
                                                Tr.event((TraceComponent)FileSharedServerLeaseLog.access$000(), (String)"Lease Table: read recoveryId: {0}, read leaseTime: {1}", (Object[])new Object[]{recoveryId, Utils.traceTime((long)leaseTime)});
                                            }
                                            pld = new PeerLeaseData(recoveryId, leaseTime, FileSharedServerLeaseLog.access$100(FileSharedServerLeaseLog.this));
                                            peerLeaseTable.addPeerEntry(pld);
                                            continue;
                                        }
                                        if (!FileSharedServerLeaseLog.access$000().isDebugEnabled()) continue;
                                        Tr.debug((TraceComponent)FileSharedServerLeaseLog.access$000(), (String)"Exclude the control file from the list", (Object[])new Object[0]);
                                    }
                                } else if (FileSharedServerLeaseLog.access$000().isDebugEnabled()) {
                                    Tr.debug((TraceComponent)FileSharedServerLeaseLog.access$000(), (String)"No peer servers found", (Object[])new Object[0]);
                                }
                                ** if (lock == null) goto lbl-1000
                            }
                            catch (Throwable var3_6) {
                                FFDCFilter.processException((Throwable)var3_6, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$5", (String)"583", (Object)this, (Object[])new Object[0]);
                                if (lock != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable var4_9) {
                                        FFDCFilter.processException((Throwable)var4_9, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$5", (String)"583", (Object)this, (Object[])new Object[0]);
                                        var3_6.addSuppressed(var4_9);
                                    }
                                }
                                throw var3_6;
                            }
lbl-1000:
                            // 1 sources

                            {
                                lock.close();
                            }
lbl-1000:
                            // 2 sources

                            {
                            }
                            ** if (theChannel == null) goto lbl-1000
                        }
                        catch (Throwable var2_4) {
                            FFDCFilter.processException((Throwable)var2_4, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$5", (String)"583", (Object)this, (Object[])new Object[0]);
                            if (theChannel != null) {
                                try {
                                    theChannel.close();
                                }
                                catch (Throwable var3_7) {
                                    FFDCFilter.processException((Throwable)var3_7, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$5", (String)"583", (Object)this, (Object[])new Object[0]);
                                    var2_4.addSuppressed(var3_7);
                                }
                            }
                            throw var2_4;
                        }
lbl-1000:
                        // 1 sources

                        {
                            theChannel.close();
                        }
lbl-1000:
                        // 2 sources

                        {
                        }
                    }
                    catch (Exception theChannel) {
                        FFDCFilter.processException((Throwable)theChannel, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$5", (String)"611", (Object)this, (Object[])new Object[0]);
                        if (!FileSharedServerLeaseLog.access$000().isDebugEnabled()) break block20;
                        Tr.debug((TraceComponent)FileSharedServerLeaseLog.access$000(), (String)"Exception locking lease control file: ", (Object[])new Object[]{e});
                    }
                }
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$5", 5.class, null, null);
            }
        });
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getLeasesForPeers", (Object)this);
        }
    }

    @Override
    public boolean lockPeerLease(String recoveryIdentity) {
        final File leaseFile = new File(_serverInstallLeaseLogDir + File.separator + recoveryIdentity);
        boolean success = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
            static final long serialVersionUID = 7120735657850880645L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Boolean run() {
                boolean fileExists = true;
                if (leaseFile == null || !leaseFile.exists()) {
                    fileExists = false;
                }
                return fileExists;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$6", 6.class, null, null);
            }
        });
        if (!success) {
            return false;
        }
        this._peerLeaseLock = this.lock(leaseFile);
        return this._peerLeaseLock != null;
    }

    @FFDCIgnore(value={OverlappingFileLockException.class})
    private LeaseLock lock(final File leaseFile) {
        block10: {
            FileChannel fChannel;
            block9: {
                fChannel = AccessController.doPrivileged(new PrivilegedAction<FileChannel>(){
                    static final long serialVersionUID = -4946312878428417630L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public FileChannel run() {
                        FileChannel theChannel = null;
                        try {
                            theChannel = new RandomAccessFile(leaseFile, "rw").getChannel();
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            FFDCFilter.processException((Throwable)fileNotFoundException, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$7", (String)"675", (Object)this, (Object[])new Object[0]);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Caught FileNotFound exception when trying to lock lease file", (Object[])new Object[0]);
                            }
                            theChannel = null;
                        }
                        return theChannel;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$7", 7.class, null, null);
                    }
                });
                try {
                    FileLock fLock;
                    if (fChannel != null && (fLock = fChannel.tryLock()) != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"We have claimed the lock for {0}", (Object[])new Object[]{leaseFile.getPath()});
                        }
                        return new LeaseLock(fLock, fChannel, leaseFile);
                    }
                }
                catch (OverlappingFileLockException e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"{0} appears to be locked in another thread", (Object[])new Object[]{leaseFile.getPath()});
                    }
                }
                catch (IOException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog", (String)"700", (Object)this, (Object[])new Object[]{leaseFile});
                    if (!tc.isDebugEnabled()) break block9;
                    Tr.debug((TraceComponent)tc, (String)"Caught an IOException", (Object[])new Object[]{e});
                }
            }
            if (fChannel != null) {
                try {
                    fChannel.close();
                }
                catch (IOException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog", (String)"709", (Object)this, (Object[])new Object[]{leaseFile});
                    if (!tc.isDebugEnabled()) break block10;
                    Tr.debug((TraceComponent)tc, (String)"Caught an IOException on channel close", (Object[])new Object[]{e});
                }
            }
        }
        return null;
    }

    @Override
    public void releasePeerLease(String recoveryIdentity) throws Exception {
        if (this._peerLeaseLock != null) {
            this._peerLeaseLock.release();
            this._peerLeaseLock = null;
        }
    }

    @Override
    public boolean lockLocalLease(String recoveryIdentity) {
        File leaseFile = new File(_serverInstallLeaseLogDir + File.separator + recoveryIdentity);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Attempting to lock {0}", (Object[])new Object[]{leaseFile.getPath()});
        }
        this._localLeaseLock = this.lock(leaseFile);
        return this._localLeaseLock != null;
    }

    @Override
    public void releaseLocalLease(String recoveryIdentity) throws Exception {
        if (this._localLeaseLock != null) {
            this._localLeaseLock.release();
            this._localLeaseLock = null;
        }
    }

    @Override
    @ManualTrace
    public void setPeerRecoveryLeaseTimeout(int leaseTimeout) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setPeerRecoveryLeaseTimeout", (Object[])new Object[]{leaseTimeout});
        }
        this._leaseTimeout = leaseTimeout;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setPeerRecoveryLeaseTimeout", (Object)this);
        }
    }

    @Override
    @ManualTrace
    public String getBackendURL(String recoveryId) {
        String filename = _serverInstallLeaseLogDir + File.separator + recoveryId;
        String ret = null;
        int retries = 0;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getBackendURL", (Object[])new Object[]{filename});
        }
        while (true) {
            String string;
            BufferedReader reader2 = new BufferedReader(new FileReader(filename));
            try {
                reader2.readLine();
                ret = reader2.readLine();
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getBackendURL", (Object)ret);
                }
                string = ret;
            }
            catch (Throwable throwable) {
                try {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog", (String)"830", (Object)this, (Object[])new Object[]{recoveryId});
                    try {
                        reader2.close();
                    }
                    catch (Throwable throwable2) {
                        FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog", (String)"830", (Object)this, (Object[])new Object[]{recoveryId});
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException reader2) {
                    FFDCFilter.processException((Throwable)reader2, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog", (String)"839", (Object)this, (Object[])new Object[]{recoveryId});
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug((TraceComponent)tc, (String)"getBackendURL: Lease file not found. Recovery is probably done.", (Object[])new Object[0]);
                    break;
                }
                catch (IOException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog", (String)"843", (Object)this, (Object[])new Object[]{recoveryId});
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"getBackendURL: Lease was probably being renewed. Wait 500ms and try again.", (Object[])new Object[]{e});
                    }
                    if (retries++ > 60) {
                        if (!tc.isDebugEnabled()) break;
                        Tr.debug((TraceComponent)tc, (String)"getBackendURL: Couldn't access lease file even after retrying.", (Object[])new Object[0]);
                        break;
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog", (String)"857", (Object)this, (Object[])new Object[]{recoveryId});
                    }
                    continue;
                }
            }
            reader2.close();
            return string;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getBackendURL", (Object)ret);
        }
        return ret;
    }

    static /* synthetic */ int access$100(FileSharedServerLeaseLog x0) {
        return x0._leaseTimeout;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        _fileLeaseLog = new FileSharedServerLeaseLog();
        tc = Tr.register(FileSharedServerLeaseLog.class, (String)"Transaction", (String)"com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class LeaseLock {
        private final FileLock _leaseFileLock;
        private final FileChannel _leaseChannel;
        private final File _leaseFile;
        static final long serialVersionUID = -1435970096859428012L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @ManualTrace
        public LeaseLock(FileLock fLock, FileChannel fChannel, File leaseFile) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"LeaseLock", (Object[])new Object[]{fLock, fChannel, leaseFile});
            }
            this._leaseFileLock = fLock;
            this._leaseChannel = fChannel;
            this._leaseFile = leaseFile;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"LeaseLock", (Object)this);
            }
        }

        public void release() throws IOException {
            this._leaseFileLock.release();
            this._leaseChannel.close();
        }

        public FileLock getFileLock() {
            return this._leaseFileLock;
        }

        public File getFile() {
            return this._leaseFile;
        }

        public FileChannel getFileChannel() {
            return this._leaseChannel;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$LeaseLock", LeaseLock.class, null, null);
        }
    }
}

