/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.metrics23.writer;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.metrics.helper.PrometheusBuilder;
import com.ibm.ws.microprofile.metrics.writer.PrometheusMetricWriter;
import com.ibm.ws.microprofile.metrics23.helper.PrometheusBuilder23;
import com.ibm.ws.microprofile.metrics23.writer.OutputWriter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricType;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class PrometheusMetricWriter23
extends PrometheusMetricWriter
implements OutputWriter {
    private static final TraceComponent tc = Tr.register(PrometheusMetricWriter23.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
    static final long serialVersionUID = -2055724109383628261L;

    public PrometheusMetricWriter23(Writer writer, Locale locale) {
        super(writer, locale);
    }

    @Override
    protected void writeMetricMapAsPrometheus(StringBuilder builder, String registryName, Map<MetricID, Metric> metricMap, Map<String, Metadata> metricMetadataMap) {
        for (Map.Entry<String, Metadata> metadataEntry : metricMetadataMap.entrySet()) {
            String metricName = metadataEntry.getKey();
            String metricNamePrometheus = registryName + "_" + metricName;
            Metadata metricMetadata = metadataEntry.getValue();
            HashMap<MetricID, Metric> currentMetricMap = new HashMap<MetricID, Metric>();
            for (Map.Entry<MetricID, Metric> metricEntry : metricMap.entrySet()) {
                if (!metricEntry.getKey().getName().equals(metricName)) continue;
                currentMetricMap.put(metricEntry.getKey(), metricEntry.getValue());
            }
            if (currentMetricMap.isEmpty()) continue;
            String description = !metricMetadata.getDescription().isPresent() || ((String)metricMetadata.getDescription().get()).trim().isEmpty() ? "" : Tr.formatMessage((TraceComponent)tc, (Locale)this.locale, (String)((String)metricMetadata.getDescription().get()), (Object[])new Object[0]);
            String unit = (String)metricMetadata.getUnit().get();
            Map.Entry<String, Double> conversionAppendEntry = this.resolveConversionFactorXappendUnitEntry(unit);
            double conversionFactor = conversionAppendEntry.getValue();
            String appendUnit = conversionAppendEntry.getKey();
            if (metricMetadata.getTypeRaw().equals((Object)MetricType.COUNTER)) {
                PrometheusBuilder.buildCounter(builder, metricNamePrometheus, description, currentMetricMap);
                continue;
            }
            if (metricMetadata.getTypeRaw().equals((Object)MetricType.CONCURRENT_GAUGE)) {
                PrometheusBuilder.buildConcurrentGauge(builder, metricNamePrometheus, description, currentMetricMap);
                continue;
            }
            if (metricMetadata.getTypeRaw().equals((Object)MetricType.GAUGE)) {
                PrometheusBuilder.buildGauge(builder, metricNamePrometheus, description, currentMetricMap, conversionFactor, appendUnit);
                continue;
            }
            if (metricMetadata.getTypeRaw().equals((Object)MetricType.TIMER)) {
                PrometheusBuilder.buildTimer(builder, metricNamePrometheus, description, currentMetricMap);
                continue;
            }
            if (metricMetadata.getTypeRaw().equals((Object)MetricType.HISTOGRAM)) {
                PrometheusBuilder.buildHistogram(builder, metricNamePrometheus, description, currentMetricMap, conversionFactor, appendUnit);
                continue;
            }
            if (metricMetadata.getTypeRaw().equals((Object)MetricType.METERED)) {
                PrometheusBuilder.buildMeter(builder, metricNamePrometheus, description, currentMetricMap);
                continue;
            }
            if (metricMetadata.getTypeRaw().equals((Object)MetricType.SIMPLE_TIMER)) {
                PrometheusBuilder23.buildSimpleTimer(builder, metricNamePrometheus, description, currentMetricMap);
                continue;
            }
            Tr.event((TraceComponent)tc, (String)("Metadata " + metricMetadata.toString() + " does not have an appropriate Metric Type"), (Object[])new Object[0]);
        }
    }
}

