/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.jms.internal.dispatcher;

import com.ibm.jbatch.container.exception.BatchContainerRuntimeException;
import com.ibm.jbatch.container.exception.PersistenceException;
import com.ibm.jbatch.container.persistence.jpa.RemotablePartitionKey;
import com.ibm.jbatch.container.ws.BatchDispatcher;
import com.ibm.jbatch.container.ws.BatchDispatcherException;
import com.ibm.jbatch.container.ws.BatchJobNotLocalException;
import com.ibm.jbatch.container.ws.InstanceState;
import com.ibm.jbatch.container.ws.PartitionPlanConfig;
import com.ibm.jbatch.container.ws.PartitionReplyQueue;
import com.ibm.jbatch.container.ws.WSJobExecution;
import com.ibm.jbatch.container.ws.WSJobInstance;
import com.ibm.jbatch.container.ws.WSJobRepository;
import com.ibm.jbatch.container.ws.events.BatchEventsPublisher;
import com.ibm.jbatch.jsl.model.Step;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.csi.J2EENameFactory;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.LocalTransaction.LocalTransactionCoordinator;
import com.ibm.ws.LocalTransaction.LocalTransactionCurrent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jbatch.jms.internal.BatchJmsDispatcherException;
import com.ibm.ws.jbatch.jms.internal.BatchJmsEnvHelper;
import com.ibm.ws.jbatch.jms.internal.BatchJmsMessage;
import com.ibm.ws.jbatch.jms.internal.dispatcher.PartitionReplyQueueJms;
import com.ibm.ws.jbatch.jms.internal.dispatcher.StartPartitionPayload;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.tx.embeddable.EmbeddableWebSphereTransactionManager;
import com.ibm.wsspi.resource.ResourceConfig;
import com.ibm.wsspi.resource.ResourceConfigFactory;
import com.ibm.wsspi.resource.ResourceFactory;
import com.ibm.wsspi.resource.ResourceInfo;
import com.ibm.wsspi.threadcontext.ThreadContextDescriptor;
import com.ibm.wsspi.threadcontext.ThreadContextDeserializer;
import com.ibm.wsspi.threadcontext.WSContextService;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.batch.operations.JobExecutionNotRunningException;
import javax.batch.operations.JobSecurityException;
import javax.batch.operations.NoSuchJobExecutionException;
import javax.batch.runtime.BatchStatus;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(configurationPid={"com.ibm.ws.jbatch.jms.dispatcher"}, service={BatchDispatcher.class}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"service.vendor=IBM", "service.ranking:Integer=10", "type=JMS"})
public class BatchJmsDispatcher
implements BatchDispatcher {
    private static final TraceComponent tc = Tr.register(BatchJmsDispatcher.class, (String)"wsbatch", (String)"com.ibm.ws.jbatch.jms.internal.resources.BatchJmsMessages");
    private WSJobRepository jobRepository;
    private static final Map<String, ?>[] CapturedContexts = new Map[]{Collections.singletonMap("threadContextProvider", "com.ibm.ws.security.context.provider")};
    private WSContextService contextService;
    private BatchDispatcher localBatchDispatcher = null;
    private EmbeddableWebSphereTransactionManager tranMgr;
    private LocalTransactionCurrent localTranCurrent;
    private J2EENameFactory j2eeNameFactory;
    private ResourceFactory jmsQueueFactory;
    private ResourceFactory jmsConnectionFactory;
    private ResourceConfigFactory resourceConfigFactory;
    private BatchEventsPublisher eventsPublisher;
    private boolean deactivated = false;
    private byte[] initHelperLock = new byte[0];
    private volatile InitHelper initHelper;
    static final long serialVersionUID = -5186753321171131972L;

    @Reference(service=ResourceConfigFactory.class)
    protected void setResourceConfigFactory(ResourceConfigFactory svc) {
        this.resourceConfigFactory = svc;
    }

    @Reference(target="(id=unbound)")
    protected void setJMSQueueFactory(ResourceFactory factory, Map<String, String> serviceProps) {
        this.jmsQueueFactory = factory;
    }

    @Reference(target="(id=unbound)")
    protected void setJMSConnectionFactory(ResourceFactory factory, Map<String, String> serviceProps) {
        this.jmsConnectionFactory = factory;
    }

    protected void unsetJmsQueueFactory(ResourceFactory svc) {
        if (svc == this.jmsQueueFactory) {
            this.jmsQueueFactory = null;
        }
    }

    protected void unsetJmsConnectionFactory(ResourceFactory svc) {
        if (svc == this.jmsConnectionFactory) {
            this.jmsConnectionFactory = null;
        }
    }

    protected void unsetResourceConfigFactory(ResourceConfigFactory svc) {
        if (svc == this.resourceConfigFactory) {
            this.resourceConfigFactory = null;
        }
    }

    @Reference
    protected void setJ2EENameFactory(J2EENameFactory j2eeNameFactory) {
        this.j2eeNameFactory = j2eeNameFactory;
    }

    @Reference
    protected void setLocalTransactionCurrent(LocalTransactionCurrent ltc) {
        this.localTranCurrent = ltc;
    }

    @Reference(target="(service.pid=com.ibm.ws.context.manager)")
    protected void setContextService(WSContextService contextService) {
        this.contextService = contextService;
    }

    @Reference
    protected void setWSJobRepository(WSJobRepository ref) {
        this.jobRepository = ref;
    }

    @Reference(target="(type=Local)")
    protected void setLocalBatchDispatcher(BatchDispatcher ref) {
        this.localBatchDispatcher = ref;
    }

    @Reference
    protected void setTransactionManager(EmbeddableWebSphereTransactionManager svc) {
        this.tranMgr = svc;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setEventsPublisher(BatchEventsPublisher publisher) {
        this.eventsPublisher = publisher;
    }

    protected void unsetEventsPublisher(BatchEventsPublisher publisher) {
        if (this.eventsPublisher == publisher) {
            this.eventsPublisher = null;
        }
    }

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> config) throws Exception {
    }

    @Deactivate
    protected void deactivate(ComponentContext context, Map<String, Object> config) throws Exception {
        this.deactivated = true;
    }

    private ConnectionFactory getConnectionFactory() {
        if (this.deactivated) {
            throw new IllegalStateException("BatchJmsDispatchImpl component instance = " + this.toString() + ", has been deactivated");
        }
        return this.getInitHelper().jmsCf;
    }

    private Queue getQueue() {
        if (this.deactivated) {
            throw new IllegalStateException("BatchJmsDispatchImpl component instance = " + this.toString() + ", has been deactivated");
        }
        return this.getInitHelper().jmsQ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    InitHelper getInitHelper() {
        InitHelper result = this.initHelper;
        if (result != null) return result;
        byte[] byArray = this.initHelperLock;
        synchronized (this.initHelperLock) {
            result = this.initHelper;
            if (result != null) return result;
            this.initHelper = result = new InitHelper();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void start(WSJobInstance jobInstance, Properties jobParameters, long executionId) throws BatchJmsDispatcherException {
        block16: {
            block15: {
                block13: {
                    block14: {
                        savedException = null;
                        instanceId = jobInstance.getInstanceId();
                        correlationId = this.getCorrelationId(jobParameters);
                        securityContext = this.captureThreadContext(instanceId, -1L);
                        tranHelper = new TransactionHelper();
                        TransactionHelper.access$700(tranHelper, instanceId);
                        updatedJobInstance = this.jobRepository.updateJobInstanceStateOnQueued(instanceId);
                        if (updatedJobInstance.getInstanceState() == InstanceState.JMS_QUEUED) break block13;
                        if (!BatchJmsDispatcher.tc.isDebugEnabled()) break block14;
                        Tr.debug((TraceComponent)BatchJmsDispatcher.tc, (String)("Exiting since instanceState isn't equal to JMS_QUEUED, instead is: " + updatedJobInstance.getInstanceState()), (Object[])new Object[0]);
                    }
                    TransactionHelper.access$900(tranHelper, instanceId, -1L);
                    if (savedException != null) {
                        this.markInstanceExecutionFailed(instanceId, executionId, correlationId);
                        throw new BatchJmsDispatcherException(savedException, instanceId, -1L);
                    }
                    return;
                }
                try {
                    this.sendStartMessage(jobInstance, jobParameters, securityContext, executionId);
                    if (BatchJmsEnvHelper.isTriggerDispatcherQueueException()) {
                        throw new JMSException("Throws jms exception to simulate failure in queue jms message");
                    }
                    if (!BatchJmsEnvHelper.isTriggerDispatcherDbException()) break block15;
                    throw new PersistenceException((Throwable)new BatchContainerRuntimeException("Throws persistence exception to simulate failure in db update"));
                }
                catch (JMSException updatedJobInstance) {
                    FFDCFilter.processException((Throwable)updatedJobInstance, (String)"com.ibm.ws.jbatch.jms.internal.dispatcher.BatchJmsDispatcher", (String)"405", (Object)this, (Object[])new Object[]{jobInstance, jobParameters, executionId});
                    savedException = jmsException.getLinkedException() != null ? jmsException.getLinkedException() : jmsException;
                    TransactionHelper.access$800(tranHelper);
                    TransactionHelper.access$900(tranHelper, instanceId, -1L);
                    if (savedException != null) {
                        this.markInstanceExecutionFailed(instanceId, executionId, correlationId);
                        throw new BatchJmsDispatcherException(savedException, instanceId, -1L);
                    }
                    break block16;
                }
                catch (Exception jmsException) {
                    FFDCFilter.processException((Throwable)jmsException, (String)"com.ibm.ws.jbatch.jms.internal.dispatcher.BatchJmsDispatcher", (String)"408", (Object)this, (Object[])new Object[]{jobInstance, jobParameters, executionId});
                    savedException = allOtherException;
                    TransactionHelper.access$800(tranHelper);
                    {
                        catch (Throwable var12_12) {
                            TransactionHelper.access$900(tranHelper, instanceId, -1L);
                            if (savedException != null) {
                                this.markInstanceExecutionFailed(instanceId, executionId, correlationId);
                                throw new BatchJmsDispatcherException(savedException, instanceId, -1L);
                            }
                            throw var12_12;
                        }
                    }
                    TransactionHelper.access$900(tranHelper, instanceId, -1L);
                    if (savedException != null) {
                        this.markInstanceExecutionFailed(instanceId, executionId, correlationId);
                        throw new BatchJmsDispatcherException(savedException, instanceId, -1L);
                    } else {
                        ** GOTO lbl57
                    }
                }
            }
            TransactionHelper.access$900(tranHelper, instanceId, -1L);
            if (savedException != null) {
                this.markInstanceExecutionFailed(instanceId, executionId, correlationId);
                throw new BatchJmsDispatcherException(savedException, instanceId, -1L);
            }
        }
        this.publishEvent(instanceId, "batch/jobs/instance/jms_queued", correlationId);
    }

    private String getCorrelationId(Properties jobParameters) {
        if (jobParameters != null) {
            return jobParameters.getProperty("com_ibm_ws_batch_events_correlationId", null);
        }
        return null;
    }

    public void markInstanceExecutionFailed(long instanceId, long executionId, String correlationId) {
        this.jobRepository.updateJobInstanceAndExecutionWithInstanceStateAndBatchStatus(instanceId, executionId, InstanceState.FAILED, BatchStatus.FAILED);
        this.publishEvent(instanceId, "batch/jobs/instance/failed", correlationId);
        this.publishExecutionEvent(executionId, "batch/jobs/execution/failed", correlationId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void restartInstance(long instanceId, Properties restartParameters, long executionId) throws BatchJmsDispatcherException {
        block14: {
            block12: {
                block13: {
                    savedException = null;
                    correlationId = this.getCorrelationId(restartParameters);
                    j2eeName = this.createJ2EEName(this.jobRepository.getJobInstance(instanceId).getAmcName());
                    securityContext = this.captureThreadContext(instanceId, executionId);
                    tranHelper = new TransactionHelper();
                    TransactionHelper.access$700(tranHelper, instanceId);
                    updatedJobInstance = this.jobRepository.updateJobInstanceStateOnQueued(instanceId);
                    if (updatedJobInstance.getInstanceState() == InstanceState.JMS_QUEUED) break block12;
                    if (!BatchJmsDispatcher.tc.isDebugEnabled()) break block13;
                    Tr.debug((TraceComponent)BatchJmsDispatcher.tc, (String)("Exiting since instanceState isn't equal to JMS_QUEUED, instead is: " + updatedJobInstance.getInstanceState()), (Object[])new Object[0]);
                }
                TransactionHelper.access$900(tranHelper, instanceId, executionId);
                if (savedException != null) {
                    this.markInstanceExecutionFailed(instanceId, executionId, correlationId);
                    throw new BatchJmsDispatcherException(savedException, instanceId, executionId);
                }
                return;
            }
            try {
                this.sendRestartMessage(instanceId, executionId, j2eeName, restartParameters, securityContext);
            }
            catch (JMSException updatedJobInstance) {
                FFDCFilter.processException((Throwable)updatedJobInstance, (String)"com.ibm.ws.jbatch.jms.internal.dispatcher.BatchJmsDispatcher", (String)"486", (Object)this, (Object[])new Object[]{instanceId, restartParameters, executionId});
                savedException = e.getLinkedException() != null ? e.getLinkedException() : e;
                TransactionHelper.access$800(tranHelper);
                TransactionHelper.access$900(tranHelper, instanceId, executionId);
                if (savedException != null) {
                    this.markInstanceExecutionFailed(instanceId, executionId, correlationId);
                    throw new BatchJmsDispatcherException(savedException, instanceId, executionId);
                }
                break block14;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jbatch.jms.internal.dispatcher.BatchJmsDispatcher", (String)"490", (Object)this, (Object[])new Object[]{instanceId, restartParameters, executionId});
                savedException = allOtherException;
                TransactionHelper.access$800(tranHelper);
                {
                    catch (Throwable var12_12) {
                        TransactionHelper.access$900(tranHelper, instanceId, executionId);
                        if (savedException != null) {
                            this.markInstanceExecutionFailed(instanceId, executionId, correlationId);
                            throw new BatchJmsDispatcherException(savedException, instanceId, executionId);
                        }
                        throw var12_12;
                    }
                }
                TransactionHelper.access$900(tranHelper, instanceId, executionId);
                if (savedException != null) {
                    this.markInstanceExecutionFailed(instanceId, executionId, correlationId);
                    throw new BatchJmsDispatcherException(savedException, instanceId, executionId);
                } else {
                    ** GOTO lbl52
                }
            }
            TransactionHelper.access$900(tranHelper, instanceId, executionId);
            if (savedException != null) {
                this.markInstanceExecutionFailed(instanceId, executionId, correlationId);
                throw new BatchJmsDispatcherException(savedException, instanceId, executionId);
            }
        }
        this.publishEvent(instanceId, "batch/jobs/instance/jms_queued", correlationId);
    }

    private void publishEvent(long instanceId, String event, String correlationId) {
        WSJobInstance updatedInstance;
        if (this.eventsPublisher != null && (updatedInstance = this.jobRepository.getJobInstance(instanceId)) != null) {
            this.eventsPublisher.publishJobInstanceEvent(updatedInstance, event, correlationId);
        }
    }

    private void publishExecutionEvent(long executionId, String event, String correlationId) {
        WSJobExecution updatedExecution;
        if (this.eventsPublisher != null && (updatedExecution = this.jobRepository.getJobExecution(executionId)) != null) {
            this.eventsPublisher.publishJobExecutionEvent(updatedExecution, event, correlationId);
        }
    }

    public void stop(long executionId) throws NoSuchJobExecutionException, JobExecutionNotRunningException, JobSecurityException, BatchDispatcherException, BatchJobNotLocalException {
        this.localBatchDispatcher.stop(executionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendStartMessage(WSJobInstance jobInstance, Properties jobParameters, byte[] securityContext, long executionId) throws JMSException {
        Connection jmsConnection = null;
        try {
            jmsConnection = this.getConnectionFactory().createConnection();
            Session jmsSession = jmsConnection.createSession(false, 1);
            MessageProducer messageProducer = jmsSession.createProducer((Destination)this.getQueue());
            this.setMessageProperties(jobInstance.getInstanceId(), jobParameters, false, messageProducer);
            BatchJmsMessage jmsMsg = new BatchJmsMessage((Message)jmsSession.createMapMessage()).setVersion().setJ2eeName(this.createJ2EEName(jobInstance.getAmcName())).setInstanceId(jobInstance.getInstanceId()).setExecutionId(executionId).setOperation("Start").setJobParameters(jobParameters).setSecurityContext(securityContext).setBatchWorkType("Job");
            messageProducer.send(jmsMsg.getMessage());
        }
        finally {
            this.closeJmsConnection(jmsConnection);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setMessageProperties(long instanceId, Properties jobParameters, Boolean isPartition, MessageProducer messageProducer) throws JMSException, BatchJmsDispatcherException {
        String delayS;
        String priorityS = jobParameters.getProperty("com_ibm_ws_batch_message_priority");
        if (priorityS != null) {
            try {
                int priority = Integer.parseInt(priorityS);
                messageProducer.setPriority(priority);
            }
            catch (NumberFormatException priority) {
                void nfe;
                FFDCFilter.processException((Throwable)priority, (String)"com.ibm.ws.jbatch.jms.internal.dispatcher.BatchJmsDispatcher", (String)"610", (Object)this, (Object[])new Object[]{instanceId, jobParameters, isPartition, messageProducer});
                throw new BatchJmsDispatcherException((Throwable)nfe, instanceId, -1L);
            }
        }
        if (!isPartition.booleanValue() && (delayS = jobParameters.getProperty("com_ibm_ws_batch_message_deliveryDelay")) != null) {
            try {
                long delay = Long.parseLong(delayS);
                messageProducer.setDeliveryDelay(delay);
            }
            catch (NumberFormatException delay) {
                void nfe;
                FFDCFilter.processException((Throwable)delay, (String)"com.ibm.ws.jbatch.jms.internal.dispatcher.BatchJmsDispatcher", (String)"624", (Object)this, (Object[])new Object[]{instanceId, jobParameters, isPartition, messageProducer});
                throw new BatchJmsDispatcherException((Throwable)nfe, instanceId, -1L);
            }
        }
    }

    private void closeJmsConnection(Connection jmsConnection) {
        try {
            if (jmsConnection != null) {
                jmsConnection.close();
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, (String)"com.ibm.ws.jbatch.jms.internal.dispatcher.BatchJmsDispatcher", (String)"643", (Object)this, (Object[])new Object[]{jmsConnection});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRestartMessage(long instanceId, long executionId, J2EEName j2eeName, Properties restartParameters, byte[] securityContext) throws JMSException {
        Connection jmsConnection = null;
        try {
            jmsConnection = this.getConnectionFactory().createConnection();
            Session jmsSession = jmsConnection.createSession(false, 1);
            MessageProducer messageProducer = jmsSession.createProducer((Destination)this.getQueue());
            this.setMessageProperties(instanceId, restartParameters, false, messageProducer);
            BatchJmsMessage jmsMsg = new BatchJmsMessage((Message)jmsSession.createMapMessage()).setVersion().setJ2eeName(j2eeName).setOperation("Restart").setInstanceId(instanceId).setExecutionId(executionId).setJobParameters(restartParameters).setSecurityContext(securityContext).setBatchWorkType("Job");
            messageProducer.send(jmsMsg.getMessage());
        }
        finally {
            this.closeJmsConnection(jmsConnection);
        }
    }

    /*
     * WARNING - void declaration
     */
    public PartitionReplyQueue createPartitionReplyQueue() throws BatchJmsDispatcherException {
        try {
            return new PartitionReplyQueueJms(this.getConnectionFactory().createConnection());
        }
        catch (JMSException jMSException) {
            void je;
            FFDCFilter.processException((Throwable)jMSException, (String)"com.ibm.ws.jbatch.jms.internal.dispatcher.BatchJmsDispatcher", (String)"709", (Object)this, (Object[])new Object[0]);
            throw new BatchJmsDispatcherException("Could not create JmsPartitionReplyQueue.", (Throwable)je);
        }
    }

    public Connection getJmsConnection() throws JMSException {
        return this.getConnectionFactory().createConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void startPartition(PartitionPlanConfig partitionPlanConfig, Step step, PartitionReplyQueue partitionReplyQueue) throws BatchJmsDispatcherException {
        block7: {
            Exception savedException = null;
            byte[] securityContext = this.captureThreadContext(partitionPlanConfig.getTopLevelInstanceId(), partitionPlanConfig.getTopLevelExecutionId());
            J2EEName j2eeName = this.createJ2EEName(this.jobRepository.getBatchAppNameFromExecution(partitionPlanConfig.getTopLevelExecutionId()));
            RemotablePartitionKey partitionKey = new RemotablePartitionKey(partitionPlanConfig.getTopLevelExecutionId(), partitionPlanConfig.getStepName(), Integer.valueOf(partitionPlanConfig.getPartitionNumber()));
            TransactionHelper tranHelper = new TransactionHelper();
            tranHelper.partitionPreInvoke(partitionKey);
            try {
                this.sendStartPartitionMessage(partitionPlanConfig, step, j2eeName, securityContext, (PartitionReplyQueueJms)partitionReplyQueue);
                this.jobRepository.createRemotablePartition(partitionKey);
            }
            catch (JMSException errorMessage) {
                void jmsException;
                FFDCFilter.processException((Throwable)errorMessage, (String)"com.ibm.ws.jbatch.jms.internal.dispatcher.BatchJmsDispatcher", (String)"756", (Object)this, (Object[])new Object[]{partitionPlanConfig, step, partitionReplyQueue});
                savedException = jmsException.getLinkedException() != null ? jmsException.getLinkedException() : jmsException;
                tranHelper.setTranRollback();
            }
            catch (Exception errorMessage) {
                void allOtherException;
                FFDCFilter.processException((Throwable)errorMessage, (String)"com.ibm.ws.jbatch.jms.internal.dispatcher.BatchJmsDispatcher", (String)"759", (Object)this, (Object[])new Object[]{partitionPlanConfig, step, partitionReplyQueue});
                savedException = allOtherException;
                tranHelper.setTranRollback();
            }
            finally {
                tranHelper.partitionPostInvoke(partitionKey);
                if (savedException == null) break block7;
                String errorMessage = "Unable to Dispatch the partition " + partitionKey.toString();
                throw new BatchJmsDispatcherException(errorMessage);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendStartPartitionMessage(PartitionPlanConfig partitionPlanConfig, Step step, J2EEName j2eeName, byte[] securityContext, PartitionReplyQueueJms partitionReplyQueue) throws JMSException, IOException {
        Connection jmsConnection = null;
        try {
            jmsConnection = this.getConnectionFactory().createConnection();
            Session jmsSession = jmsConnection.createSession(false, 1);
            MessageProducer messageProducer = jmsSession.createProducer((Destination)this.getQueue());
            Properties jobParameters = this.jobRepository.getJobExecution(partitionPlanConfig.getTopLevelExecutionId()).getJobParameters();
            this.setMessageProperties(partitionPlanConfig.getTopLevelInstanceId(), jobParameters, true, messageProducer);
            BatchJmsMessage jmsMsg = new BatchJmsMessage((Message)jmsSession.createObjectMessage()).setVersion().setJ2eeName(j2eeName).setBatchWorkType("Partition").setOperation("PartitionExecute").setStepName(partitionPlanConfig.getStepName()).setJmsReplyToQueue(partitionReplyQueue.getJmsReplyToQueue()).setExecutionId(partitionPlanConfig.getTopLevelExecutionId()).setPartitionNumber(partitionPlanConfig.getPartitionNumber()).setJobParameters(jobParameters).setStartPartitionPayload(new StartPartitionPayload(partitionPlanConfig, step, securityContext));
            messageProducer.send(jmsMsg.getMessage());
        }
        finally {
            this.closeJmsConnection(jmsConnection);
        }
    }

    /*
     * WARNING - void declaration
     */
    public byte[] captureThreadContext(long instanceId, long executionId) {
        try {
            return this.contextService.captureThreadContext(new HashMap(), (Map[])CapturedContexts).serialize();
        }
        catch (IOException iOException) {
            void ioe;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.jbatch.jms.internal.dispatcher.BatchJmsDispatcher", (String)"838", (Object)this, (Object[])new Object[]{instanceId, executionId});
            throw new BatchJmsDispatcherException((Throwable)ioe, instanceId, executionId);
        }
    }

    public <T> T createContextualProxy(byte[] serializedContext, T instance, Class<T> intf) throws IOException, ClassNotFoundException {
        HashMap<String, String> execProps = new HashMap<String, String>();
        execProps.put("javax.enterprise.concurrent.IDENTITY_NAME", "batch.job");
        execProps.put("com.ibm.ws.concurrent.TASK_OWNER", "batch.runtime");
        ThreadContextDescriptor tcDescriptor = ThreadContextDeserializer.deserialize((byte[])serializedContext, execProps);
        return (T)this.contextService.createContextualProxy(tcDescriptor, instance, intf);
    }

    protected J2EEName createJ2EEName(String j2eeName) {
        return this.j2eeNameFactory.create(j2eeName.getBytes(StandardCharsets.UTF_8));
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class InitHelper {
        private ConnectionFactory jmsCf = null;
        private Queue jmsQ = null;
        static final long serialVersionUID = 7114631440275993523L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private InitHelper() {
            this.initJMSResources();
        }

        /*
         * WARNING - void declaration
         */
        private void initJMSResources() {
            try {
                ResourceConfig resourceConfig = BatchJmsDispatcher.this.resourceConfigFactory.createResourceConfig(Queue.class.getName());
                this.jmsQ = (Queue)BatchJmsDispatcher.this.jmsQueueFactory.createResource((ResourceInfo)resourceConfig);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("        jmsQ = " + this.jmsQ.getQueueName() + this.jmsQ.toString()), (Object[])new Object[0]);
                }
                ResourceConfig cfResourceConfig = BatchJmsDispatcher.this.resourceConfigFactory.createResourceConfig(ConnectionFactory.class.getName());
                cfResourceConfig.setResAuthType(0);
                this.jmsCf = (ConnectionFactory)BatchJmsDispatcher.this.jmsConnectionFactory.createResource((ResourceInfo)cfResourceConfig);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("        jmsCf = " + this.jmsCf.toString()), (Object[])new Object[0]);
                }
            }
            catch (Exception resourceConfig) {
                void e;
                FFDCFilter.processException((Throwable)resourceConfig, (String)"com.ibm.ws.jbatch.jms.internal.dispatcher.BatchJmsDispatcher$InitHelper", (String)"342", (Object)this, (Object[])new Object[0]);
                Tr.error((TraceComponent)tc, (String)"error.batch.dispatcher.jms.resource.activate", (Object[])new Object[]{e});
                throw new RuntimeException((Throwable)e);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jbatch.jms.internal.dispatcher.BatchJmsDispatcher$InitHelper", InitHelper.class, (String)"wsbatch", null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    class TransactionHelper {
        private LocalTransactionCurrent ltcCurrent;
        private LocalTransactionCoordinator suspendedLTC;
        static final long serialVersionUID = -2783961816903301520L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        TransactionHelper() {
        }

        /*
         * WARNING - void declaration
         */
        private void preInvoke(long instanceId) {
            try {
                this.suspendExistingLTC();
                this.startTransaction();
            }
            catch (Exception exception) {
                void txException;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jbatch.jms.internal.dispatcher.BatchJmsDispatcher$TransactionHelper", (String)"899", (Object)this, (Object[])new Object[]{instanceId});
                throw new BatchJmsDispatcherException((Throwable)txException, instanceId);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void partitionPreInvoke(RemotablePartitionKey rpk) {
            try {
                this.suspendExistingLTC();
                this.startTransaction();
            }
            catch (Exception exception) {
                void txException;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jbatch.jms.internal.dispatcher.BatchJmsDispatcher$TransactionHelper", (String)"913", (Object)this, (Object[])new Object[]{rpk});
                String errorMessage = "Unable to Dispatch the partition " + rpk.toString();
                throw new BatchJmsDispatcherException(errorMessage, (Throwable)txException);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void partitionPostInvoke(RemotablePartitionKey rpk) {
            try {
                this.rollbackOrCommitTransactionAsRequired();
            }
            catch (Exception exception) {
                void txException;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jbatch.jms.internal.dispatcher.BatchJmsDispatcher$TransactionHelper", (String)"927", (Object)this, (Object[])new Object[]{rpk});
                String errorMessage = "Unable to Dispatch the partition " + rpk.toString();
                throw new BatchJmsDispatcherException(errorMessage, (Throwable)txException);
            }
            finally {
                this.resumeExistingLTC();
            }
        }

        /*
         * WARNING - void declaration
         */
        private void postInvoke(long instanceId, long executionId) {
            try {
                this.rollbackOrCommitTransactionAsRequired();
            }
            catch (Exception exception) {
                void txException;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jbatch.jms.internal.dispatcher.BatchJmsDispatcher$TransactionHelper", (String)"944", (Object)this, (Object[])new Object[]{instanceId, executionId});
                throw new BatchJmsDispatcherException((Throwable)txException, instanceId, executionId);
            }
            finally {
                this.resumeExistingLTC();
            }
        }

        private void suspendExistingLTC() throws SystemException {
            int tranStatus = BatchJmsDispatcher.this.tranMgr.getStatus();
            this.ltcCurrent = tranStatus == 6 ? BatchJmsDispatcher.this.localTranCurrent : null;
            this.suspendedLTC = this.ltcCurrent == null ? null : this.ltcCurrent.suspend();
        }

        private void resumeExistingLTC() {
            if (this.suspendedLTC != null) {
                this.ltcCurrent.resume(this.suspendedLTC);
            }
        }

        private void startTransaction() throws SystemException, NotSupportedException {
            BatchJmsDispatcher.this.tranMgr.begin();
        }

        private void rollbackOrCommitTransactionAsRequired() throws IllegalStateException, SecurityException, SystemException, RollbackException, HeuristicMixedException, HeuristicRollbackException {
            if (BatchJmsDispatcher.this.tranMgr.getStatus() == 1) {
                BatchJmsDispatcher.this.tranMgr.rollback();
            } else {
                BatchJmsDispatcher.this.tranMgr.commit();
            }
        }

        private void setTranRollback() {
            try {
                BatchJmsDispatcher.this.tranMgr.setRollbackOnly();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jbatch.jms.internal.dispatcher.BatchJmsDispatcher$TransactionHelper", (String)"1008", (Object)this, (Object[])new Object[0]);
            }
        }

        static /* synthetic */ void access$700(TransactionHelper x0, long x1) {
            x0.preInvoke(x1);
        }

        static /* synthetic */ void access$900(TransactionHelper x0, long x1, long x2) {
            x0.postInvoke(x1, x2);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jbatch.jms.internal.dispatcher.BatchJmsDispatcher$TransactionHelper", TransactionHelper.class, (String)"wsbatch", null);
        }
    }
}

