/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.typesafe.impl.cdi;

import io.smallrye.graphql.client.typesafe.api.GraphQlClientApi;
import io.smallrye.graphql.client.typesafe.impl.cdi.GraphQlClientBean;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.WithAnnotations;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQlClientExtension
implements Extension {
    private static final Logger log = LoggerFactory.getLogger(GraphQlClientExtension.class);
    private final List<Class<?>> apis = new ArrayList();

    public void registerGraphQlClientApis(@Observes @WithAnnotations(value={GraphQlClientApi.class}) ProcessAnnotatedType<?> type) {
        Class javaClass = type.getAnnotatedType().getJavaClass();
        if (javaClass.isInterface()) {
            log.info("register {}", (Object)javaClass.getName());
            this.apis.add(javaClass);
        } else {
            log.error("failed to register", (Throwable)new IllegalArgumentException("a GraphQlClientApi must be an interface: " + javaClass.getName()));
        }
    }

    public void createProxies(@Observes AfterBeanDiscovery afterBeanDiscovery) {
        for (Class<?> api : this.apis) {
            afterBeanDiscovery.addBean(new GraphQlClientBean(api));
        }
    }
}

