/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.typesafe.impl.json;

import io.smallrye.graphql.client.typesafe.api.ErrorOr;
import io.smallrye.graphql.client.typesafe.api.GraphQlClientError;
import io.smallrye.graphql.client.typesafe.api.GraphQlClientException;
import io.smallrye.graphql.client.typesafe.impl.json.GraphQlClientErrorImpl;
import io.smallrye.graphql.client.typesafe.impl.json.JsonArrayReader;
import io.smallrye.graphql.client.typesafe.impl.json.JsonBooleanReader;
import io.smallrye.graphql.client.typesafe.impl.json.JsonNullReader;
import io.smallrye.graphql.client.typesafe.impl.json.JsonNumberReader;
import io.smallrye.graphql.client.typesafe.impl.json.JsonObjectReader;
import io.smallrye.graphql.client.typesafe.impl.json.JsonStringReader;
import io.smallrye.graphql.client.typesafe.impl.json.JsonUtils;
import io.smallrye.graphql.client.typesafe.impl.json.Location;
import io.smallrye.graphql.client.typesafe.impl.json.Reader;
import io.smallrye.graphql.client.typesafe.impl.reflection.TypeInfo;
import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class JsonReader
extends Reader<JsonValue> {
    public static Object readJson(String description, TypeInfo type, JsonValue value) {
        return JsonReader.readJson(new Location(type, description), type, value);
    }

    static Object readJson(Location location, TypeInfo type, JsonValue value) {
        return new JsonReader(type, location, value).read();
    }

    private JsonReader(TypeInfo type, Location location, JsonValue value) {
        super(type, location, value);
    }

    @Override
    Object read() {
        if (this.type.isOptional()) {
            return Optional.ofNullable(JsonReader.readJson(this.location, this.type.getItemType(), this.value));
        }
        if (this.type.isErrorOr()) {
            return this.readErrorOr();
        }
        if (this.isListOfErrors(this.value) && !this.isGraphQlErrorsType()) {
            throw this.cantApplyErrors(this.readGraphQlClientErrors());
        }
        return this.reader(this.location).read();
    }

    private ErrorOr<Object> readErrorOr() {
        if (this.isListOfErrors(this.value)) {
            return ErrorOr.ofErrors(this.readGraphQlClientErrors());
        }
        return ErrorOr.of(JsonReader.readJson(this.location, this.type.getItemType(), this.value));
    }

    private List<GraphQlClientError> readGraphQlClientErrors() {
        return this.value.asJsonArray().stream().map(item -> (GraphQlClientError)JsonReader.readJson(this.location, TypeInfo.of(GraphQlClientErrorImpl.class), item)).collect(Collectors.toList());
    }

    private boolean isListOfErrors(JsonValue jsonValue) {
        return JsonUtils.isListOf(jsonValue, ErrorOr.class.getSimpleName());
    }

    private boolean isGraphQlErrorsType() {
        return GraphQlClientError.class.isAssignableFrom(this.type.getRawType());
    }

    private GraphQlClientException cantApplyErrors(List<GraphQlClientError> errors) {
        return new GraphQlClientException("errors from service (and we can't apply them to a " + this.location + "; see ErrorOr)", errors);
    }

    private Reader<?> reader(Location location) {
        switch (this.value.getValueType()) {
            case ARRAY: {
                return new JsonArrayReader(this.type, location, (JsonArray)this.value);
            }
            case OBJECT: {
                return new JsonObjectReader(this.type, location, (JsonObject)this.value);
            }
            case STRING: {
                return new JsonStringReader(this.type, location, (JsonString)this.value);
            }
            case NUMBER: {
                return new JsonNumberReader(this.type, location, (JsonNumber)this.value);
            }
            case TRUE: 
            case FALSE: {
                return new JsonBooleanReader(this.type, location, this.value);
            }
            case NULL: {
                return new JsonNullReader(this.type, location, this.value);
            }
        }
        throw new GraphQlClientException("unreachable code");
    }
}

