/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.error;

import graphql.ExceptionWhileDataFetching;
import graphql.GraphQLError;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.DataFetcherExceptionHandlerParameters;
import graphql.execution.DataFetcherExceptionHandlerResult;
import graphql.execution.ResultPath;
import graphql.language.SourceLocation;
import io.smallrye.graphql.SmallRyeGraphQLServerLogging;
import io.smallrye.graphql.bootstrap.Config;
import io.smallrye.graphql.execution.datafetcher.DataFetcherException;
import io.smallrye.graphql.execution.error.ExceptionLists;
import io.smallrye.graphql.execution.error.GraphQLExceptionWhileDataFetching;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletionException;

public class ExceptionHandler
implements DataFetcherExceptionHandler {
    private final Config config;
    private final ExceptionLists exceptionLists;
    protected List<String> unwrapExceptions = new ArrayList<String>();
    private static final List<String> DEFAULT_EXCEPTION_UNWRAP = new ArrayList<String>();

    public ExceptionHandler(Config config) {
        this.config = config;
        this.exceptionLists = new ExceptionLists(config.getHideErrorMessageList(), config.getShowErrorMessageList());
        if (config.getUnwrapExceptions().isPresent()) {
            this.unwrapExceptions.addAll((Collection<String>)config.getUnwrapExceptions().get());
        }
        this.unwrapExceptions.addAll(DEFAULT_EXCEPTION_UNWRAP);
    }

    public DataFetcherExceptionHandlerResult onException(DataFetcherExceptionHandlerParameters handlerParameters) {
        Throwable throwable = handlerParameters.getException();
        throwable = this.unwrapThrowable(throwable);
        SourceLocation sourceLocation = handlerParameters.getSourceLocation();
        ResultPath path = handlerParameters.getPath();
        ExceptionWhileDataFetching error = this.getExceptionWhileDataFetching(throwable, sourceLocation, path);
        if (this.config.isPrintDataFetcherException()) {
            SmallRyeGraphQLServerLogging.log.dataFetchingError(throwable);
        }
        return DataFetcherExceptionHandlerResult.newResult().error((GraphQLError)error).build();
    }

    private ExceptionWhileDataFetching getExceptionWhileDataFetching(Throwable throwable, SourceLocation sourceLocation, ResultPath path) {
        if (throwable instanceof RuntimeException) {
            if (this.exceptionLists.shouldShow(throwable)) {
                return new GraphQLExceptionWhileDataFetching(path, throwable, sourceLocation);
            }
            return new GraphQLExceptionWhileDataFetching(this.config.getDefaultErrorMessage(), path, throwable, sourceLocation);
        }
        if (this.exceptionLists.shouldHide(throwable)) {
            return new GraphQLExceptionWhileDataFetching(this.config.getDefaultErrorMessage(), path, throwable, sourceLocation);
        }
        return new GraphQLExceptionWhileDataFetching(path, throwable, sourceLocation);
    }

    private Throwable unwrapThrowable(Throwable t) {
        if (this.shouldUnwrapThrowable(t)) {
            t = t.getCause();
            return this.unwrapThrowable(t);
        }
        return t;
    }

    private boolean shouldUnwrapThrowable(Throwable t) {
        return this.unwrapExceptions.contains(t.getClass().getName()) && t.getCause() != null;
    }

    static {
        DEFAULT_EXCEPTION_UNWRAP.add(CompletionException.class.getName());
        DEFAULT_EXCEPTION_UNWRAP.add(DataFetcherException.class.getName());
        DEFAULT_EXCEPTION_UNWRAP.add("jakarta.ejb.EJBException");
        DEFAULT_EXCEPTION_UNWRAP.add("jakarta.ejb.EJBException");
    }
}

