/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.internal.outbound;

import com.ibm.websphere.channelfw.ChannelData;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.http.channel.internal.HttpChannelConfig;
import com.ibm.ws.http.channel.internal.HttpFactoryConfig;
import com.ibm.ws.http.channel.internal.HttpObjectFactory;
import com.ibm.ws.http.channel.internal.outbound.HttpOutboundChannelFactory;
import com.ibm.ws.http.channel.internal.outbound.HttpOutboundLink;
import com.ibm.wsspi.channelfw.ConnectionLink;
import com.ibm.wsspi.channelfw.OutboundChannel;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.http.channel.outbound.HttpAddress;
import com.ibm.wsspi.http.channel.outbound.HttpOutboundServiceContext;
import com.ibm.wsspi.tcpchannel.TCPConnectRequestContext;
import com.ibm.wsspi.tcpchannel.TCPConnectionContext;

public class HttpOutboundChannel
implements OutboundChannel {
    private static final TraceComponent tc = Tr.register(HttpOutboundChannel.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    private static final int STATE_STOPPED = 0;
    private static final int STATE_STOPPING = 1;
    private static final int STATE_RUNNING = 2;
    private Class<?> appInterface = null;
    private Class<?> devInterface = null;
    private Class<?> devAddrInterface = null;
    private Class<?>[] appAddrInterfaces = new Class[1];
    private HttpObjectFactory myObjectFactory = null;
    private HttpOutboundChannelFactory channelFactory = null;
    private HttpChannelConfig myConfig = null;
    private int myState = 0;
    private ChannelData chfwConfig = null;

    public HttpOutboundChannel(ChannelData cc, HttpOutboundChannelFactory cf, HttpObjectFactory of) {
        this.channelFactory = cf;
        this.appInterface = HttpOutboundServiceContext.class;
        this.devInterface = TCPConnectionContext.class;
        this.devAddrInterface = TCPConnectRequestContext.class;
        this.appAddrInterfaces[0] = HttpAddress.class;
        this.myObjectFactory = of;
        this.update(cc);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Created: " + this), (Object[])new Object[0]);
        }
    }

    public final ConnectionLink getConnectionLink(VirtualConnection vc) {
        return new HttpOutboundLink(this, vc);
    }

    public final Class<?> getApplicationInterface() {
        return this.appInterface;
    }

    public final Class<?> getDeviceInterface() {
        return this.devInterface;
    }

    public final Class<?> getDeviceAddress() {
        return this.devAddrInterface;
    }

    public final Class<?>[] getApplicationAddress() {
        return this.appAddrInterfaces;
    }

    public final HttpChannelConfig getHttpConfig() {
        return this.myConfig;
    }

    public final void setHttpConfig(HttpChannelConfig hcc) {
        this.myConfig = hcc;
    }

    public final HttpFactoryConfig getFactoryConfig() {
        return this.channelFactory.getConfig();
    }

    public final HttpObjectFactory getObjectFactory() {
        return this.myObjectFactory;
    }

    public synchronized boolean isRunning() {
        return 2 == this.myState;
    }

    public synchronized boolean isStopping() {
        return 2 != this.myState;
    }

    public synchronized boolean isStopped() {
        return 0 == this.myState;
    }

    private synchronized void setState(int state) {
        this.myState = state;
    }

    public void start() {
        this.setState(2);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Starting: " + this), (Object[])new Object[0]);
        }
    }

    public void stop(long millisec) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Stopping (" + millisec + ") : " + this), (Object[])new Object[0]);
        }
        if (0L == millisec) {
            this.setState(0);
        } else {
            this.setState(1);
        }
    }

    public void init() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Initializing: " + this), (Object[])new Object[0]);
        }
    }

    public void destroy() {
        this.setState(0);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Destroying: " + this), (Object[])new Object[0]);
        }
        this.channelFactory.removeChannel(this.getName());
    }

    public void update(ChannelData cc) {
        this.chfwConfig = cc;
        this.setHttpConfig(new HttpChannelConfig(cc));
    }

    public String getName() {
        return this.chfwConfig.getName();
    }

    public String toString() {
        return this.chfwConfig.getName() + " state=" + this.myState;
    }
}

