/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.provider;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ssl.JSSEProvider;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.ssl.JSSEProviderFactory;
import com.ibm.ws.ssl.provider.AbstractJSSEProvider;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class IBMJSSEProvider
extends AbstractJSSEProvider
implements JSSEProvider {
    private static TraceComponent tc = Tr.register(IBMJSSEProvider.class, (String)"SSL", (String)"com.ibm.ws.ssl.resources.ssl");
    public static String IBM_JCE_Plus_FIPS_PROVIDER = "com.ibm.crypto.provider.IBMJCEPlusFIPS";
    private static boolean issuedBetaMessage = false;

    public IBMJSSEProvider() {
        String fipsON = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("com.ibm.jsse2.usefipsprovider");
            }
        });
        String ibmjceplusfipsprovider = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("com.ibm.jsse2.usefipsProviderName");
            }
        });
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("provider: " + ibmjceplusfipsprovider), (Object[])new Object[0]);
        }
        if (fipsON != null && fipsON.equalsIgnoreCase("true") && ibmjceplusfipsprovider.equals("IBMJCEPlusFIPS") && this.isRunningBetaMode()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"fips is enabled and using IBMJCEPlusFIPS provider", (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("key manager factory alg: " + JSSEProviderFactory.getKeyManagerFactoryAlgorithm()), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("trust manager factory alg: " + JSSEProviderFactory.getTrustManagerFactoryAlgorithm()), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)"protocol: TLS", (Object[])new Object[0]);
            }
            this.initialize(JSSEProviderFactory.getKeyManagerFactoryAlgorithm(), JSSEProviderFactory.getTrustManagerFactoryAlgorithm(), "IBMJSSE2", null, "com.ibm.websphere.ssl.protocol.SSLSocketFactory", null, "TLS");
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"protocol: SSL_TLSv2", (Object[])new Object[0]);
            }
            this.initialize(JSSEProviderFactory.getKeyManagerFactoryAlgorithm(), JSSEProviderFactory.getTrustManagerFactoryAlgorithm(), "IBMJSSE2", null, "com.ibm.websphere.ssl.protocol.SSLSocketFactory", null, "SSL_TLSv2");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Created an IBM JSSE provider", (Object[])new Object[0]);
        }
    }

    boolean isRunningBetaMode() {
        if (!ProductInfo.getBetaEdition()) {
            return false;
        }
        if (!issuedBetaMessage) {
            Tr.info((TraceComponent)tc, (String)("BETA: A beta method has been invoked for the class " + this.getClass().getName() + " for the first time."), (Object[])new Object[0]);
            issuedBetaMessage = !issuedBetaMessage;
        }
        return true;
    }
}

