/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.internal.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.internal.utils.OpenAPIModelWalker;
import io.openliberty.microprofile.openapi20.internal.validation.OASValidationResult;
import io.openliberty.microprofile.openapi20.internal.validation.ReferenceValidator;
import io.openliberty.microprofile.openapi20.internal.validation.TypeValidator;
import io.openliberty.microprofile.openapi20.internal.validation.ValidationHelper;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class MediaTypeValidator
extends TypeValidator<MediaType> {
    private static final TraceComponent tc = Tr.register(MediaTypeValidator.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.validation.ValidationMessages");
    private static final MediaTypeValidator INSTANCE = new MediaTypeValidator();
    static final long serialVersionUID = -4565573188643465065L;

    public static MediaTypeValidator getInstance() {
        return INSTANCE;
    }

    private MediaTypeValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, MediaType t) {
        Map encoding;
        Object example = t.getExample();
        Map examples = t.getExamples();
        if (example != null && examples != null && !examples.isEmpty()) {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"mediaTypeExampleOrExamples", (Object[])new Object[0]);
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.WARNING, context.getLocation(), message));
        }
        if ((encoding = t.getEncoding()) != null && !encoding.isEmpty()) {
            Set encodingProperties = encoding.keySet();
            Schema schema = t.getSchema();
            if (schema != null) {
                String ref = schema.getRef();
                if (StringUtils.isNotBlank((CharSequence)ref)) {
                    ReferenceValidator referenceValidator = ReferenceValidator.getInstance();
                    Object component = referenceValidator.validate(helper, context, key, ref);
                    if (!schema.getClass().isInstance(component)) {
                        String message = Tr.formatMessage((TraceComponent)tc, (String)"referenceToObjectInvalid", (Object[])new Object[]{ref});
                        helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
                    } else {
                        Schema componentSchema = (Schema)component;
                        Map schemaProperties = componentSchema != null ? componentSchema.getProperties() : null;
                        for (String encodingProperty : encodingProperties) {
                            if (schemaProperties != null && schemaProperties.containsKey(encodingProperty)) continue;
                            String message = Tr.formatMessage((TraceComponent)tc, (String)"mediaTypeEncodingProperty", (Object[])new Object[]{encodingProperty});
                            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
                        }
                    }
                } else if (schema.getProperties() != null) {
                    for (String encodingProperty : encodingProperties) {
                        if (schema.getProperties().containsKey(encodingProperty)) continue;
                        String message = Tr.formatMessage((TraceComponent)tc, (String)"mediaTypeEncodingProperty", (Object[])new Object[]{encodingProperty});
                        helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
                    }
                } else {
                    String message = Tr.formatMessage((TraceComponent)tc, (String)"mediaTypeEmptySchema", (Object[])new Object[0]);
                    helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
                }
            } else {
                String message = Tr.formatMessage((TraceComponent)tc, (String)"mediaTypeEmptySchema", (Object[])new Object[0]);
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            }
        }
    }
}

