/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.internal.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.internal.utils.OpenAPIModelWalker;
import io.openliberty.microprofile.openapi20.internal.validation.OASValidationResult;
import io.openliberty.microprofile.openapi20.internal.validation.TypeValidator;
import io.openliberty.microprofile.openapi20.internal.validation.ValidationHelper;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.Paths;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class PathsValidator
extends TypeValidator<Paths> {
    private static final TraceComponent tc = Tr.register(PathsValidator.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.validation.ValidationMessages");
    private static final PathsValidator INSTANCE = new PathsValidator();
    static final long serialVersionUID = -913955348449450659L;

    public static PathsValidator getInstance() {
        return INSTANCE;
    }

    private PathsValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, Paths t) {
        if (t != null) {
            boolean mapContainsInvalidKey = false;
            Map pathItems = t.getPathItems();
            if (pathItems != null) {
                for (String path : t.getPathItems().keySet()) {
                    if (path != null && !path.isEmpty()) {
                        String message;
                        if (!path.startsWith("/")) {
                            message = Tr.formatMessage((TraceComponent)tc, (String)"pathsRequiresSlash", (Object[])new Object[]{path});
                            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(path), message));
                        }
                        if (t.getPathItems().get(path) != null) continue;
                        message = Tr.formatMessage((TraceComponent)tc, (String)"nullValueInMap", (Object[])new Object[]{path});
                        helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(path), message));
                        continue;
                    }
                    mapContainsInvalidKey = true;
                }
            }
            if (mapContainsInvalidKey) {
                String message = Tr.formatMessage((TraceComponent)tc, (String)"nullOrEmptyKeyInMap", (Object[])new Object[0]);
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            }
        }
    }
}

