/*
 * Decompiled with CFR 0.152.
 */
package jakarta.data;

import jakarta.data.Direction;

public record Sort(String property, boolean isAscending, boolean ignoreCase) {
    public Sort {
        if (property == null) {
            throw new NullPointerException("property is required");
        }
    }

    public static Sort asc(String property) {
        return new Sort(property, true, false);
    }

    public static Sort ascIgnoreCase(String property) {
        return new Sort(property, true, true);
    }

    public static Sort desc(String property) {
        return new Sort(property, false, false);
    }

    public static Sort descIgnoreCase(String property) {
        return new Sort(property, false, true);
    }

    public static Sort of(String property, Direction direction, boolean ignoreCase) {
        if (direction == null) {
            throw new NullPointerException("direction is required");
        }
        return new Sort(property, direction.equals((Object)Direction.ASC), ignoreCase);
    }

    public boolean isDescending() {
        return !this.isAscending;
    }
}

