/*
 * Decompiled with CFR 0.152.
 */
package jakarta.data.page;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.data.Sort;
import jakarta.data.page.KeysetCursor;
import jakarta.data.page.Pageable;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
record Pagination(long page, int size, List<Sort> sorts, Pageable.Mode mode, Pageable.Cursor type) implements Pageable
{
    static final long serialVersionUID = 7302876042052604036L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    Pagination {
        if (page < 1L) {
            throw new IllegalArgumentException("pageNumber: " + page);
        }
        if (size < 1) {
            throw new IllegalArgumentException("maxPageSize: " + size);
        }
        if (mode != Pageable.Mode.OFFSET && (type == null || type.size() == 0)) {
            throw new IllegalArgumentException("No keyset values were provided.");
        }
    }

    @Override
    public Pageable afterKeyset(Object ... keyset) {
        return new Pagination(this.page, this.size, this.sorts, Pageable.Mode.CURSOR_NEXT, new KeysetCursor(keyset));
    }

    @Override
    public Pageable afterKeysetCursor(Pageable.Cursor cursor) {
        return new Pagination(this.page, this.size, this.sorts, Pageable.Mode.CURSOR_NEXT, cursor);
    }

    @Override
    public Pageable beforeKeyset(Object ... keyset) {
        return new Pagination(this.page, this.size, this.sorts, Pageable.Mode.CURSOR_PREVIOUS, new KeysetCursor(keyset));
    }

    @Override
    public Pageable beforeKeysetCursor(Pageable.Cursor cursor) {
        return new Pagination(this.page, this.size, this.sorts, Pageable.Mode.CURSOR_PREVIOUS, cursor);
    }

    @Override
    public Optional<Pageable.Cursor> cursor() {
        return this.type == null ? Optional.empty() : Optional.of(this.type);
    }

    @Override
    public Pagination next() {
        if (this.mode == Pageable.Mode.OFFSET) {
            return new Pagination(this.page + 1L, this.size, this.sorts, this.mode, null);
        }
        throw new UnsupportedOperationException("Not supported for keyset pagination. Instead use afterKeyset or afterKeysetCursor to provide the next keyset values or obtain the nextPageable from a KeysetAwareSlice.");
    }

    public static Pagination ofPage(long page) {
        return new Pagination(page, 10, Collections.emptyList(), Pageable.Mode.OFFSET, null);
    }

    public static Pagination ofSize(int size) {
        return new Pagination(1L, size, Collections.emptyList(), Pageable.Mode.OFFSET, null);
    }

    @Override
    public Pagination page(long pageNumber) {
        return new Pagination(pageNumber, this.size, this.sorts, this.mode, this.type);
    }

    @Override
    public Pagination size(int maxPageSize) {
        return new Pagination(this.page, maxPageSize, this.sorts, this.mode, this.type);
    }

    @Override
    public Pagination sortBy(Iterable<Sort> sorts) {
        List<Sort> order = sorts == null ? Collections.emptyList() : StreamSupport.stream(sorts.spliterator(), false).collect(Collectors.toUnmodifiableList());
        return new Pagination(this.page, this.size, order, this.mode, this.type);
    }

    @Override
    public Pagination sortBy(Sort ... sorts) {
        List<Sort> order = sorts == null ? Collections.EMPTY_LIST : List.of(sorts);
        return new Pagination(this.page, this.size, order, this.mode, this.type);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("Pageable{page=").append(this.page).append(", size=").append(this.size);
        if (this.type != null) {
            b.append(", mode=").append((Object)this.mode).append(", ").append(this.type.size()).append(" keys");
        }
        for (Sort o : this.sorts) {
            b.append(", ").append(o.property()).append(o.ignoreCase() ? " IGNORE CASE" : "").append(o.isDescending() ? " DESC" : " ASC");
        }
        b.append("}");
        return b.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"jakarta.data.page.Pagination", Pagination.class, null, null);
    }
}

