/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.opentracing.internal.cdi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.opentracing.internal.OpenTracingService;
import io.openliberty.opentracing.internal.OpentracingService;
import io.openliberty.opentracing.internal.OpentracingTracerManager;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.annotation.Priority;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.Path;
import org.eclipse.microprofile.opentracing.Traced;

@Traced
@Interceptor
@Priority(value=1000)
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TracedInterceptor {
    private static final TraceComponent tc = Tr.register(TracedInterceptor.class, (String)"OPENTRACING", null);
    static final long serialVersionUID = 8320861384710822173L;

    /*
     * WARNING - void declaration
     */
    @AroundInvoke
    public Object execute(InvocationContext context) throws Exception {
        String methodName = "execute";
        String classOperationName = OpenTracingService.getClassOperationName(context.getMethod());
        String methodOperationName = OpenTracingService.getMethodOperationName(context.getMethod());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + " operation names"), (Object[])new Object[]{classOperationName, methodOperationName});
        }
        boolean process = true;
        if (!OpenTracingService.isTraced(classOperationName, methodOperationName)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " skipping untraced method"), (Object[])new Object[0]);
            }
            process = false;
        }
        if (process && this.isHandledByFilter(context.getMethod())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " skipping JAXRS method"), (Object[])new Object[0]);
            }
            process = false;
        }
        if (process) {
            String operationName;
            if (OpenTracingService.hasExplicitOperationName(methodOperationName)) {
                operationName = methodOperationName;
            } else {
                operationName = OpenTracingService.hasExplicitOperationName(classOperationName) ? classOperationName : context.getMethod().getDeclaringClass().getName() + "." + context.getMethod().getName();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(methodName + " setting default operationName"), (Object[])new Object[]{operationName});
                }
            }
            Tracer tracer = OpentracingTracerManager.getTracer();
            if (tracer != null) {
                Span span = tracer.buildSpan(operationName).start();
                try {
                    Object object;
                    block24: {
                        Scope scope2 = tracer.activateSpan(span);
                        try {
                            Object result;
                            object = result = context.proceed();
                            if (scope2 == null) break block24;
                        }
                        catch (Throwable throwable) {
                            try {
                                FFDCFilter.processException((Throwable)throwable, (String)"io.openliberty.microprofile.opentracing.internal.cdi.TracedInterceptor", (String)"115", (Object)this, (Object[])new Object[]{context});
                                if (scope2 != null) {
                                    try {
                                        scope2.close();
                                    }
                                    catch (Throwable throwable2) {
                                        FFDCFilter.processException((Throwable)throwable2, (String)"io.openliberty.microprofile.opentracing.internal.cdi.TracedInterceptor", (String)"115", (Object)this, (Object[])new Object[]{context});
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (Exception scope2) {
                                void e;
                                FFDCFilter.processException((Throwable)scope2, (String)"io.openliberty.microprofile.opentracing.internal.cdi.TracedInterceptor", (String)"118", (Object)this, (Object[])new Object[]{context});
                                OpentracingService.addSpanErrorInfo((Span)span, (Throwable)e);
                                throw e;
                            }
                            catch (Error e) {
                                FFDCFilter.processException((Throwable)e, (String)"io.openliberty.microprofile.opentracing.internal.cdi.TracedInterceptor", (String)"121", (Object)this, (Object[])new Object[]{context});
                                OpentracingService.addSpanErrorInfo((Span)span, (Throwable)e);
                                throw e;
                            }
                        }
                        scope2.close();
                    }
                    return object;
                }
                finally {
                    span.finish();
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " normal processing"), (Object[])new Object[0]);
            }
            return context.proceed();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + " normal processing"), (Object[])new Object[0]);
        }
        return context.proceed();
    }

    private boolean isHandledByFilter(Method method) {
        for (Annotation annotation : method.getAnnotations()) {
            if (!HttpMethod.class.isAssignableFrom(annotation.annotationType())) continue;
            return true;
        }
        return method.isAnnotationPresent(Path.class);
    }
}

