/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.ext.Providers;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.resteasy.core.ThreadLocalResteasyProviderFactory;
import org.jboss.resteasy.core.providerfactory.ResteasyProviderFactoryImpl;
import org.jboss.resteasy.plugins.interceptors.GZIPDecodingInterceptor;
import org.jboss.resteasy.plugins.interceptors.GZIPEncodingInterceptor;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.config.ConfigurationFactory;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class RegisterBuiltin {
    private static final Map<ClassLoader, ResteasyProviderFactory> configuredClientFactories;
    private static final boolean gzipForCachedFactories;
    static final long serialVersionUID = -6883523487552828046L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static synchronized ResteasyProviderFactory getClientInitializedResteasyProviderFactory(ClassLoader cl) {
        ResteasyProviderFactory rpf = null;
        boolean gzip = RegisterBuiltin.isGZipEnabled();
        if (gzipForCachedFactories == gzip) {
            rpf = configuredClientFactories.get(cl);
        }
        if (rpf == null) {
            rpf = new ResteasyProviderFactoryImpl(RuntimeType.CLIENT){
                static final long serialVersionUID = -1651996869007653869L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public RuntimeType getRuntimeType() {
                    return RuntimeType.CLIENT;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.providers.RegisterBuiltin$1", 1.class, null, null);
                }
            };
            if (!rpf.isBuiltinsRegistered()) {
                RegisterBuiltin.register(rpf);
            }
            if (gzipForCachedFactories == gzip) {
                configuredClientFactories.put(cl, rpf);
            }
        }
        return rpf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(ResteasyProviderFactory factory) {
        ResteasyProviderFactory monitor;
        ResteasyProviderFactory resteasyProviderFactory = monitor = factory instanceof ThreadLocalResteasyProviderFactory ? ((ThreadLocalResteasyProviderFactory)factory).getDelegate() : factory;
        synchronized (resteasyProviderFactory) {
            if (factory.isBuiltinsRegistered() || !factory.isRegisterBuiltins()) {
                return;
            }
            try {
                RegisterBuiltin.registerProviders(factory);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            factory.setBuiltinsRegistered(true);
        }
    }

    public static void registerProviders(ResteasyProviderFactory factory) throws Exception {
        Map<String, URL> origins = RegisterBuiltin.scanBuiltins();
        for (Map.Entry<String, URL> entry : origins.entrySet()) {
            final String line = entry.getKey();
            try {
                Class clazz = System.getSecurityManager() == null ? Thread.currentThread().getContextClassLoader().loadClass(line) : (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){
                    static final long serialVersionUID = 3054459312522985377L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public Class<?> run() throws ClassNotFoundException {
                        return Thread.currentThread().getContextClassLoader().loadClass(line);
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.providers.RegisterBuiltin$2", 2.class, null, null);
                    }
                });
                factory.registerProvider(clazz, true);
            }
            catch (NoClassDefFoundError e) {
                LogMessages.LOGGER.noClassDefFoundErrorError(line, entry.getValue(), e);
            }
            catch (ClassNotFoundException | PrivilegedActionException ex) {
                LogMessages.LOGGER.classNotFoundException(line, entry.getValue(), ex);
            }
        }
        if (RegisterBuiltin.isGZipEnabled()) {
            factory.registerProvider(GZIPDecodingInterceptor.class, true);
            factory.registerProvider(GZIPEncodingInterceptor.class, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, URL> scanBuiltins() throws IOException, PrivilegedActionException {
        Enumeration<URL> en = System.getSecurityManager() == null ? Thread.currentThread().getContextClassLoader().getResources("META-INF/services/" + Providers.class.getName()) : AccessController.doPrivileged(new PrivilegedExceptionAction<Enumeration<URL>>(){
            static final long serialVersionUID = 7600526457342950914L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Enumeration<URL> run() throws IOException {
                return Thread.currentThread().getContextClassLoader().getResources("META-INF/services/" + Providers.class.getName());
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.providers.RegisterBuiltin$3", 3.class, null, null);
            }
        });
        HashMap<String, URL> origins = new HashMap<String, URL>();
        while (en.hasMoreElements()) {
            final URL url = en.nextElement();
            try (InputStream is = System.getSecurityManager() == null ? url.openStream() : AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){
                static final long serialVersionUID = 6831999901472827383L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public InputStream run() throws IOException {
                    return url.openStream();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.providers.RegisterBuiltin$4", 4.class, null, null);
                }
            });){
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
                while ((line = reader.readLine()) != null) {
                    int commentIdx = line.indexOf(35);
                    if (commentIdx >= 0) {
                        line = line.substring(0, commentIdx);
                    }
                    if ((line = line.trim()).equals("")) continue;
                    origins.put(line, url);
                }
            }
        }
        return origins;
    }

    public static boolean isGZipEnabled() {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
            static final long serialVersionUID = 7495681048114929354L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Boolean run() {
                String value = ConfigurationFactory.getInstance().getConfiguration().getOptionalValue("resteasy.allowGzip", String.class).orElse(null);
                if ("".equals(value)) {
                    return Boolean.FALSE;
                }
                return Boolean.parseBoolean(value);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.providers.RegisterBuiltin$5", 5.class, null, null);
            }
        });
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.providers.RegisterBuiltin", RegisterBuiltin.class, null, null);
        configuredClientFactories = new WeakHashMap<ClassLoader, ResteasyProviderFactory>();
        gzipForCachedFactories = RegisterBuiltin.isGZipEnabled();
    }
}

