/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.mp.jwt.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.config.CommonConfigUtils;
import com.ibm.ws.security.common.jwk.impl.JWKSet;
import com.ibm.ws.security.jwt.config.ConsumerUtils;
import com.ibm.ws.security.jwt.config.JwtConsumerConfig;
import com.ibm.ws.security.jwt.utils.JwtUtils;
import com.ibm.ws.security.mp.jwt.MicroProfileJwtConfig;
import com.ibm.ws.security.mp.jwt.MicroProfileJwtService;
import com.ibm.ws.security.mp.jwt.SslRefInfo;
import com.ibm.ws.security.mp.jwt.error.MpJwtProcessingException;
import com.ibm.ws.security.mp.jwt.impl.SslRefInfoImpl;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.ssl.SSLSupport;
import io.openliberty.security.mp.jwt.osgi.MpJwtRuntimeVersion;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(name="com.ibm.ws.security.mp.jwt", configurationPid={"com.ibm.ws.security.mp.jwt"}, configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true, service={MicroProfileJwtConfig.class, JwtConsumerConfig.class}, property={"service.vendor=IBM", "type=microProfileJwtConfig"})
public class MicroProfileJwtConfigImpl
implements MicroProfileJwtConfig {
    private static TraceComponent tc = Tr.register(MicroProfileJwtConfigImpl.class, (String)"MPJWT", (String)"com.ibm.ws.security.mp.jwt.resources.MicroProfileJwtMessages");
    protected final boolean IS_REQUIRED = true;
    protected final boolean IS_NOT_REQUIRED = false;
    protected static final String KEY_UNIQUE_ID = "id";
    protected String uniqueId = null;
    protected SSLContext sslContext = null;
    protected SSLSocketFactory sslSocketFactory = null;
    public static final String KEY_sslRef = "sslRef";
    protected String sslRef;
    protected SslRefInfo sslRefInfo = null;
    public static final String KEY_jwksUri = "jwksUri";
    protected String jwksUri = null;
    static final String KEY_MP_JWT_SERVICE = "microProfileJwtService";
    final AtomicServiceReference<MicroProfileJwtService> mpJwtServiceRef = new AtomicServiceReference("microProfileJwtService");
    ConsumerUtils consumerUtils = null;
    JWKSet jwkSet = null;
    public static final String KEY_ISSUER = "issuer";
    String issuer = null;
    public static final String KEY_AUDIENCE = "audiences";
    String[] audience = null;
    boolean ignoreAudClaimIfNotConfigured = false;
    public static final String CFG_KEY_HOST_NAME_VERIFICATION_ENABLED = "hostNameVerificationEnabled";
    protected boolean hostNameVerificationEnabled = false;
    public static final String KEY_TRUSTED_ALIAS = "keyName";
    private String trustAliasName = null;
    public static final String KEY_userNameAttribute = "userNameAttribute";
    protected String userNameAttribute = null;
    public static final String KEY_groupNameAttribute = "groupNameAttribute";
    protected String groupNameAttribute = null;
    public static final String KEY_authorizationHeaderScheme = "authorizationHeaderScheme";
    protected String authorizationHeaderScheme = null;
    public static final String CFG_KEY_TOKEN_REUSE = "tokenReuse";
    protected boolean tokenReuse = true;
    public static final String CFG_KEY_CLOCK_SKEW = "clockSkew";
    private long clockSkewMilliSeconds;
    public static final String CFG_KEY_TOKEN_AGE = "tokenAge";
    private long tokenAgeMilliSeconds;
    public static final String CFG_KEY_DECRYPT_KEY_ALGORITHM = "keyManagementKeyAlgorithm";
    private String keyManagementKeyAlgorithm = null;
    public static final String CFG_KEY_IGNORE_APP_AUTH_METHOD = "ignoreApplicationAuthMethod";
    protected boolean ignoreApplicationAuthMethod = true;
    public static final String CFG_KEY_mapToUserRegistry = "mapToUserRegistry";
    protected boolean mapToUserRegistry = false;
    public static final String CFG_KEY_SIGALG = "signatureAlgorithm";
    String signatureAlgorithm = null;
    public static final String KEY_authFilterRef = "authFilterRef";
    protected String authFilterRef;
    public static final String CFG_KEY_USE_SYSPROPS_FOR_HTTPCLIENT_CONNECTONS = "useSystemPropertiesForHttpClientConnections";
    private boolean useSystemPropertiesForHttpClientConnections = false;
    public static final String KEY_TOKEN_HEADER = "tokenHeader";
    protected String tokenHeader;
    public static final String KEY_COOKIE_NAME = "cookieName";
    protected String cookieName;
    public static final String KEY_KEY_MANAGEMENT_KEY_ALIAS = "keyManagementKeyAlias";
    protected String keyManagementKeyAlias;
    @Sensitive
    private String sharedKey;
    protected CommonConfigUtils configUtils = new CommonConfigUtils();
    static final long serialVersionUID = 6991182742198272822L;

    @Reference(service=MicroProfileJwtService.class, name="microProfileJwtService", cardinality=ReferenceCardinality.MANDATORY)
    protected void setMicroProfileJwtService(ServiceReference<MicroProfileJwtService> ref) {
        this.mpJwtServiceRef.setReference(ref);
    }

    protected void unsetMicroProfileJwtService(ServiceReference<MicroProfileJwtService> ref) {
        this.mpJwtServiceRef.unsetReference(ref);
    }

    @Activate
    protected void activate(ComponentContext cc, Map<String, Object> props) throws MpJwtProcessingException {
        this.mpJwtServiceRef.activate(cc);
        this.uniqueId = (String)props.get(KEY_UNIQUE_ID);
        this.initProps(cc, props);
        Tr.info((TraceComponent)tc, (String)"MPJWT_CONFIG_PROCESSED", (Object[])new Object[]{this.uniqueId});
    }

    @Modified
    protected void modified(ComponentContext cc, Map<String, Object> props) throws MpJwtProcessingException {
        this.initProps(cc, props);
        Tr.info((TraceComponent)tc, (String)"MPJWT_CONFIG_MODIFIED", (Object[])new Object[]{this.uniqueId});
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        this.mpJwtServiceRef.deactivate(cc);
        Tr.info((TraceComponent)tc, (String)"MPJWT_CONFIG_DEACTIVATED", (Object[])new Object[]{this.uniqueId});
    }

    @ManualTrace
    public void initProps(ComponentContext cc, Map<String, Object> props) throws MpJwtProcessingException {
        String methodName = "initProps";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{cc, props});
        }
        this.issuer = this.configUtils.getConfigAttribute(props, KEY_ISSUER);
        this.audience = this.configUtils.getStringArrayConfigAttribute(props, KEY_AUDIENCE);
        this.jwksUri = this.configUtils.getConfigAttribute(props, KEY_jwksUri);
        this.userNameAttribute = this.configUtils.getConfigAttribute(props, KEY_userNameAttribute);
        this.groupNameAttribute = this.configUtils.getConfigAttribute(props, KEY_groupNameAttribute);
        this.authorizationHeaderScheme = this.configUtils.getConfigAttribute(props, KEY_authorizationHeaderScheme);
        this.clockSkewMilliSeconds = this.configUtils.getLongConfigAttribute(props, CFG_KEY_CLOCK_SKEW, this.clockSkewMilliSeconds);
        this.sslRef = this.configUtils.getConfigAttribute(props, KEY_sslRef);
        this.sslRefInfo = null;
        this.authFilterRef = this.configUtils.getConfigAttribute(props, KEY_authFilterRef);
        this.sslContext = null;
        this.trustAliasName = this.configUtils.getConfigAttribute(props, KEY_TRUSTED_ALIAS);
        this.hostNameVerificationEnabled = this.configUtils.getBooleanConfigAttribute(props, CFG_KEY_HOST_NAME_VERIFICATION_ENABLED, this.hostNameVerificationEnabled);
        this.tokenReuse = this.configUtils.getBooleanConfigAttribute(props, CFG_KEY_TOKEN_REUSE, this.tokenReuse);
        this.ignoreApplicationAuthMethod = this.configUtils.getBooleanConfigAttribute(props, CFG_KEY_IGNORE_APP_AUTH_METHOD, this.ignoreApplicationAuthMethod);
        this.useSystemPropertiesForHttpClientConnections = this.configUtils.getBooleanConfigAttribute(props, CFG_KEY_USE_SYSPROPS_FOR_HTTPCLIENT_CONNECTONS, this.useSystemPropertiesForHttpClientConnections);
        this.mapToUserRegistry = this.configUtils.getBooleanConfigAttribute(props, CFG_KEY_mapToUserRegistry, this.mapToUserRegistry);
        this.jwkSet = null;
        this.consumerUtils = null;
        this.signatureAlgorithm = this.configUtils.getConfigAttribute(props, CFG_KEY_SIGALG);
        this.sharedKey = JwtUtils.processProtectedString(props, (String)"sharedKey");
        this.loadConfigValuesForHigherVersions(cc, props);
        this.debug();
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName);
        }
    }

    void loadConfigValuesForHigherVersions(ComponentContext cc, Map<String, Object> props) {
        if (!this.isRuntimeVersionAtLeast(MpJwtRuntimeVersion.VERSION_1_2)) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Loading additional properties for runtime version " + MpJwtRuntimeVersion.VERSION_1_2 + " and above"), (Object[])new Object[0]);
        }
        this.tokenHeader = this.configUtils.getConfigAttribute(props, KEY_TOKEN_HEADER);
        this.cookieName = this.configUtils.getConfigAttribute(props, KEY_COOKIE_NAME);
        this.keyManagementKeyAlias = this.configUtils.getConfigAttribute(props, KEY_KEY_MANAGEMENT_KEY_ALIAS);
        this.ignoreAudClaimIfNotConfigured = true;
        if (!this.isRuntimeVersionAtLeast(MpJwtRuntimeVersion.VERSION_2_1)) {
            return;
        }
        this.tokenAgeMilliSeconds = this.configUtils.getLongConfigAttribute(props, CFG_KEY_TOKEN_AGE, this.tokenAgeMilliSeconds);
        this.keyManagementKeyAlgorithm = this.configUtils.getConfigAttribute(props, CFG_KEY_DECRYPT_KEY_ALGORITHM);
    }

    boolean isRuntimeVersionAtLeast(Version minimumVersionRequired) {
        MpJwtRuntimeVersion mpJwtRuntimeVersion = this.getMpJwtRuntimeVersion();
        if (mpJwtRuntimeVersion == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Failed to find runtime version", (Object[])new Object[0]);
            }
            return false;
        }
        Version runtimeVersion = mpJwtRuntimeVersion.getVersion();
        return runtimeVersion.compareTo(minimumVersionRequired) >= 0;
    }

    MpJwtRuntimeVersion getMpJwtRuntimeVersion() {
        MicroProfileJwtService mpJwtService = (MicroProfileJwtService)this.mpJwtServiceRef.getService();
        if (mpJwtService == null) {
            return null;
        }
        return mpJwtService.getMpJwtRuntimeVersion();
    }

    protected void debug() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("issuer: " + this.issuer), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("hostNameVerificationEnabled: " + this.hostNameVerificationEnabled), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("tokenReuse: " + this.tokenReuse), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("keyName: " + this.trustAliasName), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("jwksUri:" + this.jwksUri), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("userNameAttribute:" + this.userNameAttribute), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("groupNameAttribute:" + this.groupNameAttribute), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("mapToUserRegistry:" + this.mapToUserRegistry), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("authFilterRef = " + this.authFilterRef), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("sslRef = " + this.sslRef), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("sigAlg = " + this.signatureAlgorithm), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("sharedKey" + this.sharedKey == null ? "null" : "*********"), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("useSystemPropertiesForHttpClientConnections = " + this.useSystemPropertiesForHttpClientConnections), (Object[])new Object[0]);
        }
    }

    public boolean isHostNameVerificationEnabled() {
        return this.hostNameVerificationEnabled;
    }

    public String getId() {
        return this.getUniqueId();
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getSharedKey() {
        return this.sharedKey;
    }

    public List<String> getAudiences() {
        if (this.audience != null) {
            ArrayList<String> audiences = new ArrayList<String>();
            for (String aud : this.audience) {
                audiences.add(aud);
            }
            return audiences;
        }
        return null;
    }

    public boolean ignoreAudClaimIfNotConfigured() {
        return this.ignoreAudClaimIfNotConfigured;
    }

    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    @FFDCIgnore(value={MpJwtProcessingException.class})
    public String getTrustStoreRef() {
        if (this.sslRefInfo == null) {
            this.sslRefInfo = this.initializeSslRefInfo();
            if (this.sslRefInfo == null) {
                return null;
            }
        }
        try {
            return this.sslRefInfo.getTrustStoreName();
        }
        catch (MpJwtProcessingException mpJwtProcessingException) {
            return null;
        }
    }

    @FFDCIgnore(value={MpJwtProcessingException.class})
    public String getKeyStoreRef() {
        if (this.sslRefInfo == null) {
            this.sslRefInfo = this.initializeSslRefInfo();
            if (this.sslRefInfo == null) {
                return null;
            }
        }
        try {
            return this.sslRefInfo.getKeyStoreName();
        }
        catch (MpJwtProcessingException mpJwtProcessingException) {
            return null;
        }
    }

    SslRefInfo initializeSslRefInfo() {
        MicroProfileJwtService service = (MicroProfileJwtService)this.mpJwtServiceRef.getService();
        if (service == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"MP JWT service is not available", (Object[])new Object[0]);
            }
            return null;
        }
        return new SslRefInfoImpl(service.getSslSupport(), service.getKeyStoreServiceRef(), this.sslRef, this.trustAliasName);
    }

    public String getTrustedAlias() {
        return this.trustAliasName;
    }

    public boolean getJwkEnabled() {
        return this.jwksUri != null;
    }

    public String getJwkEndpointUrl() {
        return this.jwksUri;
    }

    public ConsumerUtils getConsumerUtils() {
        if (this.consumerUtils == null) {
            MicroProfileJwtService service = (MicroProfileJwtService)this.mpJwtServiceRef.getService();
            if (service != null) {
                this.consumerUtils = new ConsumerUtils(service.getKeyStoreServiceRef());
            } else {
                Tr.warning((TraceComponent)tc, (String)"SERVICE_NOT_FOUND_JWT_CONSUMER_NOT_AVAILABLE", (Object[])new Object[]{this.uniqueId});
            }
        }
        return this.consumerUtils;
    }

    public JWKSet getJwkSet() {
        if (this.jwkSet == null) {
            this.jwkSet = new JWKSet();
        }
        return this.jwkSet;
    }

    @Override
    public String getUniqueId() {
        return this.uniqueId;
    }

    public String getSslRef() {
        return this.sslRef;
    }

    @ManualTrace
    public HashMap<String, PublicKey> getPublicKeys() throws MpJwtProcessingException {
        String methodName = "getPublicKeys";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[0]);
        }
        if (this.sslRefInfo == null) {
            MicroProfileJwtService service = (MicroProfileJwtService)this.mpJwtServiceRef.getService();
            if (service == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"MP JWT service is not available", (Object[])new Object[0]);
                }
                if (tc.isDebugEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)methodName, null);
                }
                return null;
            }
            this.sslRefInfo = new SslRefInfoImpl(service.getSslSupport(), service.getKeyStoreServiceRef(), this.sslRef, this.trustAliasName);
        }
        HashMap<String, PublicKey> keys = this.sslRefInfo.getPublicKeys();
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, keys);
        }
        return keys;
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    public SSLContext getSSLContext() throws MpJwtProcessingException {
        String methodName = "getSSLContext";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[0]);
        }
        if (this.sslContext == null) {
            MicroProfileJwtService service = (MicroProfileJwtService)this.mpJwtServiceRef.getService();
            if (service == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"MP JWT service is not available", (Object[])new Object[0]);
                }
                if (tc.isDebugEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)methodName, null);
                }
                return null;
            }
            SSLSupport sslSupport = service.getSslSupport();
            if (sslSupport == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"SSL support could not be found for microprofile jwt service", (Object[])new Object[0]);
                }
                if (tc.isDebugEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)methodName, null);
                }
                return null;
            }
            try {
                JSSEHelper jsseHelper = sslSupport.getJSSEHelper();
                if (jsseHelper != null) {
                    this.sslContext = jsseHelper.getSSLContext(this.sslRef, null, null, true);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("sslContext (" + this.sslRef + ") get: " + this.sslContext), (Object[])new Object[0]);
                    }
                }
            }
            catch (Exception jsseHelper) {
                void e;
                FFDCFilter.processException((Throwable)jsseHelper, (String)"com.ibm.ws.security.mp.jwt.impl.MicroProfileJwtConfigImpl", (String)"494", (Object)this, (Object[])new Object[0]);
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"FAILED_TO_GET_SSL_CONTEXT", (Object[])new Object[]{this.uniqueId, e.getLocalizedMessage()});
                throw new MpJwtProcessingException(msg, (Throwable)e);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)this.sslContext);
        }
        return this.sslContext;
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    public SSLSocketFactory getSSLSocketFactory() throws MpJwtProcessingException {
        String methodName = "getSSLSocketFactory";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[0]);
        }
        if (this.sslContext == null) {
            MicroProfileJwtService service = (MicroProfileJwtService)this.mpJwtServiceRef.getService();
            if (service == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Social login service is not available", (Object[])new Object[0]);
                }
                if (tc.isDebugEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)methodName, null);
                }
                return null;
            }
            SSLSupport sslSupport = service.getSslSupport();
            if (sslSupport == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"SSL support could not be found for microprofile jwt service", (Object[])new Object[0]);
                }
                if (tc.isDebugEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)methodName, null);
                }
                return null;
            }
            try {
                this.sslSocketFactory = sslSupport.getSSLSocketFactory(this.sslRef);
                JSSEHelper jsseHelper = sslSupport.getJSSEHelper();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("sslSocketFactory (" + this.sslRef + ") get: " + this.sslSocketFactory), (Object[])new Object[0]);
                }
            }
            catch (Exception jsseHelper) {
                void e;
                FFDCFilter.processException((Throwable)jsseHelper, (String)"com.ibm.ws.security.mp.jwt.impl.MicroProfileJwtConfigImpl", (String)"539", (Object)this, (Object[])new Object[0]);
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"FAILED_TO_GET_SSL_CONTEXT", (Object[])new Object[]{this.uniqueId, e.getLocalizedMessage()});
                throw new MpJwtProcessingException(msg, (Throwable)e);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)this.sslSocketFactory);
        }
        return this.sslSocketFactory;
    }

    @Override
    public String getUserNameAttribute() {
        return this.userNameAttribute;
    }

    @Override
    public String getGroupNameAttribute() {
        return this.groupNameAttribute;
    }

    @Override
    public String getAuthorizationHeaderScheme() {
        return this.authorizationHeaderScheme;
    }

    public boolean isValidationRequired() {
        return true;
    }

    public long getClockSkew() {
        return this.clockSkewMilliSeconds;
    }

    public long getTokenAge() {
        return this.tokenAgeMilliSeconds;
    }

    public String getKeyManagementKeyAlgorithm() {
        return this.keyManagementKeyAlgorithm;
    }

    public boolean getTokenReuse() {
        return this.tokenReuse;
    }

    @Override
    public boolean ignoreApplicationAuthMethod() {
        return this.ignoreApplicationAuthMethod;
    }

    @Override
    public boolean getMapToUserRegistry() {
        return this.mapToUserRegistry;
    }

    @Override
    public String getAuthFilterRef() {
        return this.authFilterRef;
    }

    public boolean getUseSystemPropertiesForHttpClientConnections() {
        return this.useSystemPropertiesForHttpClientConnections;
    }

    @Override
    public String getTokenHeader() {
        return this.tokenHeader;
    }

    @Override
    public String getCookieName() {
        return this.cookieName;
    }

    public List<String> getAMRClaim() {
        return null;
    }

    public String getKeyManagementKeyAlias() {
        return this.keyManagementKeyAlias;
    }

    public Key getJweDecryptionKey() throws GeneralSecurityException {
        String keyAlias = this.getKeyManagementKeyAlias();
        if (keyAlias != null) {
            String keyStoreRef = this.getKeyStoreRef();
            return JwtUtils.getPrivateKey((String)keyAlias, (String)keyStoreRef);
        }
        return null;
    }
}

