/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.telemetry.internal.common.cdi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.telemetry.internal.interfaces.OpenTelemetryAccessor;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.annotations.SpanAttribute;
import io.opentelemetry.instrumentation.annotations.WithSpan;
import io.opentelemetry.instrumentation.api.annotation.support.MethodSpanAttributesExtractor;
import io.opentelemetry.instrumentation.api.annotation.support.ParameterAttributeNamesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.util.SpanNames;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.security.AccessController;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class AbstractWithSpanInterceptor {
    protected static final TraceComponent tc = Tr.register(AbstractWithSpanInterceptor.class, (String)"TELEMETRY", (String)"io.openliberty.microprofile.telemetry.internal.common.resources.MPTelemetry");
    protected final String instrumentationName = "io.openliberty.microprofile.telemetry";
    protected final Instrumenter<InvocationContext, Void> instrumenter;
    static final long serialVersionUID = 7472044663691524741L;

    public AbstractWithSpanInterceptor() {
        this.instrumenter = null;
    }

    @Inject
    public AbstractWithSpanInterceptor(OpenTelemetry openTelemetry) {
        MethodSpanAttributesExtractor<InvocationContext, Void> attributesExtractor = this.getMethodSpanAttributesExtractor();
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)"io.openliberty.microprofile.telemetry", (SpanNameExtractor)new MethodRequestSpanNameExtractor());
        this.instrumenter = builder.addAttributesExtractor(attributesExtractor).buildInstrumenter(context -> this.spanKindFromMethod((InvocationContext)context));
    }

    protected abstract MethodSpanAttributesExtractor<InvocationContext, Void> getMethodSpanAttributesExtractor();

    private SpanKind spanKindFromMethod(InvocationContext context) {
        return this.getWithSpanBinding(context).map(WithSpan::kind).orElse(SpanKind.INTERNAL);
    }

    @AroundInvoke
    @FFDCIgnore(value={Throwable.class})
    public Object span(InvocationContext invocationContext) throws Exception {
        boolean shouldStart;
        Context parentContext = Context.current();
        Context spanContext = null;
        Scope scope = null;
        boolean bl = shouldStart = this.instrumenter != null && this.instrumenter.shouldStart(parentContext, (Object)invocationContext);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Method " + invocationContext.getMethod().toString() + " Should start: " + shouldStart), (Object[])new Object[0]);
        }
        if (shouldStart) {
            spanContext = this.instrumenter.start(parentContext, (Object)invocationContext);
            scope = spanContext.makeCurrent();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("spanContext " + spanContext.toString() + " has started and is now the current context"), (Object[])new Object[0]);
            }
        }
        try {
            Object result = invocationContext.proceed();
            if (shouldStart) {
                this.instrumenter.end(spanContext, (Object)invocationContext, null, null);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("spanContext " + spanContext.toString() + " has ended"), (Object[])new Object[0]);
                }
            }
            Object object = result;
            return object;
        }
        catch (Throwable error) {
            if (shouldStart) {
                this.instrumenter.end(spanContext, (Object)invocationContext, null, error);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("spanContext " + spanContext.toString() + " has ended with an exception"), (Object[])new Object[]{error});
                }
            }
            throw error;
        }
        finally {
            if (scope != null) {
                scope.close();
            }
        }
    }

    protected static WithSpanParameterAttributeNamesExtractor getNewWithSpanParameterAttributeNamesExtractor() {
        return new WithSpanParameterAttributeNamesExtractor();
    }

    private Optional<WithSpan> getWithSpanBinding(InvocationContext context) {
        Set bindings = OpenTelemetryAccessor.getCdiService().getInterceptorBindingsFromInvocationContext(context);
        for (Annotation binding : bindings) {
            if (!binding.annotationType().equals(WithSpan.class)) continue;
            return Optional.of((WithSpan)binding);
        }
        return Optional.empty();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    protected final class MethodRequestSpanNameExtractor
    implements SpanNameExtractor<InvocationContext> {
        static final long serialVersionUID = 1984825530996255611L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        protected MethodRequestSpanNameExtractor() {
        }

        public String extract(InvocationContext context) {
            return AbstractWithSpanInterceptor.this.getWithSpanBinding(context).map(WithSpan::value).filter(Predicate.not(String::isEmpty)).orElse(this.getNameFromMethod(context.getMethod()));
        }

        private String getNameFromMethod(Method method) {
            if (System.getSecurityManager() != null) {
                return AccessController.doPrivileged(() -> SpanNames.fromMethod((Method)method));
            }
            return SpanNames.fromMethod((Method)method);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.telemetry.internal.common.cdi.AbstractWithSpanInterceptor$MethodRequestSpanNameExtractor", MethodRequestSpanNameExtractor.class, (String)"TELEMETRY", (String)"io.openliberty.microprofile.telemetry.internal.common.resources.MPTelemetry");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    protected static final class WithSpanParameterAttributeNamesExtractor
    implements ParameterAttributeNamesExtractor {
        static final long serialVersionUID = -4186115730087443659L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        protected WithSpanParameterAttributeNamesExtractor() {
        }

        protected static String attributeName(Parameter parameter) {
            SpanAttribute spanAttribute = parameter.getDeclaredAnnotation(SpanAttribute.class);
            if (spanAttribute == null) {
                return null;
            }
            String value = spanAttribute.value();
            if (!value.isEmpty()) {
                return value;
            }
            if (parameter.isNamePresent()) {
                return parameter.getName();
            }
            return null;
        }

        public String[] extract(Method method, Parameter[] parameters) {
            String[] attributeNames = new String[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                attributeNames[i] = WithSpanParameterAttributeNamesExtractor.attributeName(parameters[i]);
            }
            return attributeNames;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.telemetry.internal.common.cdi.AbstractWithSpanInterceptor$WithSpanParameterAttributeNamesExtractor", WithSpanParameterAttributeNamesExtractor.class, (String)"TELEMETRY", (String)"io.openliberty.microprofile.telemetry.internal.common.resources.MPTelemetry");
        }
    }
}

