/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.telemetry.internal.common.helpers;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import java.security.AccessController;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OSGIHelpers {
    static final long serialVersionUID = -3957862888777837588L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private static BundleContext getBundleContext(Class<?> clazz) {
        Bundle bundle;
        BundleContext context = null;
        if (FrameworkState.isValid() && (bundle = FrameworkUtil.getBundle(clazz)) != null) {
            context = AccessController.doPrivileged(() -> bundle.getBundleContext());
        }
        return context;
    }

    public static <T> T getService(Class<T> serviceClass, Class<?> callingClass) throws InvalidFrameworkStateRuntimeException {
        BundleContext bundleContext = OSGIHelpers.getBundleContext(callingClass);
        if (!FrameworkState.isValid()) {
            throw new InvalidFrameworkStateRuntimeException("Invalid OSGi Framework State");
        }
        ServiceReference ref = AccessController.doPrivileged(() -> bundleContext.getServiceReference(serviceClass));
        Object service = null;
        if (ref != null) {
            service = AccessController.doPrivileged(() -> bundleContext.getService(ref));
        }
        if (service == null) {
            if (!FrameworkState.isValid()) {
                throw new InvalidFrameworkStateRuntimeException("Invalid OSGi Framework State");
            }
            throw new InvalidFrameworkStateRuntimeException("Service " + serviceClass.getCanonicalName() + " not Found");
        }
        return (T)service;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.telemetry.internal.common.helpers.OSGIHelpers", OSGIHelpers.class, (String)"TELEMETRY", (String)"io.openliberty.microprofile.telemetry.internal.common.resources.MPTelemetry");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class InvalidFrameworkStateRuntimeException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public InvalidFrameworkStateRuntimeException(String s) {
            super(s);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.telemetry.internal.common.helpers.OSGIHelpers$InvalidFrameworkStateRuntimeException", InvalidFrameworkStateRuntimeException.class, (String)"TELEMETRY", (String)"io.openliberty.microprofile.telemetry.internal.common.resources.MPTelemetry");
        }
    }
}

