/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.telemetry.internal.interfaces;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.cdi.CDIService;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.telemetry.internal.common.helpers.OSGIHelpers;
import io.openliberty.microprofile.telemetry.internal.common.info.ErrorOpenTelemetryInfo;
import io.openliberty.microprofile.telemetry.internal.common.info.OpenTelemetryInfo;
import io.openliberty.microprofile.telemetry.internal.interfaces.OpenTelemetryInfoFactory;
import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import java.util.Optional;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(immediate=true)
public class OpenTelemetryAccessor {
    private static final TraceComponent tc = Tr.register(OpenTelemetryAccessor.class, (String)"TELEMETRY", (String)"io.openliberty.microprofile.telemetry.internal.common.resources.MPTelemetry");
    private static volatile Optional<OpenTelemetryAccessor> instance = Optional.empty();
    @Reference
    private CDIService cdiService;
    static final long serialVersionUID = -6597740938887279729L;

    @Activate
    protected void activate() {
        instance = Optional.of(this);
    }

    @Deactivate
    protected void deactivate() {
        if (instance.isPresent() && instance.get() == this) {
            instance = Optional.empty();
        }
    }

    public static OpenTelemetryInfo getOpenTelemetryInfo() {
        try {
            OpenTelemetryInfoFactory factory = OSGIHelpers.getService(OpenTelemetryInfoFactory.class, OpenTelemetryAccessor.class);
            return factory.getOpenTelemetryInfo();
        }
        catch (Exception factory) {
            FFDCFilter.processException((Throwable)factory, (String)"io.openliberty.microprofile.telemetry.internal.interfaces.OpenTelemetryAccessor", (String)"66", null, (Object[])new Object[0]);
            return new ErrorOpenTelemetryInfo();
        }
    }

    public static Tracer getTracer() {
        return OpenTelemetryAccessor.getOpenTelemetryInfo().getTracer();
    }

    public static Span getSpan() {
        return Span.current();
    }

    public static Baggage getBaggage() {
        return Baggage.current();
    }

    public static CDIService getCdiService() {
        return instance.map(i -> i.cdiService).orElseThrow(() -> new IllegalStateException("Unable to get CDIService"));
    }
}

