/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.jitdeploy;

import com.ibm.ejs.container.EJBConfigurationException;
import com.ibm.ejs.container.util.DeploymentUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejbcontainer.jitdeploy.CORBA_Utils;
import com.ibm.ws.ejbcontainer.jitdeploy.JITUtils;
import com.ibm.ws.ejbcontainer.jitdeploy.RMItoIDL;
import com.ibm.wsspi.ejbcontainer.JITDeploy;
import java.lang.reflect.Modifier;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

public final class JIT_Stub {
    private static final TraceComponent tc = Tr.register(JIT_Stub.class, (String)"JITDeploy", (String)"com.ibm.ejs.container.container");
    private static final Type TYPE_RemoteException = Type.getType((String)"Ljava/rmi/RemoteException;");
    private static final Type TYPE_TransactionRolledbackException = Type.getType((String)"Ljakarta/transaction/TransactionRolledbackException;");

    public static String getRemoteInterfaceName(String stubClassName) {
        if (stubClassName != null && stubClassName.endsWith("_Stub") && !stubClassName.endsWith("._Stub")) {
            StringBuilder nameBuilder = new StringBuilder(stubClassName);
            nameBuilder.setLength(nameBuilder.length() - 5);
            int packageOffset = nameBuilder.lastIndexOf(".") + 1;
            if (nameBuilder.charAt(packageOffset) != '_') {
                return null;
            }
            nameBuilder.deleteCharAt(packageOffset);
            return nameBuilder.toString();
        }
        return null;
    }

    public static byte[] generateStubBytes(Class<?> remoteInterface, int rmicCompatible) throws EJBConfigurationException {
        String stubClassName = JIT_Stub.getStubClassName(remoteInterface.getName());
        java.lang.reflect.Method[] remoteMethods = remoteInterface.getMethods();
        String[] idlNames = RMItoIDL.getIdlMethodNames(remoteMethods);
        byte[] classBytes = JIT_Stub.generateClassBytes(stubClassName, remoteInterface, remoteMethods, idlNames, rmicCompatible);
        return classBytes;
    }

    public static String getStubClassName(String remoteInterfaceName) {
        StringBuilder stubBuilder = new StringBuilder(remoteInterfaceName);
        int packageOffset = Math.max(remoteInterfaceName.lastIndexOf(46) + 1, remoteInterfaceName.lastIndexOf(36) + 1);
        stubBuilder.insert(packageOffset, '_');
        stubBuilder.append("_Stub");
        return stubBuilder.toString();
    }

    static byte[] generateClassBytes(String stubClassName, Class<?> remoteInterface, java.lang.reflect.Method[] remoteMethods, String[] idlNames, int rmicCompatible) throws EJBConfigurationException {
        int numMethods = remoteMethods.length;
        String internalStubClassName = JITUtils.convertClassName(stubClassName);
        String internalInterfaceName = JITUtils.convertClassName(remoteInterface.getName());
        if (!Modifier.isInterface(remoteInterface.getModifiers())) {
            throw new EJBConfigurationException("The " + remoteInterface.getName() + " class is not an interface class. Stubs may only be generated for interface classes.");
        }
        boolean isRmiRemote = Remote.class.isAssignableFrom(remoteInterface);
        boolean isAbstractInterface = isRmiRemote || CORBA_Utils.isAbstractInterface(remoteInterface, rmicCompatible);
        String[] remoteInterfaceNames = isRmiRemote ? new String[]{internalInterfaceName} : new String[]{internalInterfaceName, "java/rmi/Remote"};
        LinkedHashSet<String> classConstantFieldNames = new LinkedHashSet<String>();
        Class[][] checkedExceptions = new Class[numMethods][];
        for (int i = 0; i < numMethods; ++i) {
            checkedExceptions[i] = DeploymentUtil.getCheckedExceptions(remoteMethods[i], isRmiRemote, DeploymentUtil.DeploymentTarget.STUB);
        }
        if (TraceComponent.isAnyTracingEnabled()) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"generateClassBytes", (Object[])new Object[0]);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("     className = " + internalStubClassName), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("     interface = " + internalInterfaceName), (Object[])new Object[0]);
                if (isRmiRemote) {
                    Tr.debug((TraceComponent)tc, (String)"     implements java.rmi.Remote", (Object[])new Object[0]);
                }
            }
        }
        ClassWriter cw = new ClassWriter(1);
        cw.visit(46, 33, internalStubClassName, null, isAbstractInterface ? "javax/rmi/CORBA/Stub" : "com/ibm/ejs/container/SerializableStub", remoteInterfaceNames);
        String sourceFileName = stubClassName.substring(stubClassName.lastIndexOf(".") + 1) + ".java";
        cw.visitSource(sourceFileName, null);
        JIT_Stub.addFields(cw);
        JIT_Stub.initializeStaticFields(cw, internalStubClassName, remoteInterface);
        JIT_Stub.addCtor(cw, internalStubClassName, classConstantFieldNames, remoteInterface, isAbstractInterface);
        JIT_Stub.addCommonStubMethods(cw, internalStubClassName);
        for (int i = 0; i < numMethods; ++i) {
            JIT_Stub.addStubMethod(cw, internalStubClassName, classConstantFieldNames, remoteMethods[i], checkedExceptions[i], idlNames[i], isRmiRemote, rmicCompatible);
        }
        JITUtils.addClassConstantMembers((ClassVisitor)cw, classConstantFieldNames);
        cw.visitEnd();
        byte[] classBytes = cw.toByteArray();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            JITUtils.writeToClassFile(internalStubClassName, classBytes);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("generateClassBytes: " + classBytes.length + " bytes"));
        }
        return classBytes;
    }

    private static void addFields(ClassWriter cw) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"     adding field : _type_ids [Ljava/lang/String;", (Object[])new Object[0]);
        }
        FieldVisitor fv = cw.visitField(26, "_type_ids", "[Ljava/lang/String;", null, null);
        fv.visitEnd();
    }

    private static void initializeStaticFields(ClassWriter cw, String stubClassName, Class<?> remoteInterface) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"     adding method : <clinit> ()V", (Object[])new Object[0]);
        }
        Method m = new Method("<clinit>", Type.VOID_TYPE, new Type[0]);
        GeneratorAdapter mg = new GeneratorAdapter(8, m, null, null, (ClassVisitor)cw);
        mg.visitCode();
        String[] remoteTypes = CORBA_Utils.getRemoteTypeIds(remoteInterface);
        mg.push(remoteTypes.length);
        mg.visitTypeInsn(189, "java/lang/String");
        for (int i = 0; i < remoteTypes.length; ++i) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("        _type_ids = " + remoteTypes[i]), (Object[])new Object[0]);
            }
            mg.visitInsn(89);
            mg.push(i);
            mg.visitLdcInsn((Object)remoteTypes[i]);
            mg.visitInsn(83);
        }
        mg.visitFieldInsn(179, stubClassName, "_type_ids", "[Ljava/lang/String;");
        mg.visitInsn(177);
        mg.endMethod();
        mg.visitEnd();
    }

    private static void addCtor(ClassWriter cw, String stubClassName, Set<String> classConstantFieldNames, Class<?> remoteInterface, boolean isAbstractInterface) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"     adding method : <init> ()V", (Object[])new Object[0]);
        }
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        if (isAbstractInterface) {
            mv.visitMethodInsn(183, "javax/rmi/CORBA/Stub", "<init>", "()V");
        } else {
            JITUtils.loadClassConstant(mv, stubClassName, classConstantFieldNames, remoteInterface);
            mv.visitMethodInsn(183, "com/ibm/ejs/container/SerializableStub", "<init>", "(Ljava/lang/Class;)V");
        }
        mv.visitInsn(177);
        mv.visitMaxs(3, 1);
        mv.visitEnd();
    }

    private static void addCommonStubMethods(ClassWriter cw, String stubClassName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"     adding method : _ids ()[Ljava/lang/String;", (Object[])new Object[0]);
        }
        MethodVisitor mv = cw.visitMethod(1, "_ids", "()[Ljava/lang/String;", null, null);
        mv.visitCode();
        mv.visitFieldInsn(178, stubClassName, "_type_ids", "[Ljava/lang/String;");
        mv.visitMethodInsn(182, "java/lang/Object", "clone", "()Ljava/lang/Object;");
        mv.visitTypeInsn(192, "[Ljava/lang/String;");
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private static void addStubMethod(ClassWriter cw, String className, Set<String> classConstantFieldNames, java.lang.reflect.Method method, Class<?>[] checkedExceptions, String idlName, boolean isRmiRemote, int rmicCompatible) throws EJBConfigurationException {
        int i;
        int pass;
        boolean throwsRemoteEx;
        String methodName = method.getName();
        String methodSignature = JITUtils.jdiMethodSignature(method);
        Class<?> declaringClass = method.getDeclaringClass();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("     adding method : " + methodName + " " + methodSignature), (Object[])new Object[0]);
        }
        Class<?>[] methodExceptions = method.getExceptionTypes();
        boolean bl = throwsRemoteEx = isRmiRemote || JITDeploy.ThrowRemoteFromEjb3Stub;
        if (!throwsRemoteEx) {
            for (Class<?> exClass : methodExceptions) {
                if (!RemoteException.class.isAssignableFrom(exClass)) continue;
                throwsRemoteEx = true;
                break;
            }
        }
        Class<?>[] methodParameters = method.getParameterTypes();
        Class<?> returnClass = method.getReturnType();
        Type returnType = Type.getType(returnClass);
        Type[] argTypes = JITUtils.getTypes(methodParameters);
        Type[] exceptionTypes = JITUtils.getTypes(methodExceptions);
        Type[] checkedTypes = JITUtils.getTypes(checkedExceptions);
        Type declaringType = Type.getType(declaringClass);
        String declaringName = JITUtils.convertClassName(declaringClass.getName());
        int numArgs = methodParameters.length;
        Method m = new Method(methodName, returnType, argTypes);
        GeneratorAdapter mg = new GeneratorAdapter(1, m, null, exceptionTypes, (ClassVisitor)cw);
        mg.visitCode();
        Label map_remote_try_begin = new Label();
        if (!throwsRemoteEx) {
            mg.visitLabel(map_remote_try_begin);
        }
        int servantObj = mg.newLocal(CORBA_Utils.TYPE_CORBA_ServantObject);
        Label do_while_begin = new Label();
        mg.visitLabel(do_while_begin);
        mg.loadThis();
        mg.visitMethodInsn(184, "javax/rmi/CORBA/Util", "isLocal", "(Ljavax/rmi/CORBA/Stub;)Z");
        Label while_not_local_end = new Label();
        mg.visitJumpInsn(154, while_not_local_end);
        Type inputStreamType = CORBA_Utils.TYPE_CORBA_2_3_InputStream;
        int inputstream = mg.newLocal(inputStreamType);
        mg.visitInsn(1);
        mg.storeLocal(inputstream);
        Label not_local_try_begin = new Label();
        mg.visitLabel(not_local_try_begin);
        Type outputStreamType = CORBA_Utils.TYPE_CORBA_2_3_OutputStream;
        int outputstream = mg.newLocal(outputStreamType);
        mg.loadThis();
        mg.push(idlName);
        mg.push(true);
        mg.visitMethodInsn(182, "org/omg/CORBA/portable/ObjectImpl", "_request", "(Ljava/lang/String;Z)Lorg/omg/CORBA/portable/OutputStream;");
        mg.checkCast(outputStreamType);
        mg.storeLocal(outputstream);
        for (int i2 = 0; i2 < numArgs; ++i2) {
            JITUtils.setLineNumber((MethodVisitor)mg, 100 + i2);
            mg.loadLocal(outputstream);
            mg.loadArg(i2);
            CORBA_Utils.write_value(mg, className, classConstantFieldNames, method, methodParameters[i2], rmicCompatible);
        }
        JITUtils.setLineNumber((MethodVisitor)mg, 1);
        mg.loadThis();
        mg.loadLocal(outputstream);
        mg.visitMethodInsn(182, "org/omg/CORBA/portable/ObjectImpl", "_invoke", "(Lorg/omg/CORBA/portable/OutputStream;)Lorg/omg/CORBA/portable/InputStream;");
        if (returnType == Type.VOID_TYPE) {
            mg.pop();
        } else {
            mg.checkCast(inputStreamType);
            mg.storeLocal(inputstream);
        }
        JITUtils.setLineNumber((MethodVisitor)mg, 2);
        int returnValue = -1;
        if (returnType != Type.VOID_TYPE) {
            returnValue = mg.newLocal(returnType);
            mg.loadLocal(inputstream);
            CORBA_Utils.read_value(mg, className, classConstantFieldNames, method, returnClass, returnType, rmicCompatible);
            mg.storeLocal(returnValue);
        }
        Label not_local_finally_begin = new Label();
        mg.visitJumpInsn(168, not_local_finally_begin);
        if (returnType != Type.VOID_TYPE) {
            mg.loadLocal(returnValue);
        }
        mg.returnValue();
        Label not_local_inner_try_end = new Label();
        mg.visitLabel(not_local_inner_try_end);
        JITUtils.setLineNumber((MethodVisitor)mg, 1000);
        Label catch_appException_label = not_local_inner_try_end;
        int appException = mg.newLocal(CORBA_Utils.TYPE_CORBA_ApplicationException);
        mg.storeLocal(appException);
        mg.loadLocal(appException);
        mg.visitMethodInsn(182, "org/omg/CORBA/portable/ApplicationException", "getInputStream", "()Lorg/omg/CORBA/portable/InputStream;");
        if (inputStreamType != CORBA_Utils.TYPE_CORBA_InputStream) {
            mg.checkCast(inputStreamType);
        }
        mg.storeLocal(inputstream);
        int exIdlName = mg.newLocal(JITUtils.TYPE_String);
        mg.loadLocal(inputstream);
        mg.visitMethodInsn(182, "org/omg/CORBA/portable/InputStream", "read_string", "()Ljava/lang/String;");
        mg.storeLocal(exIdlName);
        boolean rmicCompatibleExceptions = JITDeploy.isRMICCompatibleExceptions(rmicCompatible);
        HashSet<String> exceptionNamesIDLUsed = rmicCompatibleExceptions ? null : new HashSet<String>();
        int n = pass = rmicCompatibleExceptions ? 1 : 0;
        while (pass < 2) {
            boolean mangleComponents = pass == 1;
            for (int i3 = 0; i3 < checkedExceptions.length; ++i3) {
                String exceptionName = checkedExceptions[i3].getName();
                String exceptionNameIDL = RMItoIDL.getIdlExceptionName(exceptionName, mangleComponents);
                if (exceptionNamesIDLUsed != null && !exceptionNamesIDLUsed.add(exceptionNameIDL)) continue;
                JITUtils.setLineNumber((MethodVisitor)mg, 1001 + i3);
                mg.loadLocal(exIdlName);
                mg.visitLdcInsn((Object)exceptionNameIDL);
                mg.visitMethodInsn(182, "java/lang/String", "equals", "(Ljava/lang/Object;)Z");
                Label if_equals_else = new Label();
                mg.visitJumpInsn(153, if_equals_else);
                mg.loadLocal(inputstream);
                JITUtils.loadClassConstant((MethodVisitor)mg, className, classConstantFieldNames, checkedExceptions[i3]);
                mg.visitMethodInsn(182, "org/omg/CORBA_2_3/portable/InputStream", "read_value", "(Ljava/lang/Class;)Ljava/io/Serializable;");
                JITUtils.checkCast((MethodVisitor)mg, checkedTypes[i3].getInternalName());
                mg.visitInsn(191);
                mg.visitLabel(if_equals_else);
            }
            ++pass;
        }
        JITUtils.setLineNumber((MethodVisitor)mg, 1);
        mg.visitTypeInsn(187, "java/rmi/UnexpectedException");
        mg.visitInsn(89);
        mg.loadLocal(exIdlName);
        mg.visitMethodInsn(183, "java/rmi/UnexpectedException", "<init>", "(Ljava/lang/String;)V");
        mg.visitInsn(191);
        Label catch_remarshalException_label = new Label();
        mg.visitLabel(catch_remarshalException_label);
        mg.visitInsn(87);
        mg.visitJumpInsn(168, not_local_finally_begin);
        mg.visitJumpInsn(167, do_while_begin);
        Label not_local_outer_try_end = new Label();
        mg.visitLabel(not_local_outer_try_end);
        Label catch_sysException_label = not_local_outer_try_end;
        int sysException = mg.newLocal(CORBA_Utils.TYPE_CORBA_SystemException);
        mg.storeLocal(sysException);
        mg.loadLocal(sysException);
        mg.visitMethodInsn(184, "javax/rmi/CORBA/Util", "mapSystemException", "(Lorg/omg/CORBA/SystemException;)Ljava/rmi/RemoteException;");
        mg.visitInsn(191);
        Label not_local_outer_try_catch_end = new Label();
        mg.visitLabel(not_local_outer_try_catch_end);
        Label not_local_finally_ex = not_local_outer_try_catch_end;
        int not_local_finally_th = mg.newLocal(JITUtils.TYPE_Throwable);
        mg.storeLocal(not_local_finally_th);
        mg.visitJumpInsn(168, not_local_finally_begin);
        mg.loadLocal(not_local_finally_th);
        mg.visitInsn(191);
        mg.visitLabel(not_local_finally_begin);
        int not_local_finally_return = mg.newLocal(JITUtils.TYPE_Object);
        mg.storeLocal(not_local_finally_return);
        mg.loadThis();
        mg.loadLocal(inputstream);
        mg.visitMethodInsn(182, "org/omg/CORBA/portable/ObjectImpl", "_releaseReply", "(Lorg/omg/CORBA/portable/InputStream;)V");
        mg.ret(not_local_finally_return);
        mg.visitLabel(while_not_local_end);
        mg.loadThis();
        mg.push(idlName);
        JITUtils.loadClassConstant((MethodVisitor)mg, className, classConstantFieldNames, declaringClass);
        mg.visitMethodInsn(182, "org/omg/CORBA/portable/ObjectImpl", "_servant_preinvoke", "(Ljava/lang/String;Ljava/lang/Class;)Lorg/omg/CORBA/portable/ServantObject;");
        mg.storeLocal(servantObj);
        mg.loadLocal(servantObj);
        mg.visitJumpInsn(198, do_while_begin);
        Label local_try_begin = new Label();
        mg.visitLabel(local_try_begin);
        int numMutableArgs = 0;
        int firstMutableArg = -1;
        int[] argCopy = null;
        if (numArgs > 0) {
            argCopy = new int[numArgs];
            for (i = 0; i < numArgs; ++i) {
                if (CORBA_Utils.isMutable(methodParameters[i])) {
                    argCopy[i] = mg.newLocal(argTypes[i]);
                    ++numMutableArgs;
                    if (firstMutableArg != -1) continue;
                    firstMutableArg = i;
                    continue;
                }
                argCopy[i] = -1;
            }
        }
        if (numMutableArgs == 1) {
            JITUtils.setLineNumber((MethodVisitor)mg, 100);
            mg.loadArg(firstMutableArg);
            mg.loadThis();
            mg.visitMethodInsn(182, "org/omg/CORBA/portable/ObjectImpl", "_orb", "()Lorg/omg/CORBA/ORB;");
            mg.visitMethodInsn(184, "javax/rmi/CORBA/Util", "copyObject", "(Ljava/lang/Object;Lorg/omg/CORBA/ORB;)Ljava/lang/Object;");
            JITUtils.checkCast((MethodVisitor)mg, argTypes[firstMutableArg].getInternalName());
            mg.storeLocal(argCopy[firstMutableArg]);
        } else if (numMutableArgs > 1) {
            JITUtils.setLineNumber((MethodVisitor)mg, 100);
            mg.push(numMutableArgs);
            mg.visitTypeInsn(189, "java/lang/Object");
            int argCopyArrayIndex = 0;
            for (int i4 = firstMutableArg; i4 < numArgs; ++i4) {
                if (argCopy[i4] <= -1) continue;
                mg.visitInsn(89);
                mg.push(argCopyArrayIndex++);
                mg.loadArg(i4);
                mg.visitInsn(83);
            }
            mg.loadThis();
            mg.visitMethodInsn(182, "org/omg/CORBA/portable/ObjectImpl", "_orb", "()Lorg/omg/CORBA/ORB;");
            mg.visitMethodInsn(184, "javax/rmi/CORBA/Util", "copyObjects", "([Ljava/lang/Object;Lorg/omg/CORBA/ORB;)[Ljava/lang/Object;");
            int argCopyArray = mg.newLocal(JITUtils.TYPE_Object_ARRAY);
            mg.storeLocal(argCopyArray);
            argCopyArrayIndex = 0;
            for (int i5 = firstMutableArg; i5 < numArgs; ++i5) {
                if (argCopy[i5] <= -1) continue;
                JITUtils.setLineNumber((MethodVisitor)mg, 100 + i5);
                mg.loadLocal(argCopyArray);
                mg.push(argCopyArrayIndex++);
                mg.visitInsn(50);
                JITUtils.checkCast((MethodVisitor)mg, argTypes[i5].getInternalName());
                mg.storeLocal(argCopy[i5]);
            }
        }
        JITUtils.setLineNumber((MethodVisitor)mg, 1);
        mg.loadLocal(servantObj);
        mg.visitFieldInsn(180, "org/omg/CORBA/portable/ServantObject", "servant", "Ljava/lang/Object;");
        JITUtils.checkCast((MethodVisitor)mg, declaringType.getInternalName());
        for (i = 0; i < numArgs; ++i) {
            if (argCopy[i] > -1) {
                mg.loadLocal(argCopy[i]);
                continue;
            }
            mg.loadArg(i);
        }
        mg.visitMethodInsn(185, declaringName, methodName, m.getDescriptor());
        if (returnType != Type.VOID_TYPE) {
            JITUtils.setLineNumber((MethodVisitor)mg, 2);
            returnValue = mg.newLocal(returnType);
            mg.storeLocal(returnValue);
            if (CORBA_Utils.isMutable(returnClass)) {
                mg.loadLocal(returnValue);
                mg.loadThis();
                mg.visitMethodInsn(182, "org/omg/CORBA/portable/ObjectImpl", "_orb", "()Lorg/omg/CORBA/ORB;");
                mg.visitMethodInsn(184, "javax/rmi/CORBA/Util", "copyObject", "(Ljava/lang/Object;Lorg/omg/CORBA/ORB;)Ljava/lang/Object;");
                JITUtils.checkCast((MethodVisitor)mg, returnType.getInternalName());
                mg.storeLocal(returnValue);
            }
        }
        Label local_finally_begin = new Label();
        mg.visitJumpInsn(168, local_finally_begin);
        if (returnType != Type.VOID_TYPE) {
            mg.loadLocal(returnValue);
        }
        mg.returnValue();
        Label local_try_end = new Label();
        mg.visitLabel(local_try_end);
        JITUtils.setLineNumber((MethodVisitor)mg, 1000);
        Label catch_throwable_label = local_try_end;
        int ex = mg.newLocal(JITUtils.TYPE_Throwable);
        mg.storeLocal(ex);
        int exCopy = mg.newLocal(JITUtils.TYPE_Object);
        mg.loadLocal(ex);
        mg.loadThis();
        mg.visitMethodInsn(182, "org/omg/CORBA/portable/ObjectImpl", "_orb", "()Lorg/omg/CORBA/ORB;");
        mg.visitMethodInsn(184, "javax/rmi/CORBA/Util", "copyObject", "(Ljava/lang/Object;Lorg/omg/CORBA/ORB;)Ljava/lang/Object;");
        mg.storeLocal(exCopy);
        Label[] checked_else = new Label[checkedExceptions.length];
        for (int i6 = 0; i6 < checkedExceptions.length; ++i6) {
            JITUtils.setLineNumber((MethodVisitor)mg, 1001 + i6);
            String checkedName = JITUtils.convertClassName(checkedExceptions[i6].getName());
            mg.loadLocal(exCopy);
            mg.visitTypeInsn(193, checkedName);
            checked_else[i6] = new Label();
            mg.visitJumpInsn(153, checked_else[i6]);
            mg.loadLocal(exCopy);
            mg.visitTypeInsn(192, checkedName);
            mg.visitInsn(191);
            mg.visitLabel(checked_else[i6]);
        }
        JITUtils.setLineNumber((MethodVisitor)mg, 1);
        mg.loadLocal(exCopy);
        mg.checkCast(JITUtils.TYPE_Throwable);
        mg.visitMethodInsn(184, "javax/rmi/CORBA/Util", "wrapException", "(Ljava/lang/Throwable;)Ljava/rmi/RemoteException;");
        mg.visitInsn(191);
        Label local_try_catch_end = new Label();
        mg.visitLabel(local_try_catch_end);
        Label local_finally_ex = local_try_catch_end;
        int local_finally_th = mg.newLocal(JITUtils.TYPE_Throwable);
        mg.storeLocal(local_finally_th);
        mg.visitJumpInsn(168, local_finally_begin);
        mg.loadLocal(local_finally_th);
        mg.visitInsn(191);
        mg.visitLabel(local_finally_begin);
        int local_finally_return = mg.newLocal(JITUtils.TYPE_Object);
        mg.storeLocal(local_finally_return);
        mg.loadThis();
        mg.loadLocal(servantObj);
        mg.visitMethodInsn(182, "org/omg/CORBA/portable/ObjectImpl", "_servant_postinvoke", "(Lorg/omg/CORBA/portable/ServantObject;)V");
        mg.ret(local_finally_return);
        Label map_remote_try_end = null;
        Label catch_tran_rollback_label = null;
        Label catch_remote_label = null;
        if (!throwsRemoteEx) {
            map_remote_try_end = new Label();
            mg.visitLabel(map_remote_try_end);
            JITUtils.setLineNumber((MethodVisitor)mg, 1100);
            catch_tran_rollback_label = map_remote_try_end;
            int trbex = mg.newLocal(TYPE_TransactionRolledbackException);
            mg.storeLocal(trbex);
            mg.visitTypeInsn(187, "jakarta/ejb/EJBTransactionRolledbackException");
            mg.visitInsn(89);
            mg.visitInsn(1);
            mg.loadLocal(trbex);
            mg.visitMethodInsn(183, "jakarta/ejb/EJBTransactionRolledbackException", "<init>", "(Ljava/lang/String;Ljava/lang/Exception;)V");
            mg.visitInsn(191);
            JITUtils.setLineNumber((MethodVisitor)mg, 1101);
            catch_remote_label = new Label();
            mg.visitLabel(catch_remote_label);
            int rex = mg.newLocal(TYPE_RemoteException);
            mg.storeLocal(rex);
            mg.visitTypeInsn(187, "jakarta/ejb/EJBException");
            mg.visitInsn(89);
            mg.loadLocal(rex);
            mg.visitMethodInsn(183, "jakarta/ejb/EJBException", "<init>", "(Ljava/lang/Exception;)V");
            mg.visitInsn(191);
        }
        mg.visitTryCatchBlock(not_local_try_begin, not_local_inner_try_end, catch_appException_label, "org/omg/CORBA/portable/ApplicationException");
        mg.visitTryCatchBlock(not_local_try_begin, not_local_inner_try_end, catch_remarshalException_label, "org/omg/CORBA/portable/RemarshalException");
        mg.visitTryCatchBlock(not_local_try_begin, not_local_outer_try_end, catch_sysException_label, "org/omg/CORBA/SystemException");
        mg.visitTryCatchBlock(not_local_try_begin, not_local_outer_try_catch_end, not_local_finally_ex, null);
        mg.visitTryCatchBlock(local_try_begin, local_try_end, catch_throwable_label, "java/lang/Throwable");
        mg.visitTryCatchBlock(local_try_begin, local_try_catch_end, local_finally_ex, null);
        if (!throwsRemoteEx) {
            mg.visitTryCatchBlock(map_remote_try_begin, map_remote_try_end, catch_tran_rollback_label, "jakarta/transaction/TransactionRolledbackException");
            mg.visitTryCatchBlock(map_remote_try_begin, map_remote_try_end, catch_remote_label, "java/rmi/RemoteException");
        }
        mg.endMethod();
        mg.visitEnd();
    }
}

