/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.context.cleared.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.wsspi.threadcontext.ThreadContext;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.microprofile.context.spi.ThreadContextController;
import org.eclipse.microprofile.context.spi.ThreadContextSnapshot;

@Trivial
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class MicroProfileClearedContextSnapshot
implements ThreadContext {
    private static final long serialVersionUID = 1L;
    private static final TraceComponent tc = Tr.register(MicroProfileClearedContextSnapshot.class, (String)"concurrent", (String)"io.openliberty.microprofile.context.cleared.internal.resources.CWWKCMessages");
    private final ArrayList<ThreadContextController> contextRestorers = new ArrayList();
    private final ArrayList<ThreadContextSnapshot> contextSnapshots;

    public MicroProfileClearedContextSnapshot(ArrayList<ThreadContextSnapshot> contextSnapshots) {
        this.contextSnapshots = contextSnapshots;
    }

    public ThreadContext clone() {
        return new MicroProfileClearedContextSnapshot(this.contextSnapshots);
    }

    public void taskStarting() throws RejectedExecutionException {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        try {
            for (ThreadContextSnapshot snapshot : this.contextSnapshots) {
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("clearing " + snapshot), (Object[])new Object[0]);
                }
                this.contextRestorers.add(snapshot.begin());
            }
        }
        catch (Error | RuntimeException x) {
            this.taskStopping();
            throw x;
        }
    }

    public void taskStopping() {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        Throwable failure = null;
        for (int i = this.contextRestorers.size() - 1; i >= 0; --i) {
            try {
                ThreadContextController contextRestorer = this.contextRestorers.remove(i);
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("restoring " + contextRestorer), (Object[])new Object[0]);
                }
                contextRestorer.endContext();
                continue;
            }
            catch (Error | RuntimeException x) {
                if (failure == null) continue;
                failure = x;
            }
        }
        if (failure instanceof Error) {
            throw (Error)failure;
        }
        if (failure instanceof RuntimeException) {
            throw (RuntimeException)failure;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + '@' + Integer.toHexString(this.hashCode());
    }

    private void writeObject(ObjectOutputStream outStream) throws IOException {
        outStream.putFields();
        outStream.writeFields();
    }
}

