/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.crac;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.checkpoint.spi.CheckpointHook;
import io.openliberty.checkpoint.spi.CheckpointPhase;
import java.lang.ref.WeakReference;
import java.util.Deque;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.crac.CheckpointException;
import org.crac.Context;
import org.crac.Resource;
import org.crac.RestoreException;
import org.osgi.service.component.annotations.Component;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(property={"service.ranking:Integer=2147483647", "io.openliberty.checkpoint.hook.multi.threaded:Boolean=true", "io.openliberty.crac.hooks:Boolean=true"})
public class LibertyCheckpoint
implements CheckpointHook {
    private static final TraceComponent tc = Tr.register(LibertyCheckpoint.class, (String)"checkpoint", (String)"io.openliberty.crac.resources.CRaCMessages");
    private static final Deque<CheckpointHook> hooks = new ConcurrentLinkedDeque<CheckpointHook>();
    static final long serialVersionUID = -7987635861935044699L;

    public void prepare() {
        this.callHooks(hooks.descendingIterator(), CheckpointHook::prepare, () -> new CheckpointException(Tr.formatMessage((TraceComponent)tc, (String)"CRAC_RESOURCE_CHECKPOINT_FAIL_CWWKC0551", (Object[])new Object[0])));
    }

    public void restore() {
        this.callHooks(hooks.iterator(), CheckpointHook::restore, () -> new RestoreException(Tr.formatMessage((TraceComponent)tc, (String)"CRAC_RESOURCE_RESTORE_FAIL_CWWKC0552", (Object[])new Object[0])));
    }

    @FFDCIgnore(value={Exception.class})
    private void callHooks(Iterator<CheckpointHook> toCall, Consumer<CheckpointHook> method, Supplier<Exception> toThrow) {
        Throwable createdToThrow = null;
        while (toCall.hasNext()) {
            try {
                method.accept(toCall.next());
            }
            catch (Exception e) {
                if (createdToThrow == null) {
                    createdToThrow = toThrow.get();
                }
                createdToThrow.addSuppressed(e);
            }
        }
        if (createdToThrow != null) {
            createdToThrow.fillInStackTrace();
            LibertyCheckpoint.sneakyThrow(createdToThrow);
        }
    }

    public static void register(Resource r, final Context<? extends Resource> c) {
        LibertyCheckpoint.debug(tc, () -> "Registering resource " + r + " from context " + c);
        CheckpointPhase phase = CheckpointPhase.getPhase();
        if (phase == CheckpointPhase.INACTIVE) {
            return;
        }
        final WeakReference<Resource> ref = new WeakReference<Resource>(r);
        CheckpointHook hook = new CheckpointHook(){
            static final long serialVersionUID = -7032652326430273036L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @FFDCIgnore(value={Exception.class})
            public void prepare() {
                try {
                    Resource current = (Resource)ref.get();
                    if (current != null) {
                        LibertyCheckpoint.debug(tc, () -> "Calling beforeCheckpoint on " + current);
                        current.beforeCheckpoint(c);
                    }
                }
                catch (Exception e) {
                    LibertyCheckpoint.sneakyThrow(e);
                }
            }

            @FFDCIgnore(value={Exception.class})
            public void restore() {
                try {
                    Resource current = (Resource)ref.get();
                    if (current != null) {
                        LibertyCheckpoint.debug(tc, () -> "Calling afterRestore on " + current);
                        current.afterRestore(c);
                    }
                }
                catch (Exception e) {
                    LibertyCheckpoint.sneakyThrow(e);
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"io.openliberty.crac.LibertyCheckpoint$1", 1.class, (String)"checkpoint", (String)"io.openliberty.crac.resources.CRaCMessages");
            }
        };
        hooks.addLast(hook);
    }

    public static void checkpointRestore() throws RestoreException, CheckpointException {
        LibertyCheckpoint.debug(tc, () -> "Requesting an application initiated checkpoint.");
        String errorMessage = Tr.formatMessage((TraceComponent)tc, (String)"CRAC_RESOURCE_REQUEST_CHECKPOINT_CWWKC0553", (Object[])new Object[0]);
        final Exception fail = CheckpointPhase.INACTIVE == CheckpointPhase.getPhase() ? new UnsupportedOperationException(errorMessage) : new CheckpointException(errorMessage);
        fail.fillInStackTrace();
        CheckpointPhase.getPhase().addMultiThreadedHook(new CheckpointHook(){
            static final long serialVersionUID = -6358737991191117225L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public void prepare() {
                LibertyCheckpoint.sneakyThrow(fail);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"io.openliberty.crac.LibertyCheckpoint$2", 2.class, (String)"checkpoint", (String)"io.openliberty.crac.resources.CRaCMessages");
            }
        });
        LibertyCheckpoint.sneakyThrow(fail);
    }

    @Trivial
    static void debug(TraceComponent trace, Supplier<String> message) {
        if (TraceComponent.isAnyTracingEnabled() && trace.isDebugEnabled()) {
            Tr.debug((TraceComponent)trace, (String)message.get(), (Object[])new Object[0]);
        }
    }

    @Trivial
    static <E extends Throwable> void sneakyThrow(Throwable e) throws E {
        throw e;
    }
}

