/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.osgi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.extension.Extension;
import org.apache.cxf.bus.extension.ExtensionException;
import org.apache.cxf.bus.extension.ExtensionRegistry;
import org.apache.cxf.bus.extension.TextExtensionFragmentParser;
import org.apache.cxf.bus.osgi.CXFActivator;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class CXFExtensionBundleListener
implements SynchronousBundleListener {
    private static final Logger LOG = LogUtils.getL7dLogger(CXFActivator.class);
    private long id;
    private ConcurrentMap<Long, List<OSGiExtension>> extensions;
    static final long serialVersionUID = -8655887942213996533L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public CXFExtensionBundleListener(long bundleId) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.bus.osgi.CXFExtensionBundleListener", "<init>", new Object[]{bundleId});
        }
        this.extensions = new ConcurrentHashMap<Long, List<OSGiExtension>>(16, 0.75f, 4);
        this.id = bundleId;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.bus.osgi.CXFExtensionBundleListener", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void registerExistingBundles(BundleContext context) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.bus.osgi.CXFExtensionBundleListener", "registerExistingBundles", new Object[]{context});
        }
        for (Bundle bundle : context.getBundles()) {
            String bundleName;
            if (bundle.getState() != 4 && bundle.getState() != 8 && bundle.getState() != 32 && bundle.getState() != 16 || bundle.getBundleId() == context.getBundle().getBundleId() || !(bundleName = bundle.toString()).startsWith("com.ibm.ws.org.apache.cxf") && !bundleName.startsWith("com.ibm.ws.wssecurity")) continue;
            this.register(bundle);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.bus.osgi.CXFExtensionBundleListener", "registerExistingBundles");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void bundleChanged(BundleEvent event) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.bus.osgi.CXFExtensionBundleListener", "bundleChanged", new Object[]{event});
        }
        if (event.getType() == 32 && this.id != event.getBundle().getBundleId()) {
            this.register(event.getBundle());
        } else if (event.getType() == 64 || event.getType() == 16) {
            this.unregister(event.getBundle().getBundleId());
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.bus.osgi.CXFExtensionBundleListener", "bundleChanged");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void register(Bundle bundle) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.bus.osgi.CXFExtensionBundleListener", "register", new Object[]{bundle});
        }
        Enumeration e = bundle.findEntries("META-INF/cxf/", "bus-extensions.txt", false);
        while (e != null && e.hasMoreElements()) {
            List<Extension> orig = new TextExtensionFragmentParser(null).getExtensions((URL)e.nextElement());
            this.addExtensions(bundle, orig);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.bus.osgi.CXFExtensionBundleListener", "register");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean addExtensions(Bundle bundle, List<Extension> orig) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.bus.osgi.CXFExtensionBundleListener", "addExtensions", new Object[]{bundle, orig});
        }
        if (orig.isEmpty()) {
            boolean bl = false;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.bus.osgi.CXFExtensionBundleListener", "addExtensions", bl);
            }
            return bl;
        }
        ArrayList<String> names = new ArrayList<String>(orig.size());
        for (Extension ext : orig) {
            names.add(ext.getName());
        }
        LOG.finest("Adding the extensions from bundle " + bundle.getSymbolicName() + " (" + bundle.getBundleId() + ") " + names);
        List<OSGiExtension> list = (CopyOnWriteArrayList<OSGiExtension>)this.extensions.get(bundle.getBundleId());
        if (list == null) {
            list = new CopyOnWriteArrayList<OSGiExtension>();
            List preList = this.extensions.putIfAbsent(bundle.getBundleId(), list);
            if (preList != null) {
                list = preList;
            }
        }
        for (Extension ext : orig) {
            list.add(new OSGiExtension(ext, bundle));
        }
        ExtensionRegistry.addExtensions(list);
        boolean bl = !list.isEmpty();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.bus.osgi.CXFExtensionBundleListener", "addExtensions", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void unregister(long bundleId) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.bus.osgi.CXFExtensionBundleListener", "unregister", new Object[]{bundleId});
        }
        List list = (List)this.extensions.remove(bundleId);
        if (list != null) {
            LOG.finest("Removing the extensions for bundle " + bundleId);
            ExtensionRegistry.removeExtensions(list);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.bus.osgi.CXFExtensionBundleListener", "unregister");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void shutdown() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.bus.osgi.CXFExtensionBundleListener", "shutdown", new Object[0]);
        }
        while (!this.extensions.isEmpty()) {
            this.unregister((Long)this.extensions.keySet().iterator().next());
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.bus.osgi.CXFExtensionBundleListener", "shutdown");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    public class OSGiExtension
    extends Extension {
        final Bundle bundle;
        Object serviceObject;
        static final long serialVersionUID = 6731347756394215124L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public OSGiExtension(Extension e, Bundle b) {
            super(e);
            this.bundle = b;
        }

        public void setServiceObject(Object o) {
            this.serviceObject = o;
            this.obj = o;
        }

        @Override
        @FFDCIgnore(value={Throwable.class})
        public Object load(ClassLoader cl, Bus b) {
            ServiceReference ref;
            if (System.getSecurityManager() != null) {
                try {
                    ServiceReference ref2;
                    BundleContext bc = AccessController.doPrivileged(new PrivilegedExceptionAction<BundleContext>(){
                        static final long serialVersionUID = -3867119753208881917L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public BundleContext run() throws Exception {
                            return OSGiExtension.this.bundle.getBundleContext();
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register((String)"org.apache.cxf.bus.osgi.CXFExtensionBundleListener$OSGiExtension$1", 1.class, null, null);
                        }
                    });
                    if (this.interfaceName == null && bc != null && (ref2 = bc.getServiceReference(this.className)) != null && ref2.getBundle().getBundleId() == this.bundle.getBundleId()) {
                        Object o;
                        this.serviceObject = o = bc.getService(ref2);
                        this.obj = o;
                        return this.obj;
                    }
                }
                catch (Throwable ex) {
                    LOG.finest("Failed to get BundleContext due to error: " + ex);
                }
            } else if (this.interfaceName == null && this.bundle.getBundleContext() != null && (ref = this.bundle.getBundleContext().getServiceReference(this.className)) != null && ref.getBundle().getBundleId() == this.bundle.getBundleId()) {
                Object o;
                this.serviceObject = o = this.bundle.getBundleContext().getService(ref);
                this.obj = o;
                return this.obj;
            }
            return super.load(cl, b);
        }

        @Override
        protected Class<?> tryClass(String name, ClassLoader cl) {
            Class c = null;
            Throwable origExc = null;
            try {
                try {
                    c = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){
                        static final long serialVersionUID = -8244844942108551874L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public Class<?> run() throws ClassNotFoundException {
                            return OSGiExtension.this.bundle.loadClass(OSGiExtension.this.className);
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register((String)"org.apache.cxf.bus.osgi.CXFExtensionBundleListener$OSGiExtension$2", 2.class, null, null);
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    if (e.getException() != null) {
                        throw e.getException();
                    }
                    throw e;
                }
            }
            catch (Throwable e) {
                origExc = e;
            }
            if (c == null) {
                try {
                    return super.tryClass(name, cl);
                }
                catch (ExtensionException ee) {
                    if (origExc != null) {
                        throw new ExtensionException(new Message("PROBLEM_LOADING_EXTENSION_CLASS", Extension.LOG, name), origExc);
                    }
                    throw ee;
                }
            }
            return c;
        }

        @Override
        public Extension cloneNoObject() {
            OSGiExtension ext = new OSGiExtension(this, this.bundle);
            ext.obj = this.serviceObject;
            return ext;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.bus.osgi.CXFExtensionBundleListener$OSGiExtension", OSGiExtension.class, null, null);
        }
    }
}

