/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.netty.internal.udp;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.util.concurrent.GenericFutureListener;
import io.openliberty.netty.internal.BootstrapConfiguration;
import io.openliberty.netty.internal.BootstrapExtended;
import io.openliberty.netty.internal.ConfigConstants;
import io.openliberty.netty.internal.exception.NettyException;
import io.openliberty.netty.internal.impl.NettyFrameworkImpl;
import io.openliberty.netty.internal.udp.UDPConfigurationImpl;
import java.net.Inet6Address;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class UDPUtils {
    private static final TraceComponent tc = Tr.register(UDPUtils.class, (String)"Netty", (String)"com.ibm.ws.udpchannel.internal.resources.UDPMessages");
    static final long serialVersionUID = -5226363321287059766L;

    public static BootstrapExtended createUDPBootstrap(NettyFrameworkImpl framework, Map<String, Object> options) throws NettyException {
        return UDPUtils.create(framework, new UDPConfigurationImpl(options, true));
    }

    public static BootstrapExtended createUDPBootstrapOutbound(NettyFrameworkImpl framework, Map<String, Object> options) throws NettyException {
        return UDPUtils.create(framework, new UDPConfigurationImpl(options, false));
    }

    private static BootstrapExtended create(NettyFrameworkImpl framework, UDPConfigurationImpl config) {
        BootstrapExtended bs = new BootstrapExtended();
        bs.applyConfiguration((BootstrapConfiguration)config);
        bs.group(framework.getChildGroup());
        bs.channel(NioDatagramChannel.class);
        return bs;
    }

    private static ChannelFuture bind(NettyFrameworkImpl framework, BootstrapExtended bootstrap, String inetHost, int inetPort, int retryCount, int retryDelay, ChannelFutureListener bindListener) {
        ChannelFuture bindFuture = bootstrap.bind(inetHost, inetPort);
        if (inetHost.equals("*")) {
            inetHost = "0.0.0.0";
        }
        String newHost = inetHost;
        if (bindListener != null) {
            bindFuture.addListener((GenericFutureListener)bindListener);
        }
        UDPConfigurationImpl config = (UDPConfigurationImpl)bootstrap.getConfiguration();
        String channelName = ((UDPConfigurationImpl)bootstrap.getConfiguration()).getExternalName();
        bindFuture.addListener(future -> {
            if (future.isSuccess()) {
                Channel channel = bindFuture.channel();
                channel.attr(ConfigConstants.NAME_KEY).set((Object)config.getExternalName());
                channel.attr(ConfigConstants.HOST_KEY).set((Object)newHost);
                channel.attr(ConfigConstants.PORT_KEY).set((Object)inetPort);
                channel.attr(ConfigConstants.IS_INBOUND_KEY).set((Object)config.isInboundChannel());
                framework.getOutboundConnections().add((Object)channel);
                channel.closeFuture().addListener(innerFuture -> UDPUtils.logChannelStopped(channel));
                String hostLogString = newHost;
                SocketAddress addr = channel.localAddress();
                InetSocketAddress inetAddr = (InetSocketAddress)addr;
                String IPvType = "IPv4";
                if (inetAddr.getAddress() instanceof Inet6Address) {
                    IPvType = "IPv6";
                }
                hostLogString = newHost == "0.0.0.0" ? "*  (" + IPvType + ")" : config.getHostname() + "  (" + IPvType + ": " + inetAddr.getAddress().getHostAddress() + ")";
                if (config.isInboundChannel()) {
                    Tr.info((TraceComponent)tc, (String)"CWUDP0001I", (Object[])new Object[]{config.getExternalName(), hostLogString, String.valueOf(inetPort)});
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"CWUDP0001I", (Object[])new Object[]{config.getExternalName(), hostLogString, String.valueOf(inetPort)});
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("bindHelper failed due to: " + future.cause().getMessage()), (Object[])new Object[0]);
                }
                if (retryCount > 0) {
                    block15: {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("attempt to bind again after a wait of " + retryDelay + "ms; " + retryCount + " attempts remaining"), (Object[])new Object[0]);
                        }
                        try {
                            Thread.sleep(retryDelay);
                        }
                        catch (InterruptedException x) {
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block15;
                            Tr.debug((TraceComponent)tc, (String)"sleep caught InterruptedException.  will proceed.", (Object[])new Object[0]);
                        }
                    }
                    UDPUtils.bind(framework, bootstrap, newHost, inetPort, retryCount - 1, retryDelay, bindListener);
                } else if (config.isInboundChannel()) {
                    Tr.error((TraceComponent)tc, (String)"CWUDP0005E", (Object[])new Object[]{channelName, newHost, String.valueOf(inetPort)});
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"CWUDP0005E", (Object[])new Object[]{channelName, newHost, String.valueOf(inetPort)});
                }
            }
        });
        return bindFuture;
    }

    public static FutureTask<ChannelFuture> startOutbound(NettyFrameworkImpl framework, BootstrapExtended bootstrap, String inetHost, int inetPort, ChannelFutureListener bindListener) throws NettyException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("startOutbound (UDP): attempt to bind a channel at host " + inetHost + " port " + inetPort), (Object[])new Object[0]);
        }
        return UDPUtils.startHelper(framework, bootstrap, inetHost, inetPort, bindListener);
    }

    public static FutureTask<ChannelFuture> start(NettyFrameworkImpl framework, BootstrapExtended bootstrap, String inetHost, int inetPort, ChannelFutureListener bindListener) throws NettyException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("start (UDP): attempt to bind a channel at host " + inetHost + " port " + inetPort), (Object[])new Object[0]);
        }
        return UDPUtils.startHelper(framework, bootstrap, inetHost, inetPort, bindListener);
    }

    /*
     * WARNING - void declaration
     */
    private static FutureTask<ChannelFuture> startHelper(final NettyFrameworkImpl framework, final BootstrapExtended bootstrap, final String inetHost, final int inetPort, final ChannelFutureListener bindListener) throws NettyException {
        if (framework.isStopping()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"server is stopping, channel will not be started", (Object[])new Object[0]);
            }
            return null;
        }
        try {
            return framework.runWhenServerStarted(new Callable<ChannelFuture>(){
                static final long serialVersionUID = -1716490551979373373L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public ChannelFuture call() throws NettyException {
                    UDPConfigurationImpl config = (UDPConfigurationImpl)bootstrap.getConfiguration();
                    int bindRetryCount = config.getRetryCount();
                    int bindRetryInterval = config.getRetryInterval();
                    InetSocketAddress address = null;
                    String newHost = inetHost;
                    if (newHost.equals("*")) {
                        newHost = "0.0.0.0";
                    }
                    String hostLogString = newHost == "0.0.0.0" ? "*" : newHost;
                    address = new InetSocketAddress(newHost, inetPort);
                    if (address.isUnresolved()) {
                        String channelName = ((UDPConfigurationImpl)bootstrap.getConfiguration()).getExternalName();
                        Tr.error((TraceComponent)tc, (String)"CWUDP0006I", (Object[])new Object[]{channelName, hostLogString, String.valueOf(inetPort)});
                        throw new NettyException("local address unresolved for " + channelName + " - " + hostLogString + ":" + inetPort);
                    }
                    return UDPUtils.bind(framework, bootstrap, newHost, inetPort, bindRetryCount, bindRetryInterval, bindListener);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"io.openliberty.netty.internal.udp.UDPUtils$1", 1.class, null, null);
                }
            });
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.netty.internal.udp.UDPUtils", (String)"239", null, (Object[])new Object[]{framework, bootstrap, inetHost, inetPort, bindListener});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)("NettyFramework signaled- caught exception:: " + e.getMessage()), (Object[])new Object[0]);
            }
            return null;
        }
    }

    public static void logChannelStopped(Channel channel) {
        String channelName = (String)channel.attr(ConfigConstants.NAME_KEY).get();
        String host = (String)channel.attr(ConfigConstants.HOST_KEY).get();
        Integer port = (Integer)channel.attr(ConfigConstants.PORT_KEY).get();
        if (((Boolean)channel.attr(ConfigConstants.IS_INBOUND_KEY).get()).booleanValue()) {
            Tr.info((TraceComponent)tc, (String)"CWUDP0002I", (Object[])new Object[]{channelName, host, String.valueOf(port)});
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"CWUDP0002I", (Object[])new Object[]{channelName, host, String.valueOf(port)});
        }
    }
}

