/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Produces;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.resteasy.core.LocatorRegistry;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.specimpl.BuiltResponse;
import org.jboss.resteasy.specimpl.ResteasyUriInfo;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.InjectorFactory;
import org.jboss.resteasy.spi.InternalServerErrorException;
import org.jboss.resteasy.spi.MethodInjector;
import org.jboss.resteasy.spi.ResourceFactory;
import org.jboss.resteasy.spi.ResourceInvoker;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.metadata.ResourceLocator;
import org.jboss.resteasy.spi.statistics.MethodStatisticsLogger;
import org.jboss.resteasy.statistics.StatisticsControllerImpl;
import org.jboss.resteasy.util.GetRestful;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class ResourceLocatorInvoker
implements ResourceInvoker {
    protected InjectorFactory injector;
    protected MethodInjector methodInjector;
    protected ResourceFactory resource;
    protected ResteasyProviderFactory providerFactory;
    protected ResourceLocator method;
    protected ConcurrentHashMap<Class<?>, LocatorRegistry> cachedSubresources = new ConcurrentHashMap();
    protected final boolean hasProduces;
    protected MethodStatisticsLogger methodStatisticsLogger;
    static final long serialVersionUID = 5346325735248635114L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ResourceLocatorInvoker(ResourceFactory resource, InjectorFactory injector, ResteasyProviderFactory providerFactory, ResourceLocator locator) {
        this.resource = resource;
        this.injector = injector;
        this.providerFactory = providerFactory;
        this.method = locator;
        this.methodInjector = injector.createMethodInjector(locator, providerFactory);
        this.hasProduces = this.method.getMethod().isAnnotationPresent(Produces.class) || this.method.getMethod().getClass().isAnnotationPresent(Produces.class);
        this.methodStatisticsLogger = StatisticsControllerImpl.EMPTY;
    }

    @Override
    public boolean hasProduces() {
        return this.hasProduces;
    }

    protected Object resolveTarget(HttpRequest request, HttpResponse response) {
        Object locatorResource = this.resource.createResource(request, response, this.providerFactory);
        if (locatorResource instanceof CompletionStage) {
            CompletionStage locatorStage = (CompletionStage)locatorResource;
            return locatorStage.thenCompose(resource -> {
                Object located = this.resolveTargetFromLocator(request, response, resource);
                if (located instanceof CompletionStage) {
                    return (CompletionStage)located;
                }
                return CompletableFuture.completedFuture(located);
            });
        }
        return this.resolveTargetFromLocator(request, response, locatorResource);
    }

    protected Object resolveTargetFromLocator(HttpRequest request, HttpResponse response, Object locator) {
        ResteasyUriInfo uriInfo = (ResteasyUriInfo)request.getUri();
        RuntimeException lastException = (RuntimeException)request.getAttribute("registry.matching.exception");
        Object obj = this.methodInjector.injectArguments(request, response);
        if (obj == null || !(obj instanceof CompletionStage)) {
            return this.constructLocator(locator, uriInfo, (Object[])obj);
        }
        CompletionStage stagedArgs = (CompletionStage)obj;
        return stagedArgs.exceptionally(t -> {
            if (t.getCause() instanceof NotFoundException && lastException != null) {
                throw lastException;
            }
            SynchronousDispatcher.rethrow(t);
            return null;
        }).thenApply(args -> this.constructLocator(locator, uriInfo, (Object[])args));
    }

    private Object constructLocator(Object locator, ResteasyUriInfo uriInfo, Object[] args) {
        try {
            uriInfo.pushCurrentResource(locator);
            Object subResource = this.method.getMethod().invoke(locator, args);
            if (subResource instanceof Class) {
                subResource = this.providerFactory.injectedInstance((Class)subResource);
            }
            return subResource;
        }
        catch (IllegalAccessException e) {
            throw new InternalServerErrorException(e);
        }
        catch (InvocationTargetException e) {
            throw new ApplicationException(e.getCause());
        }
        catch (SecurityException e) {
            throw new ApplicationException(e.getCause());
        }
    }

    @Override
    public Method getMethod() {
        return this.method.getMethod();
    }

    @Override
    public BuiltResponse invoke(HttpRequest request, HttpResponse response) {
        Object resource = this.resolveTarget(request, response);
        if (resource instanceof CompletionStage) {
            return ((CompletionStage)resource).thenApply(target -> this.invokeOnTargetObject(request, response, target)).toCompletableFuture().getNow(null);
        }
        return this.invokeOnTargetObject(request, response, resource);
    }

    @Override
    public BuiltResponse invoke(HttpRequest request, HttpResponse response, Object locator) {
        Object resource = this.resolveTargetFromLocator(request, response, locator);
        if (resource instanceof CompletionStage) {
            return ((CompletionStage)resource).thenApply(target -> this.invokeOnTargetObject(request, response, target)).toCompletableFuture().getNow(null);
        }
        return this.invokeOnTargetObject(request, response, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BuiltResponse invokeOnTargetObject(HttpRequest request, HttpResponse response, Object target) {
        ResourceInvoker invoker;
        if (target == null) {
            NotFoundException notFound = new NotFoundException(Messages.MESSAGES.nullSubresource(request.getUri().getAbsolutePath()));
            throw notFound;
        }
        Class<?> clazz = target.getClass();
        LocatorRegistry registry = this.cachedSubresources.get(clazz);
        if (registry == null) {
            if (!GetRestful.isSubResourceClass(clazz)) {
                String msg = Messages.MESSAGES.subresourceHasNoJaxRsAnnotations(clazz.getName());
                throw new InternalServerErrorException(msg);
            }
            registry = new LocatorRegistry(clazz, this.providerFactory);
            this.cachedSubresources.putIfAbsent(clazz, registry);
        }
        if ((invoker = registry.getResourceInvoker(request)) instanceof ResourceLocatorInvoker) {
            ResourceLocatorInvoker locator = (ResourceLocatorInvoker)invoker;
            long timeStamp = this.methodStatisticsLogger.timestamp();
            try {
                BuiltResponse builtResponse = locator.invoke(request, response, target);
                return builtResponse;
            }
            finally {
                this.methodStatisticsLogger.duration(timeStamp);
            }
        }
        if (invoker instanceof ResourceMethodInvoker) {
            ResourceMethodInvoker method = (ResourceMethodInvoker)invoker;
            return method.invoke(request, response, target);
        }
        return (BuiltResponse)invoker.invoke(request, response, target);
    }

    @Override
    public void setMethodStatisticsLogger(MethodStatisticsLogger msLogger) {
        this.methodStatisticsLogger = msLogger;
    }

    @Override
    public MethodStatisticsLogger getMethodStatisticsLogger() {
        return this.methodStatisticsLogger;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.core.ResourceLocatorInvoker", ResourceLocatorInvoker.class, null, null);
    }
}

