/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.server.plugins;

import com.google.gson.JsonArray;
import com.ibm.oauth.core.api.attributes.AttributeList;
import com.ibm.oauth.core.api.error.OAuthException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20InternalException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20MissingParameterException;
import com.ibm.oauth.core.api.oauth20.token.OAuth20Token;
import com.ibm.oauth.core.internal.oauth20.responsetype.OAuth20ResponseTypeHandler;
import com.ibm.oauth.core.internal.oauth20.responsetype.impl.OAuth20ResponseTypeHandlerTokenImpl;
import com.ibm.oauth.core.internal.oauth20.token.OAuth20TokenFactory;
import com.ibm.oauth.core.internal.oauth20.token.OAuth20TokenHelper;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.utility.SubjectHelper;
import com.ibm.ws.security.openidconnect.common.cl.BuildResponseTypeUtil;
import com.ibm.ws.security.openidconnect.server.plugins.IDTokenFactory;
import com.ibm.ws.security.openidconnect.server.plugins.OIDCInvalidResponseTypeException;
import com.ibm.ws.security.openidconnect.server.plugins.OIDCMissingScopeException;
import com.ibm.ws.security.openidconnect.server.plugins.OIDCUnsupportedResponseTypeException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OIDCResponseTypeHandlerImplicitImpl
implements OAuth20ResponseTypeHandler {
    private static final TraceComponent tc = Tr.register(OIDCResponseTypeHandlerImplicitImpl.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.server.internal.resources.OidcServerMessages");
    OAuth20ResponseTypeHandlerTokenImpl oa20rthti = new OAuth20ResponseTypeHandlerTokenImpl();
    static final long serialVersionUID = 913110397087418284L;

    public void validateRequestResponseType(AttributeList attributeList, JsonArray redirectUris, boolean allowRegexpRedirects) throws OAuthException {
        String responseType = attributeList.getAttributeValueByNameAndType("response_type", "urn:ibm:names:query:param");
        String[] responseTypes = responseType.split(" ");
        boolean bResponseTypeToken = false;
        boolean bResponseTypeIdToken = false;
        for (String rType : responseTypes) {
            if (rType.equals("token")) {
                this.oa20rthti.validateRequestResponseType(attributeList, redirectUris, allowRegexpRedirects);
                bResponseTypeToken = true;
                continue;
            }
            if (rType.equals("id_token")) {
                String issuerIdentifier = attributeList.getAttributeValueByName("issuerIdentifier");
                if (issuerIdentifier == null || issuerIdentifier.length() == 0) {
                    throw new OAuth20InternalException("security.oauth20.error.authorization.internal.missing.issuer", new Throwable("Missing issuerIdentifier"), new String[0]);
                }
                String[] scopes = attributeList.getAttributeValuesByName("scope");
                boolean bOpenIdScope = false;
                for (String scope : scopes) {
                    if (!"openid".equals(scope)) continue;
                    bOpenIdScope = true;
                }
                if (!bOpenIdScope) {
                    Tr.error((TraceComponent)tc, (String)"OIDC_SERVER_MISSING_OPENID_SCOPE_ERR", (Object[])new Object[0]);
                    throw new OIDCMissingScopeException("invalid_scope", "'openid' should be specified as scope if the response_type is id_token", null);
                }
                String nonce = attributeList.getAttributeValueByNameAndType("nonce", "urn:ibm:names:oauth:request");
                if (nonce == null || nonce.length() == 0) {
                    Tr.error((TraceComponent)tc, (String)"OIDC_SERVER_MISSING_NONCE_ATTR_ERR", (Object[])new Object[0]);
                    throw new OAuth20MissingParameterException("security.oauth20.error.missing.parameter", "nonce", null);
                }
                bResponseTypeIdToken = true;
                continue;
            }
            Tr.error((TraceComponent)tc, (String)"OIDC_SERVER_INVALID_RESPONSE_TYPE_ERR", (Object[])new Object[]{rType, "{'code', 'token', 'id_token token'}"});
            throw new OIDCInvalidResponseTypeException("unsupported_response_type", "response_type '" + responseType + "' is not supported", null);
        }
        if (bResponseTypeIdToken && !bResponseTypeToken) {
            throw new OIDCUnsupportedResponseTypeException("unsupported_response_type", "response_type id_token without response_type token is not supported for now", null);
        }
    }

    public List<OAuth20Token> buildTokensResponseType(AttributeList attributeList, OAuth20TokenFactory tokenFactory, String redirectUri) {
        String responseType = attributeList.getAttributeValueByNameAndType("response_type", "urn:ibm:names:query:param");
        ArrayList<OAuth20Token> tokenList = null;
        tokenList = this.oa20rthti.buildTokensResponseType(attributeList, tokenFactory, redirectUri);
        if (responseType.contains("id_token")) {
            if (tokenList == null) {
                tokenList = new ArrayList<OAuth20Token>();
            }
            String clientId = attributeList.getAttributeValueByNameAndType("client_id", "urn:ibm:names:query:param");
            String username = attributeList.getAttributeValueByNameAndType("username", "urn:ibm:names:oauth:request");
            String redirect = attributeList.getAttributeValueByNameAndType("redirect_uri", "urn:ibm:names:query:param");
            String[] scopes = attributeList.getAttributeValuesByName("scope");
            if (redirect == null) {
                redirect = redirectUri;
            }
            OAuth20Token accessToken = null;
            for (OAuth20Token token : tokenList) {
                String strTokenType = token.getType();
                if (!"access_token".equals(strTokenType)) continue;
                accessToken = token;
                break;
            }
            if (accessToken != null) {
                String stateId = accessToken.getStateId();
                for (String scope : scopes) {
                    OAuth20Token id;
                    SubjectHelper subjectHelper;
                    String thirdPartyIDToken;
                    if (!"openid".equals(scope)) continue;
                    IDTokenFactory oidc10TokenFactory = new IDTokenFactory(tokenFactory.getOAuth20ComponentInternal());
                    Map idTokenMap = oidc10TokenFactory.buildTokenMap(clientId, username, redirect, stateId, scopes, null, "implicit");
                    OAuth20TokenHelper.addExternalClaims((Map)idTokenMap, (OAuth20Token)accessToken);
                    String accessTokenString = accessToken.getTokenString();
                    idTokenMap.put("access_token", new String[]{accessTokenString});
                    String issuerIdentifier = attributeList.getAttributeValueByName("issuerIdentifier");
                    idTokenMap.put("issuerIdentifier", new String[]{issuerIdentifier});
                    String nonce = attributeList.getAttributeValueByNameAndType("nonce", "urn:ibm:names:oauth:request");
                    if (nonce != null && nonce.length() > 0) {
                        idTokenMap.put("nonce", new String[]{nonce});
                    }
                    if ((thirdPartyIDToken = (subjectHelper = new SubjectHelper()).getIDTokenFromRunAsSubject()) != null) {
                        idTokenMap.put("third_party_idtoken", new String[]{thirdPartyIDToken});
                    }
                    if ((id = oidc10TokenFactory.createIDToken(idTokenMap)) == null) break;
                    tokenList.add(id);
                    break;
                }
            }
        }
        return tokenList;
    }

    public void buildResponseResponseType(AttributeList attributeList, List<OAuth20Token> tokens) {
        this.oa20rthti.buildResponseResponseType(attributeList, tokens);
        for (OAuth20Token token : tokens) {
            String strTokenType = token.getType();
            if (!"id_token".equals(strTokenType)) continue;
            BuildResponseTypeUtil.handleIDToken((AttributeList)attributeList, (OAuth20Token)token);
        }
    }
}

