/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.web;

import com.ibm.oauth.core.internal.OAuthUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.common.encoder.Base64Coder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.MessageDigest;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OidcSessionManagementUtil {
    private static final TraceComponent tc = Tr.register(OidcSessionManagementUtil.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.server.internal.resources.OidcServerMessages");
    public static final String ENCODING = "UTF-8";
    public static final int RANDOM_STATE_LENGTH = 40;
    static final long serialVersionUID = -5500366137482969507L;

    /*
     * WARNING - void declaration
     */
    public static String calculateSessionState(String clientId, String state, String salt) {
        String newState;
        block6: {
            StringBuilder stateBuilder = new StringBuilder();
            stateBuilder = stateBuilder.append(clientId).append(state);
            if (salt != null && !salt.isEmpty()) {
                stateBuilder.append(salt);
            }
            String stringToHash = stateBuilder.toString();
            newState = null;
            try {
                String hashAlg = "SHA-256";
                MessageDigest messageDigest = MessageDigest.getInstance(hashAlg);
                byte[] digest = messageDigest.digest(stringToHash.getBytes(ENCODING));
                if (digest != null) {
                    byte[] encodedDigest = Base64Coder.base64Encode((byte[])digest);
                    newState = new String(encodedDigest, ENCODING);
                }
            }
            catch (Exception hashAlg) {
                void e;
                FFDCFilter.processException((Throwable)hashAlg, (String)"com.ibm.ws.security.openidconnect.web.OidcSessionManagementUtil", (String)"65", null, (Object[])new Object[]{clientId, state, salt});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block6;
                Tr.debug((TraceComponent)tc, (String)("Exception caught while attempting to create new browser state: " + e), (Object[])new Object[0]);
            }
        }
        if (newState == null) {
            newState = OAuthUtil.getRandom((int)40);
        }
        if (salt != null && !salt.isEmpty()) {
            newState = newState + "." + salt;
        }
        return newState;
    }
}

