/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.csiv2.config.css;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.csiv2.Authenticator;
import com.ibm.ws.security.csiv2.CommonCfg;
import com.ibm.ws.security.csiv2.config.ssl.SSLConfig;
import com.ibm.ws.security.csiv2.util.SecurityServices;
import com.ibm.ws.transport.iiop.security.config.css.CSSASMechConfig;
import com.ibm.ws.transport.iiop.security.config.css.CSSCompoundSecMechConfig;
import com.ibm.ws.transport.iiop.security.config.css.CSSCompoundSecMechListConfig;
import com.ibm.ws.transport.iiop.security.config.css.CSSConfig;
import com.ibm.ws.transport.iiop.security.config.css.CSSNULLASMechConfig;
import com.ibm.ws.transport.iiop.security.config.css.CSSNULLTransportConfig;
import com.ibm.ws.transport.iiop.security.config.css.CSSSASITTAbsent;
import com.ibm.ws.transport.iiop.security.config.css.CSSSASMechConfig;
import com.ibm.ws.transport.iiop.security.config.css.CSSSSLTransportConfig;
import com.ibm.ws.transport.iiop.security.config.css.CSSTransportMechConfig;
import com.ibm.ws.transport.iiop.security.config.tss.OptionsKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class CommonClientCfg
extends CommonCfg {
    private static TraceComponent tc = Tr.register(CommonClientCfg.class, (String)"CSIv2", (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages");
    public static final String KEY_POLICY = "clientPolicy";
    public static final String KEY_TRUSTED_IDENTITY = "trustedIdentity";
    public static final String KEY_TRUSTED_PASSWORD = "trustedPassword";
    public static final String KEY_AUTHENTICATION_USER = "user";
    public static final String KEY_AUTHENTICATION_PASSWORD = "password";
    public static final String KEY_AUTHENTICATION_REALM = "realm";
    protected final String domain;
    private final String TYPE;
    private final Authenticator authenticator;
    protected final SSLConfig sslConfig;
    static final long serialVersionUID = -2669553151153618648L;

    public CommonClientCfg(Authenticator authenticator, String domain, String defaultAlias, String type) {
        super(defaultAlias);
        this.TYPE = type;
        this.authenticator = authenticator;
        this.domain = domain;
        this.sslConfig = SecurityServices.getSSLConfig();
    }

    public CSSConfig getCSSConfig(Map<String, Object> properties) throws Exception {
        CSSConfig cssConfig = new CSSConfig();
        CommonClientCfg.printTrace("IIOP Client Policy", null, 0);
        CommonCfg.PolicyData policyData = this.extractPolicyData(properties, KEY_POLICY, this.TYPE);
        if (policyData != null) {
            CommonClientCfg.printTrace("CSIV2", null, 1);
            CSSCompoundSecMechListConfig mechListConfig = cssConfig.getMechList();
            mechListConfig.setStateful(policyData.stateful);
            CommonClientCfg.printTrace("Stateful", mechListConfig.isStateful(), 2);
            this.populateSecMechList(mechListConfig, policyData.layersData);
        }
        return cssConfig;
    }

    private void populateSecMechList(CSSCompoundSecMechListConfig mechListConfig, List<CommonCfg.LayersData> layersList) throws Exception {
        for (CommonCfg.LayersData mech : layersList) {
            for (CSSCompoundSecMechConfig cssCompoundSecMechConfig : this.extractCompoundSecMech(mech)) {
                mechListConfig.add(cssCompoundSecMechConfig);
            }
        }
    }

    protected List<CSSCompoundSecMechConfig> extractCompoundSecMech(CommonCfg.LayersData mechInfo) throws Exception {
        CommonClientCfg.printTrace("Layers", null, 1);
        ArrayList<CSSCompoundSecMechConfig> compoundSecMechConfigs = new ArrayList<CSSCompoundSecMechConfig>();
        this.setAuthenticationLayerConfig(compoundSecMechConfigs, mechInfo);
        this.setTransportLayerConfig(compoundSecMechConfigs, mechInfo);
        this.setAttributeLayerConfig(compoundSecMechConfigs, mechInfo);
        return compoundSecMechConfigs;
    }

    protected void setTransportLayerConfig(List<CSSCompoundSecMechConfig> compoundSecMechs, CommonCfg.LayersData mechInfo) throws SSLException {
        CSSTransportMechConfig cssTransportMechConfig;
        Map<String, Object> transportLayerProperties = mechInfo.transportLayer;
        if (transportLayerProperties != null) {
            CommonClientCfg.printTrace("Transport Layer", null, 2);
            boolean sslEnabled = (Boolean)transportLayerProperties.get("sslEnabled");
            cssTransportMechConfig = sslEnabled ? this.extractSSLTransport(transportLayerProperties) : new CSSNULLTransportConfig();
        } else {
            cssTransportMechConfig = new CSSNULLTransportConfig();
        }
        for (CSSCompoundSecMechConfig cssCompoundSecMechConfig : compoundSecMechs) {
            cssCompoundSecMechConfig.setTransport_mech(cssTransportMechConfig);
        }
    }

    protected CSSTransportMechConfig extractSSLTransport(Map<String, Object> transportLayerProperties) throws SSLException {
        String sslRef = (String)transportLayerProperties.get("sslRef");
        if (sslRef == null) {
            sslRef = this.sslConfig.getSSLAlias();
        }
        OptionsKey options = this.sslConfig.getAssociationOptions(sslRef);
        CSSSSLTransportConfig transportLayerConfig = new CSSSSLTransportConfig();
        transportLayerConfig.setSupports(options.supports);
        transportLayerConfig.setRequires(options.requires);
        transportLayerConfig.setSslConfigName(sslRef);
        return transportLayerConfig;
    }

    private void setAuthenticationLayerConfig(List<CSSCompoundSecMechConfig> compoundSecMechs, CommonCfg.LayersData mechInfo) {
        Map<String, Object> authenticationLayerProperties = mechInfo.authenticationLayer;
        if (authenticationLayerProperties != null) {
            CommonClientCfg.printTrace("Authentication Layer", null, 2);
            for (CSSASMechConfig cssasMechConfig : this.extractASMech(authenticationLayerProperties)) {
                CSSCompoundSecMechConfig compoundSecMechConfig = new CSSCompoundSecMechConfig();
                compoundSecMechConfig.setAs_mech(cssasMechConfig);
                compoundSecMechs.add(compoundSecMechConfig);
            }
        } else {
            CSSCompoundSecMechConfig compoundSecMechConfig = new CSSCompoundSecMechConfig();
            compoundSecMechConfig.setAs_mech(new CSSNULLASMechConfig());
            compoundSecMechs.add(compoundSecMechConfig);
        }
    }

    private List<CSSASMechConfig> extractASMech(Map<String, Object> authenticationLayerProperties) {
        ArrayList<CSSASMechConfig> cssasMechConfigs = new ArrayList<CSSASMechConfig>();
        ArrayList<String> configuredMechanisms = new ArrayList<String>();
        String establishTrustInClient = (String)authenticationLayerProperties.get("establishTrustInClient");
        CommonClientCfg.printTrace("EstablishTrustInClient", establishTrustInClient, 3);
        boolean required = false;
        if ("Required".equals(establishTrustInClient)) {
            required = true;
        } else if ("Never".equals(establishTrustInClient)) {
            this.logWarning("CSIv2_COMMON_AUTH_LAYER_DISABLED", establishTrustInClient);
            cssasMechConfigs.add(new CSSNULLASMechConfig());
            return cssasMechConfigs;
        }
        List<String> mechanisms = this.getAsMechanisms(authenticationLayerProperties);
        if (mechanisms.isEmpty()) {
            this.logWarning("CSIv2_CLIENT_AUTH_MECHANISMS_NULL", new Object[0]);
            cssasMechConfigs.add(new CSSNULLASMechConfig());
        } else {
            for (String mech : mechanisms) {
                if (configuredMechanisms.contains(mech.toUpperCase())) continue;
                CSSASMechConfig camConfig = this.handleASMech(mech, this.authenticator, this.domain, required, authenticationLayerProperties);
                if (camConfig != null) {
                    cssasMechConfigs.add(camConfig);
                } else {
                    this.logWarning("CSIv2_CLIENT_AUTH_MECHANISM_INVALID", new Object[0]);
                }
                configuredMechanisms.add(mech.toUpperCase());
            }
            if (cssasMechConfigs.isEmpty()) {
                cssasMechConfigs.add(new CSSNULLASMechConfig());
            }
        }
        return cssasMechConfigs;
    }

    private void setAttributeLayerConfig(List<CSSCompoundSecMechConfig> compoundSecMechs, CommonCfg.LayersData mechInfo) {
        CSSSASMechConfig sasMechConfig = null;
        Map<String, Object> attributeLayerProperties = null;
        attributeLayerProperties = this.getAttributeLayerProperties(mechInfo);
        if (attributeLayerProperties != null) {
            CommonClientCfg.printTrace("Attribute Layer", null, 2);
            sasMechConfig = this.extractSASMech(attributeLayerProperties);
        } else {
            sasMechConfig = new CSSSASMechConfig();
            sasMechConfig.addIdentityToken(new CSSSASITTAbsent());
        }
        for (CSSCompoundSecMechConfig compoundSecMechConfig : compoundSecMechs) {
            compoundSecMechConfig.setSas_mech(sasMechConfig);
        }
    }

    protected CSSSASMechConfig extractSASMech(Map<String, Object> attributeLayerProperties) {
        CSSSASMechConfig sasMechConfig = new CSSSASMechConfig();
        sasMechConfig.addIdentityToken(new CSSSASITTAbsent());
        return sasMechConfig;
    }

    public Set<String> extractSslRefs(Map<String, Object> properties) {
        Set<String> sslRefs = this.extractSslRefs(properties, KEY_POLICY, this.TYPE);
        return sslRefs;
    }

    public abstract CSSASMechConfig handleASMech(String var1, Authenticator var2, String var3, boolean var4, Map<String, Object> var5);

    public abstract void logWarning(String var1, Object ... var2);

    public abstract Map<String, Object> getAttributeLayerProperties(CommonCfg.LayersData var1);
}

