/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jboss.jdeparser.JClass;
import org.jboss.jdeparser.JDeclaration;
import org.jboss.jdeparser.JDeparser;
import org.jboss.jdeparser.JFormatter;
import org.jboss.jdeparser.JPackage;

public final class JTypeVar
extends JClass
implements JDeclaration {
    private final String name;
    private List<JClass> bounds;

    JTypeVar(JDeparser owner, String _name) {
        super(owner);
        this.name = _name;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String fullName() {
        return this.name;
    }

    @Override
    public JPackage _package() {
        return null;
    }

    public JTypeVar bound(JClass c) {
        if (this.bounds == null) {
            this.bounds = new ArrayList<JClass>(1);
        }
        this.bounds.add(c);
        return this;
    }

    @Override
    public JClass _extends() {
        if (this.bounds != null) {
            return this.bounds.get(0);
        }
        return this.owner().ref(Object.class);
    }

    @Override
    public Iterator<JClass> _implements() {
        if (this.bounds != null) {
            Iterator<JClass> iterator = this.bounds.iterator();
            iterator.next();
            return iterator;
        }
        return Collections.emptySet().iterator();
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public void declare(JFormatter f) {
        Iterator<JClass> iterator;
        f.id(this.name);
        if (this.bounds != null && (iterator = this.bounds.iterator()).hasNext()) {
            f.p("extends");
            f.g(iterator.next());
            while (iterator.hasNext()) {
                f.p("&").g(iterator.next());
            }
        }
    }

    @Override
    protected JClass substituteParams(JTypeVar[] variables, List<JClass> bindings) {
        for (int i = 0; i < variables.length; ++i) {
            if (variables[i] != this) continue;
            return bindings.get(i);
        }
        return this;
    }

    @Override
    public void generate(JFormatter f) {
        f.id(this.name);
    }
}

