/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.typesafe.impl;

import io.smallrye.graphql.client.typesafe.api.ErrorOr;
import io.smallrye.graphql.client.typesafe.api.GraphQlClientError;
import io.smallrye.graphql.client.typesafe.api.GraphQlClientException;
import io.smallrye.graphql.client.typesafe.api.SourceLocation;
import io.smallrye.graphql.client.typesafe.impl.json.JsonReader;
import io.smallrye.graphql.client.typesafe.impl.json.JsonUtils;
import io.smallrye.graphql.client.typesafe.impl.reflection.MethodInvocation;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonPatch;
import javax.json.JsonPointer;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.stream.JsonCollectors;

public class ResultBuilder {
    private final MethodInvocation method;
    private final Map<String, String> queryCache;
    private final JsonObject response;
    private JsonObject data;
    private static final JsonPatch ERROR_MARK = Json.createPatchBuilder().add("/__typename", ErrorOr.class.getSimpleName()).build();

    public ResultBuilder(MethodInvocation method, Map<String, String> queryCache, String responseString) {
        this.method = method;
        this.queryCache = queryCache;
        this.response = Json.createReader((Reader)new StringReader(responseString)).readObject();
    }

    public Object read() {
        this.data = this.readData();
        this.readErrors();
        return this.data == null ? null : JsonReader.readJson(this.method.toString(), this.method.getReturnType(), (JsonValue)this.data.get((Object)this.method.getName()));
    }

    private JsonObject readData() {
        if (!this.response.containsKey((Object)"data") || this.response.isNull("data")) {
            return null;
        }
        JsonObject data = this.response.getJsonObject("data");
        if (!data.containsKey((Object)this.method.getName())) {
            throw new GraphQlClientException("no data for '" + this.method.getName() + "':\n  " + data);
        }
        return data;
    }

    private void readErrors() {
        if (!this.response.containsKey((Object)"errors") || this.response.isNull("errors")) {
            return;
        }
        JsonArray jsonErrors = this.response.getJsonArray("errors");
        if (jsonErrors == null) {
            return;
        }
        JsonArray unapplied = (JsonArray)jsonErrors.stream().filter(error -> !this.apply((JsonValue)error)).collect(JsonCollectors.toJsonArray());
        if (unapplied.isEmpty()) {
            return;
        }
        throw new GraphQlClientException("errors from service", unapplied.stream().map(this::convert).collect(Collectors.toList()));
    }

    private boolean apply(JsonValue error) {
        List<Object> path = ResultBuilder.getPath(error);
        if (path == null) {
            return false;
        }
        JsonPointer pointer = Json.createPointer((String)path.stream().map(Object::toString).collect(Collectors.joining("/", "/", "")));
        JsonArrayBuilder errors = Json.createArrayBuilder();
        if (pointer.containsValue((JsonStructure)this.data) && JsonUtils.isListOf(pointer.getValue((JsonStructure)this.data), ErrorOr.class.getSimpleName())) {
            pointer.getValue((JsonStructure)this.data).asJsonArray().forEach(arg_0 -> ((JsonArrayBuilder)errors).add(arg_0));
        }
        errors.add((JsonValue)ERROR_MARK.apply((JsonStructure)((JsonObject)error)));
        this.data = (JsonObject)pointer.replace((JsonStructure)this.data, (JsonValue)errors.build());
        return true;
    }

    private GraphQlClientError convert(JsonValue jsonValue) {
        final JsonObject jsonObject = jsonValue.asJsonObject();
        return new GraphQlClientError(){

            @Override
            public String getMessage() {
                return jsonObject.getString("message");
            }

            @Override
            public List<SourceLocation> getLocations() {
                JsonArray locations = jsonObject.getJsonArray("locations");
                return locations == null ? null : locations.stream().map(this::toSourceLocation).collect(Collectors.toList());
            }

            private SourceLocation toSourceLocation(JsonValue jsonValue) {
                JsonObject jsonObject2 = jsonValue.asJsonObject();
                return new SourceLocation(jsonObject2.getInt("line", 0), jsonObject2.getInt("column", 0), jsonObject2.getString("sourceName", null));
            }

            @Override
            public List<Object> getPath() {
                return ResultBuilder.getPath((JsonValue)jsonObject);
            }

            @Override
            public Map<String, Object> getExtensions() {
                return JsonUtils.toMap(jsonObject.getJsonObject("extensions"));
            }

            public String toString() {
                return this.defaultToString();
            }
        };
    }

    private static List<Object> getPath(JsonValue jsonValue) {
        JsonArray jsonArray = jsonValue.asJsonObject().getJsonArray("path");
        return jsonArray == null ? null : jsonArray.stream().map(JsonUtils::toValue).collect(Collectors.toList());
    }
}

