/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers.extension;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.smallrye.reactive.messaging.EmitterConfiguration;
import io.smallrye.reactive.messaging.providers.extension.AbstractEmitter;
import io.smallrye.reactive.messaging.providers.i18n.ProviderExceptions;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.eclipse.microprofile.reactive.messaging.Emitter;
import org.eclipse.microprofile.reactive.messaging.Message;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class EmitterImpl<T>
extends AbstractEmitter<T>
implements Emitter<T> {
    static final long serialVersionUID = 6974272715955013207L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public EmitterImpl(EmitterConfiguration config, long defaultBufferSize) {
        super(config, defaultBufferSize);
    }

    public CompletionStage<Void> send(T payload) {
        if (payload == null) {
            throw ProviderExceptions.ex.illegalArgumentForNullValue();
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.emit(Message.of(payload).withAck(() -> {
            future.complete(null);
            return CompletableFuture.completedFuture(null);
        }).withNack(reason -> {
            future.completeExceptionally((Throwable)reason);
            return CompletableFuture.completedFuture(null);
        }));
        return future;
    }

    public <M extends Message<? extends T>> void send(M msg) {
        if (msg == null) {
            throw ProviderExceptions.ex.illegalArgumentForNullValue();
        }
        this.emit(msg);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.smallrye.reactive.messaging.providers.extension.EmitterImpl", EmitterImpl.class, null, null);
    }
}

