/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers.extension;

import io.smallrye.reactive.messaging.MessagePublisherProvider;
import io.smallrye.reactive.messaging.annotations.Emitter;
import io.smallrye.reactive.messaging.providers.extension.EmitterImpl;
import io.smallrye.reactive.messaging.providers.i18n.ProviderExceptions;
import java.util.concurrent.Flow;
import org.eclipse.microprofile.reactive.messaging.Message;

public class LegacyEmitterImpl<T>
implements Emitter<T>,
MessagePublisherProvider<T> {
    private final EmitterImpl<T> delegate;

    LegacyEmitterImpl(EmitterImpl<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public Flow.Publisher<Message<? extends T>> getPublisher() {
        return this.delegate.getPublisher();
    }

    @Override
    public void complete() {
        this.delegate.complete();
    }

    @Override
    public void error(Exception e) {
        this.delegate.error(e);
    }

    @Override
    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    @Override
    public boolean isRequested() {
        return this.delegate.hasRequests();
    }

    @Override
    public Emitter<T> send(T msg) {
        if (msg == null) {
            throw ProviderExceptions.ex.illegalArgumentForNullValue();
        }
        if (msg instanceof Message) {
            this.delegate.send((Message)msg);
        } else {
            this.delegate.send(Message.of(msg));
        }
        return this;
    }
}

