/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ras.instrument.internal.main;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.internal.bci.CheckInstrumentableClassAdapter;
import com.ibm.ws.ras.instrument.internal.bci.FFDCClassAdapter;
import com.ibm.ws.ras.instrument.internal.bci.JSR47TracingClassAdapter;
import com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter;
import com.ibm.ws.ras.instrument.internal.bci.LibertyTracePreprocessClassAdapter;
import com.ibm.ws.ras.instrument.internal.bci.LibertyTracingClassAdapter;
import com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter;
import com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingClassAdapter;
import com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter;
import com.ibm.ws.ras.instrument.internal.introspect.InjectedTraceAnnotationVisitor;
import com.ibm.ws.ras.instrument.internal.introspect.TraceObjectFieldAnnotationVisitor;
import com.ibm.ws.ras.instrument.internal.introspect.TraceOptionsAnnotationVisitor;
import com.ibm.ws.ras.instrument.internal.main.AbstractInstrumentation;
import com.ibm.ws.ras.instrument.internal.model.PackageInfo;
import com.ibm.ws.ras.instrument.internal.model.TraceOptionsData;
import com.ibm.ws.ras.instrument.internal.model.TraceType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.SerialVersionUIDAdder;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.util.CheckClassAdapter;
import org.objectweb.asm.util.TraceClassVisitor;

public class LibertyTracePreprocessInstrumentation
extends AbstractInstrumentation {
    public static final Type TRIVIAL_TYPE = Type.getType(Trivial.class);
    public static final Type TRACE_OPTIONS_TYPE = Type.getType(TraceOptions.class);
    public static final Type LIBERTY_TR_TYPE = LibertyTracingClassAdapter.TR_TYPE;
    public static final Type LIBERTY_TRACE_COMPONENT_TYPE = LibertyTracingClassAdapter.TRACE_COMPONENT_TYPE;
    public static final Type WEBSPHERE_TR_TYPE = WebSphereTrTracingClassAdapter.TR_TYPE;
    public static final Type WEBSPHERE_TRACE_COMPONENT_TYPE = WebSphereTrTracingClassAdapter.TRACE_COMPONENT_TYPE;
    public static final Type LOGGER_TYPE = Type.getType(Logger.class);
    public static final Type INJECTED_TRACE_TYPE = Type.getType(InjectedTrace.class);
    public static final Type MANUAL_TRACE_TYPE = Type.getType(ManualTrace.class);
    public static final Type TRACE_OBJECT_FIELD_TYPE = Type.getType(TraceObjectField.class);
    private boolean addFfdc = false;
    private boolean injectStatic = false;
    private String defaultTraceComponentName = "$$$tc$$$";
    private TraceType defaultTraceType = TraceType.LIBERTY;

    private AnnotationNode getAnnotation(String desc, List<AnnotationNode> annotations) {
        if (annotations == null) {
            return null;
        }
        for (AnnotationNode an : annotations) {
            if (!desc.equals(an.desc)) continue;
            return an;
        }
        return null;
    }

    private List<FieldNode> getFieldsByDesc(String desc, List<FieldNode> fields) {
        ArrayList<FieldNode> result = new ArrayList<FieldNode>();
        for (FieldNode fn : fields) {
            if (!desc.equals(fn.desc)) continue;
            result.add(fn);
        }
        return result;
    }

    private List<MethodNode> getMethods(String name, List<MethodNode> methods) {
        ArrayList<MethodNode> result = new ArrayList<MethodNode>();
        for (MethodNode mn : methods) {
            if (!name.equals(mn.name)) continue;
            result.add(mn);
        }
        return result;
    }

    private MethodNode getMethod(String name, String desc, List<MethodNode> methods) {
        for (MethodNode mn : methods) {
            if (!name.equals(mn.name) || !desc.equals(mn.desc)) continue;
            return mn;
        }
        return null;
    }

    private boolean isClassTrivial(ClassTraceInfo info) {
        AnnotationNode trivialAnnotation = this.getAnnotation(TRIVIAL_TYPE.getDescriptor(), info.classNode.visibleAnnotations);
        return trivialAnnotation != null;
    }

    private boolean isInnerClass(ClassTraceInfo info) {
        if (info.classNode.innerClasses.isEmpty()) {
            return false;
        }
        int innerIdentifierIndex = info.classNode.name.lastIndexOf("$");
        return innerIdentifierIndex != -1;
    }

    private void processClassTraceOptionsAnnotation(ClassTraceInfo info) {
        AnnotationNode traceOptionsAnnotation = this.getAnnotation(TRACE_OPTIONS_TYPE.getDescriptor(), info.classNode.visibleAnnotations);
        if (traceOptionsAnnotation != null) {
            TraceOptionsAnnotationVisitor optionsVisitor = new TraceOptionsAnnotationVisitor();
            traceOptionsAnnotation.accept((AnnotationVisitor)optionsVisitor);
            info.setClassTraceOptionsData(optionsVisitor.getTraceOptionsData());
        }
    }

    private void processLibertyTraceComponentDiscovery(ClassTraceInfo info) {
        List<FieldNode> traceComponentFields = this.getFieldsByDesc(LIBERTY_TRACE_COMPONENT_TYPE.getDescriptor(), info.classNode.fields);
        if (!traceComponentFields.isEmpty()) {
            for (int i = traceComponentFields.size() - 1; i >= 0; --i) {
                FieldNode fn = traceComponentFields.get(i);
                if ((fn.access & 8) == 8) continue;
                traceComponentFields.remove(i);
                StringBuilder sb = new StringBuilder();
                sb.append("WARNING: TraceComponent field declared but must be static in class: ");
                sb.append(info.classNode.name.replaceAll("/", "\\."));
                info.warnings.add(sb.toString());
                info.failInstrumentation = true;
            }
            if (traceComponentFields.size() > 1) {
                StringBuilder sb = new StringBuilder();
                sb.append("WARNING: Multiple com.ibm.websphere.ras.TraceComponent fields declared on class ");
                sb.append(info.classNode.name.replaceAll("/", "\\.")).append(": ");
                for (int i = 0; i < traceComponentFields.size(); ++i) {
                    sb.append(traceComponentFields.get((int)i).name);
                    if (i + 1 == traceComponentFields.size()) continue;
                    sb.append(", ");
                }
                info.warnings.add(sb.toString());
            }
            if (traceComponentFields.size() > 0) {
                info.libertyTraceComponentFieldNode = traceComponentFields.get(0);
            }
        }
    }

    public String getDefaultTraceComponentName() {
        return this.defaultTraceComponentName;
    }

    private void processWebsphereTraceComponentDiscovery(ClassTraceInfo info) {
        List<FieldNode> traceComponentFields = this.getFieldsByDesc(WEBSPHERE_TRACE_COMPONENT_TYPE.getDescriptor(), info.classNode.fields);
        if (!traceComponentFields.isEmpty()) {
            for (int i = traceComponentFields.size() - 1; i >= 0; --i) {
                FieldNode fn = traceComponentFields.get(i);
                if ((fn.access & 8) == 8) continue;
                traceComponentFields.remove(i);
            }
            if (traceComponentFields.size() > 1) {
                StringBuilder sb = new StringBuilder();
                sb.append("WARNING: Multiple com.ibm.ejs.ras.TraceComponent fields declared on class ");
                sb.append(info.classNode.name.replaceAll("/", "\\.")).append(": ");
                for (int i = 0; i < traceComponentFields.size(); ++i) {
                    sb.append(traceComponentFields.get((int)i).name);
                    if (i + 1 == traceComponentFields.size()) continue;
                    sb.append(", ");
                }
                info.warnings.add(sb.toString());
            }
            if (traceComponentFields.size() > 0) {
                info.websphereTraceComponentFieldNode = traceComponentFields.get(0);
            }
        }
    }

    private void processJavaLoggerDiscovery(ClassTraceInfo info) {
        List<FieldNode> loggerFields = this.getFieldsByDesc(LOGGER_TYPE.getDescriptor(), info.classNode.fields);
        if (!loggerFields.isEmpty()) {
            for (int i = loggerFields.size() - 1; i >= 0; --i) {
                FieldNode fn = loggerFields.get(i);
                if ((fn.access & 8) == 8) continue;
                loggerFields.remove(i);
                StringBuilder sb = new StringBuilder();
                sb.append("WARNING: Non-static java.util.logging.Logger field declared on class ");
                sb.append(info.classNode.name.replaceAll("/", "\\.")).append(": ");
                sb.append(fn.name);
                info.warnings.add(sb.toString());
            }
            if (loggerFields.size() > 1) {
                StringBuilder sb = new StringBuilder();
                sb.append("WARNING: Multiple java.util.logging.Logger fields declared on class ");
                sb.append(info.classNode.name.replaceAll("/", "\\.")).append(": ");
                for (int i = 0; i < loggerFields.size(); ++i) {
                    sb.append(loggerFields.get((int)i).name);
                    if (i + 1 == loggerFields.size()) continue;
                    sb.append(", ");
                }
                info.warnings.add(sb.toString());
            }
            if (loggerFields.size() > 0) {
                info.loggerFieldNode = loggerFields.get(0);
            }
        }
    }

    private void setupTraceStateObjectField(ClassTraceInfo info) {
        StringBuilder sb;
        AnnotationNode traceObjectAnnotation = this.getAnnotation(TRACE_OBJECT_FIELD_TYPE.getDescriptor(), info.classNode.visibleAnnotations);
        if (traceObjectAnnotation != null) {
            TraceObjectFieldAnnotationVisitor visitor = new TraceObjectFieldAnnotationVisitor();
            traceObjectAnnotation.accept((AnnotationVisitor)visitor);
            List<FieldNode> fields = this.getFieldsByDesc(visitor.getFieldDescriptor(), info.classNode.fields);
            for (FieldNode fn : fields) {
                if (!fn.name.equals(visitor.getFieldName())) continue;
                info.traceStateField = fn;
                break;
            }
            if (info.traceStateField != null) {
                return;
            }
        }
        if (info.libertyTraceComponentFieldNode != null) {
            info.traceStateField = info.libertyTraceComponentFieldNode;
            info.traceStateFieldAlreadyInitialized = info.libertyTraceComponentFieldAlreadyInitialized;
        } else if (info.websphereTraceComponentFieldNode != null) {
            sb = new StringBuilder();
            sb.append("INFO: Runtime BCI is not supported for com.ibm.ejs.ras.  Build-time BCI will be used for class ");
            sb.append(info.classNode.name.replace('/', '.'));
            sb.append(".  Consider using the com.ibm.websphere.ras package.");
            info.warnings.add(sb.toString());
            info.traceStateField = info.websphereTraceComponentFieldNode;
            info.traceStateFieldAlreadyInitialized = info.websphereTraceComponentFieldAlreadyInitialized;
        } else if (info.loggerFieldNode != null) {
            sb = new StringBuilder();
            sb.append("INFO: Runtime BCI is not supported for JSR47 Logging.  Build-time BCI will be used for class ");
            sb.append(info.classNode.name.replace('/', '.'));
            sb.append(".");
            info.warnings.add(sb.toString());
            info.traceStateField = info.loggerFieldNode;
            info.traceStateFieldAlreadyInitialized = info.loggerFieldAlreadyInitialized;
        } else if (this.defaultTraceType == TraceType.LIBERTY) {
            int access = 4122;
            info.traceStateField = (FieldNode)info.classNode.visitField(access, this.getDefaultTraceComponentName(), LIBERTY_TRACE_COMPONENT_TYPE.getDescriptor(), null, null);
        }
        if (info.traceStateField != null) {
            AnnotationVisitor av = info.classNode.visitAnnotation(TRACE_OBJECT_FIELD_TYPE.getDescriptor(), true);
            av.visit("fieldName", (Object)info.traceStateField.name);
            av.visit("fieldDesc", (Object)info.traceStateField.desc);
            av.visitEnd();
        }
    }

    private boolean isMethodAlreadyInjectedAnnotationPresent(MethodNode methodNode) {
        AnnotationNode injectedTraceAnnotation = this.getAnnotation(INJECTED_TRACE_TYPE.getDescriptor(), methodNode.visibleAnnotations);
        AnnotationNode manualTraceAnnotation = this.getAnnotation(MANUAL_TRACE_TYPE.getDescriptor(), methodNode.visibleAnnotations);
        if (manualTraceAnnotation != null) {
            return true;
        }
        if (injectedTraceAnnotation != null) {
            InjectedTraceAnnotationVisitor itav = new InjectedTraceAnnotationVisitor();
            injectedTraceAnnotation.accept((AnnotationVisitor)itav);
            List<String> methodAdapters = itav.getMethodAdapters();
            if (methodAdapters.contains(LibertyTracingMethodAdapter.class.getName())) {
                return true;
            }
            if (methodAdapters.contains(WebSphereTrTracingMethodAdapter.class.getName())) {
                return true;
            }
            if (methodAdapters.contains(JSR47TracingMethodAdapter.class.getName())) {
                return true;
            }
        }
        return false;
    }

    private void processExistingStaticInitializer(ClassTraceInfo info) {
        MethodNode staticInitializer;
        List<MethodNode> clinitMethods = this.getMethods("<clinit>", info.classNode.methods);
        MethodNode methodNode = staticInitializer = clinitMethods.isEmpty() ? null : clinitMethods.get(0);
        if (staticInitializer == null) {
            return;
        }
        if (this.isMethodAlreadyInjectedAnnotationPresent(staticInitializer)) {
            return;
        }
        for (AbstractInsnNode insnNode : staticInitializer.instructions) {
            FieldInsnNode fieldInsn;
            if (insnNode.getType() != 4 || (fieldInsn = (FieldInsnNode)insnNode).getOpcode() != 179) continue;
            if (info.libertyTraceComponentFieldNode != null && fieldInsn.name.equals(info.libertyTraceComponentFieldNode.name) && fieldInsn.getPrevious().getOpcode() == 184) {
                info.libertyTraceComponentFieldAlreadyInitialized = true;
            }
            if (info.websphereTraceComponentFieldNode != null && fieldInsn.name.equals(info.websphereTraceComponentFieldNode.name)) {
                info.websphereTraceComponentFieldAlreadyInitialized = true;
            }
            if (info.loggerFieldNode == null || !fieldInsn.name.equals(info.loggerFieldNode.name)) continue;
            info.loggerFieldAlreadyInitialized = true;
        }
    }

    private void processToString(ClassTraceInfo info) {
        block0: for (MethodNode mn : info.classNode.methods) {
            if (!mn.name.equals("toString") || !mn.desc.equals("()Ljava/lang/String;")) continue;
            block1: for (AbstractInsnNode insnNode : mn.instructions) {
                MethodNode m;
                MethodInsnNode methodInsn;
                if (insnNode.getType() != 5 || (methodInsn = (MethodInsnNode)insnNode).getOpcode() == 184 || !methodInsn.owner.equals(info.classNode.name) || (m = this.getMethod(methodInsn.name, methodInsn.desc, info.classNode.methods)) != null && this.getAnnotation(TRIVIAL_TYPE.getDescriptor(), m.visibleAnnotations) != null) continue;
                String superName = info.classNode.superName;
                while (m == null && superName != null && !"java/lang/Object".equals(superName)) {
                    if (superName.startsWith("java/") || superName.startsWith("javax/")) continue block1;
                    InputStream superClassInputStream = this.getClassInputStream(superName);
                    if (superClassInputStream == null) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("INFO: ").append(info.classNode.name.replaceAll("/", "\\."));
                        sb.append(" extends class ").append(superName.replaceAll("/", "\\."));
                        sb.append(" and is calling ").append(methodInsn.name);
                        sb.append(" from toString()");
                        info.warnings.add(sb.toString());
                        continue block1;
                    }
                    ClassNode cn = this.getClassNode(superClassInputStream, 3);
                    m = this.getMethod(methodInsn.name, methodInsn.desc, cn.methods);
                    superName = cn.superName;
                }
                if (m != null && this.getAnnotation(TRIVIAL_TYPE.getDescriptor(), m.visibleAnnotations) != null) continue;
                StringBuilder sb = new StringBuilder();
                sb.append("WARNING: ").append(info.classNode.name.replaceAll("/", "\\."));
                sb.append(" is calling traceable methods from toString(); this may result in infinite recursion.  ");
                sb.append("Consider referencing class fields or marking the called methods trivial to avoid trace.");
                info.warnings.add(sb.toString());
                continue block0;
            }
        }
    }

    private ClassNode getClassNode(InputStream inputStream, int flags) {
        ClassNode cn = new ClassNode();
        try {
            ClassReader reader = new ClassReader(inputStream);
            reader.accept((ClassVisitor)cn, flags);
            inputStream.close();
        }
        catch (IOException e) {
            cn = null;
        }
        return cn;
    }

    private void processManuallyTracedMethods(ClassTraceInfo info) {
        block0: for (MethodNode mn : info.classNode.methods) {
            if (this.isMethodAlreadyInjectedAnnotationPresent(mn)) continue;
            for (AbstractInsnNode insnNode : mn.instructions) {
                boolean manuallyTraced = false;
                if (insnNode.getType() == 5) {
                    MethodInsnNode methodInsn = (MethodInsnNode)insnNode;
                    String methodName = methodInsn.name;
                    if (methodInsn.owner.equals(LOGGER_TYPE.getInternalName())) {
                        manuallyTraced = methodName.equals("entering") || methodName.equals("exiting");
                    } else if (methodInsn.owner.equals(LIBERTY_TR_TYPE.getInternalName())) {
                        manuallyTraced = methodName.equals("entry") || methodName.equals("exit");
                    } else if (methodInsn.owner.equals(WEBSPHERE_TR_TYPE.getInternalName())) {
                        boolean bl = manuallyTraced = methodName.equals("entry") || methodName.equals("exit");
                    }
                }
                if (!manuallyTraced) continue;
                mn.visitAnnotation(MANUAL_TRACE_TYPE.getDescriptor(), true).visitEnd();
                StringBuilder sb = new StringBuilder();
                sb.append("WARNING: Hard coded entry/exit trace point found in ");
                sb.append(info.classNode.name.replaceAll("/", "\\.")).append(".").append(mn.name).append(mn.desc);
                sb.append(".  Skipping method.");
                info.warnings.add(sb.toString());
                continue block0;
            }
        }
    }

    @Override
    protected byte[] transform(InputStream classfileStream) throws IOException {
        ClassWriter classWriter;
        ClassReader reader = new ClassReader(classfileStream);
        ClassNode directory = new ClassNode();
        CheckInstrumentableClassAdapter checkInstrumentableAdapter = new CheckInstrumentableClassAdapter((ClassVisitor)directory);
        SerialVersionUIDAdder uidAdder = new SerialVersionUIDAdder((ClassVisitor)checkInstrumentableAdapter);
        reader.accept((ClassVisitor)uidAdder, 0);
        ClassTraceInfo info = new ClassTraceInfo();
        info.classNode = directory;
        info.packageInfo = this.getPackageInfo(directory.name.replaceAll("/[^/]+$", ""));
        if (!this.isInnerClass(info)) {
            this.processClassTraceOptionsAnnotation(info);
        }
        this.processLibertyTraceComponentDiscovery(info);
        this.processWebsphereTraceComponentDiscovery(info);
        this.processJavaLoggerDiscovery(info);
        int declaredTraceStateFieldCount = 0;
        if (info.libertyTraceComponentFieldNode != null) {
            ++declaredTraceStateFieldCount;
        }
        if (!checkInstrumentableAdapter.isInstrumentableClass() || this.isClassTrivial(info) && declaredTraceStateFieldCount == 0) {
            return null;
        }
        if (info.websphereTraceComponentFieldNode != null) {
            ++declaredTraceStateFieldCount;
        }
        if (info.loggerFieldNode != null) {
            ++declaredTraceStateFieldCount;
        }
        if (declaredTraceStateFieldCount > 1) {
            StringBuilder sb = new StringBuilder();
            sb.append("WARNING: More than one type of tracing has been detected on class ");
            sb.append(info.classNode.name.replaceAll("/", "\\."));
            info.warnings.add(sb.toString());
        }
        if (!this.isInnerClass(info) || this.isInnerClass(info) && declaredTraceStateFieldCount == 0) {
            this.processExistingStaticInitializer(info);
            this.setupTraceStateObjectField(info);
        }
        this.processToString(info);
        this.processManuallyTracedMethods(info);
        for (String warning : info.warnings) {
            System.out.println(warning);
        }
        if (info.failInstrumentation) {
            System.out.println("ERROR: Instrumentation failed for " + info.classNode.name + ".  Please see previous messages");
            return null;
        }
        Object cv = classWriter = new ClassWriter(reader, 1);
        if (this.isDebug()) {
            cv = new CheckClassAdapter((ClassVisitor)cv);
            cv = new TraceClassVisitor((ClassVisitor)cv, new PrintWriter(System.out));
        }
        if (this.injectStatic && info.traceStateField != null && LIBERTY_TRACE_COMPONENT_TYPE.getDescriptor().equals(info.traceStateField.desc)) {
            cv = new LibertyTracingClassAdapter((ClassVisitor)cv, info, true);
        }
        if (info.traceStateField != null) {
            cv = new LibertyTracePreprocessClassAdapter((ClassVisitor)cv, !info.traceStateFieldAlreadyInitialized, info);
        } else if (this.defaultTraceType == TraceType.TR) {
            cv = new WebSphereTrTracingClassAdapter((ClassVisitor)cv, null, info);
        } else if (this.defaultTraceType == TraceType.JAVA_LOGGING) {
            cv = new JSR47TracingClassAdapter((ClassVisitor)cv, null, info);
        }
        if (this.addFfdc && !this.isClassTrivial(info)) {
            cv = new FFDCClassAdapter((ClassVisitor)cv, null, info);
        }
        directory.accept((ClassVisitor)cv);
        return classWriter.toByteArray();
    }

    @Override
    public void processArguments(String[] args) throws IOException {
        int i;
        ArrayList<File> classFiles = new ArrayList<File>();
        ArrayList<File> jarFiles = new ArrayList<File>();
        String[] fileArgs = null;
        for (i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("--debug") || args[i].equals("-d")) {
                this.setDebug(true);
                continue;
            }
            if (args[i].equalsIgnoreCase("--config")) {
                File configFile = new File(args[++i]);
                System.out.println("Config file not currently supported" + configFile);
                continue;
            }
            if (args[i].equalsIgnoreCase("--ffdc")) {
                this.addFfdc = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("--static")) {
                this.injectStatic = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("--liberty")) {
                this.defaultTraceType = TraceType.LIBERTY;
                continue;
            }
            if (args[i].equalsIgnoreCase("--tr")) {
                this.defaultTraceType = TraceType.TR;
                continue;
            }
            if (args[i].equalsIgnoreCase("--java-logging")) {
                this.defaultTraceType = TraceType.JAVA_LOGGING;
                continue;
            }
            fileArgs = new String[args.length - i];
            System.arraycopy(args, i, fileArgs, 0, fileArgs.length);
            break;
        }
        if (fileArgs == null || fileArgs.length == 0) {
            throw new IllegalArgumentException("No file specified");
        }
        for (i = 0; i < fileArgs.length; ++i) {
            File f = new File((String)fileArgs[i]);
            if (!f.exists()) {
                throw new IllegalArgumentException("File \"" + f + "\" does not exist");
            }
            if (f.isDirectory()) {
                classFiles.addAll(this.getClassFiles(f, null));
                jarFiles.addAll(this.getJarFiles(f, null));
                continue;
            }
            if (f.getName().endsWith(".class")) {
                classFiles.add(f);
                continue;
            }
            if (f.getName().endsWith(".jar")) {
                jarFiles.add(f);
                continue;
            }
            if (f.getName().endsWith(".zip")) {
                jarFiles.add(f);
                continue;
            }
            System.err.println(f + " is an unexpected file type; ignoring");
        }
        this.setClassFiles(classFiles);
        this.setJarFiles(jarFiles);
    }

    private static void printUsageMessage() {
        System.err.println("Descrption:");
        System.err.println("");
        System.err.println("Required arguments:");
        System.err.println("  The paths to one or more binary classes, jars, or");
        System.err.println("  directories to scan for classes and jars are required");
        System.err.println("  parameters.");
        System.err.println("");
        System.err.println("  Class files must have a .class extension.");
        System.err.println("  Jar files must have a .jar or a .zip extension.");
        System.err.println("  Directories are recursively scanned for .class files");
        System.err.println("  to process.");
    }

    public static void main(String[] args) throws IOException {
        if (args == null || args.length == 0) {
            LibertyTracePreprocessInstrumentation.printUsageMessage();
            return;
        }
        LibertyTracePreprocessInstrumentation processor = new LibertyTracePreprocessInstrumentation();
        processor.processArguments(args);
        processor.processPackageInfo();
        processor.executeInstrumentation();
    }

    public class ClassTraceInfo {
        ClassNode classNode;
        public PackageInfo packageInfo;
        private TraceOptionsData classTraceOptions;
        FieldNode libertyTraceComponentFieldNode;
        boolean libertyTraceComponentFieldAlreadyInitialized;
        FieldNode websphereTraceComponentFieldNode;
        boolean websphereTraceComponentFieldAlreadyInitialized;
        FieldNode loggerFieldNode;
        boolean loggerFieldAlreadyInitialized;
        FieldNode traceStateField;
        boolean traceStateFieldAlreadyInitialized;
        List<String> warnings = new ArrayList<String>();
        boolean failInstrumentation;

        public TraceOptionsData getTraceOptionsData() {
            if (this.classTraceOptions != null) {
                return this.classTraceOptions;
            }
            if (this.packageInfo != null) {
                return this.packageInfo.getTraceOptionsData();
            }
            return null;
        }

        public void setClassTraceOptionsData(TraceOptionsData traceOptions) {
            this.classTraceOptions = traceOptions;
        }
    }
}

