/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.reactive.messaging.kafka;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.reactive.messaging.kafka.PartitionTracker;
import com.ibm.ws.microprofile.reactive.messaging.kafka.PartitionTrackerFactory;
import com.ibm.ws.microprofile.reactive.messaging.kafka.ThresholdCounter;
import com.ibm.ws.microprofile.reactive.messaging.kafka.ThresholdCounterImpl;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.ConsumerRebalanceListener;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.ConsumerRecord;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.ConsumerRecords;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.KafkaAdapterFactory;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.KafkaConsumer;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.OffsetAndMetadata;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.TopicPartition;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.WakeupException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class KafkaInput<K, V>
implements ConsumerRebalanceListener {
    private static final TraceComponent tc = Tr.register(KafkaInput.class, (String)"REACTIVEMESSAGE", (String)"com.ibm.ws.microprofile.reactive.messaging.kafka.resources.ReactiveMessaging");
    private static final Duration FOREVER = Duration.ofMillis(Long.MAX_VALUE);
    private final KafkaConsumer<K, V> kafkaConsumer;
    private final ExecutorService executor;
    private final Collection<String> topics;
    private PublisherBuilder<Message<V>> publisher;
    private boolean subscribed = false;
    private volatile boolean running = true;
    private volatile Throwable error = null;
    private final ConcurrentLinkedQueue<KafkaConsumerAction> tasks;
    private final KafkaAdapterFactory kafkaAdapterFactory;
    private final ThresholdCounter unackedMessageCounter;
    private final PartitionTrackerFactory partitionTrackerFactory;
    private final boolean fastAck;
    private volatile Map<TopicPartition, PartitionTracker> partitionTrackers = Collections.emptyMap();
    private volatile Collection<TopicPartition> newPartitionsPending = null;
    private final ReentrantLock lock = new ReentrantLock();
    static final long serialVersionUID = 6399224447170086290L;

    public KafkaInput(KafkaAdapterFactory kafkaAdapterFactory, PartitionTrackerFactory partitionTrackerFactory, KafkaConsumer<K, V> kafkaConsumer, ExecutorService executor, String topic, int unackedLimit, boolean fastAck) {
        this.kafkaConsumer = kafkaConsumer;
        this.executor = executor;
        this.topics = Collections.singleton(topic);
        this.tasks = new ConcurrentLinkedQueue();
        this.kafkaAdapterFactory = kafkaAdapterFactory;
        this.partitionTrackerFactory = partitionTrackerFactory;
        this.unackedMessageCounter = unackedLimit > 0 ? new ThresholdCounterImpl(unackedLimit) : ThresholdCounter.UNLIMITED;
        this.fastAck = fastAck;
    }

    public PublisherBuilder<Message<V>> getPublisher() {
        if (this.publisher == null) {
            this.publisher = this.createPublisher();
        }
        return this.publisher;
    }

    private PublisherBuilder<Message<V>> createPublisher() {
        PublisherBuilder kafkaStream = ReactiveStreams.generate(() -> 0).flatMapCompletionStage(x -> this.unackedMessageCounter.waitForBelowThreshold().thenCompose(y -> this.pollKafkaAsync())).flatMap(Function.identity()).peek(x -> this.unackedMessageCounter.increment()).takeWhile(record -> this.running).flatMap(this::errorMapper).onError(e -> this.shutdown());
        return kafkaStream;
    }

    private PublisherBuilder<Message<V>> errorMapper(Message<V> message) {
        if (this.error != null) {
            return ReactiveStreams.failed((Throwable)this.error);
        }
        return ReactiveStreams.of(message);
    }

    /*
     * WARNING - void declaration
     */
    public CompletionStage<Void> commitOffsets(PartitionTracker partitionTracker, OffsetAndMetadata offset) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        try {
            Map<TopicPartition, OffsetAndMetadata> offsets = Collections.singletonMap(partitionTracker.getTopicPartition(), offset);
            this.runAction(c -> {
                if (partitionTracker.isClosed()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"Rejecting commit attempt because partition is closed", (Object[])new Object[]{this});
                    }
                    result.completeExceptionally(new Exception("Partition is closed"));
                    return;
                }
                c.commitAsync(offsets, (o, e) -> {
                    if (e != null) {
                        Tr.warning((TraceComponent)tc, (String)"kafka.read.offsets.commit.warning.CWMRX1001W", (Object[])new Object[]{e});
                        result.completeExceptionally(e);
                    } else {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Committed offsets successfully", (Object[])new Object[]{o});
                        }
                        result.complete(null);
                    }
                });
            });
            return result;
        }
        catch (Throwable offsets) {
            void t;
            FFDCFilter.processException((Throwable)offsets, (String)"com.ibm.ws.microprofile.reactive.messaging.kafka.KafkaInput", (String)"179", (Object)this, (Object[])new Object[]{partitionTracker, offset});
            Tr.warning((TraceComponent)tc, (String)"kafka.read.offsets.commit.warning.CWMRX1001W", (Object[])new Object[]{t});
            result.completeExceptionally((Throwable)t);
            return result;
        }
    }

    private static <T> Void logPollFailure(T result, Throwable t) {
        if (t != null) {
            Tr.error((TraceComponent)tc, (String)"kafka.poll.error.CWMRX1002E", (Object[])new Object[]{t});
        }
        return null;
    }

    public void shutdown() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Shutting down Kafka connection", (Object[])new Object[0]);
        }
        this.running = false;
        this.kafkaConsumer.wakeup();
        this.lock.lock();
        try {
            this.kafkaConsumer.close();
        }
        finally {
            this.lock.unlock();
        }
        for (PartitionTracker tracker : this.partitionTrackers.values()) {
            tracker.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={WakeupException.class, RejectedExecutionException.class})
    private CompletionStage<PublisherBuilder<Message<V>>> pollKafkaAsync() {
        if (!this.subscribed) {
            this.lock.lock();
            try {
                this.kafkaConsumer.subscribe(this.topics, (ConsumerRebalanceListener)this);
                this.subscribed = true;
            }
            finally {
                this.lock.unlock();
            }
        }
        if (!this.running) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Not running, returning incomplete future", (Object[])new Object[0]);
            }
            return new CompletableFuture<PublisherBuilder<Message<V>>>();
        }
        CompletableFuture<PublisherBuilder<Message<V>>> result = new CompletableFuture<PublisherBuilder<Message<V>>>();
        result.handle(KafkaInput::logPollFailure);
        ConsumerRecords records = null;
        while (this.lock.tryLock()) {
            try {
                records = this.kafkaConsumer.poll(Duration.ZERO);
                break;
            }
            catch (WakeupException wakeupException) {
            }
            finally {
                this.lock.unlock();
            }
            this.runPendingActions();
        }
        if (records != null && !records.isEmpty()) {
            result.complete(this.wrapInMessageStream(records));
        } else {
            try {
                this.executor.submit(() -> this.executePollActions(result));
            }
            catch (RejectedExecutionException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Asynchronous execution rejected, returning incomplete future", (Object[])new Object[0]);
                }
                return new CompletableFuture<PublisherBuilder<Message<V>>>();
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={WakeupException.class})
    private void executePollActions(CompletableFuture<PublisherBuilder<Message<V>>> result) {
        this.lock.lock();
        try {
            while (this.running) {
                try {
                    this.runPendingActions();
                    ConsumerRecords asyncRecords = this.kafkaConsumer.poll(FOREVER);
                    result.complete(this.wrapInMessageStream(asyncRecords));
                    break;
                }
                catch (WakeupException asyncRecords) {
                }
                catch (Throwable asyncRecords) {
                    void t;
                    FFDCFilter.processException((Throwable)asyncRecords, (String)"com.ibm.ws.microprofile.reactive.messaging.kafka.KafkaInput", (String)"283", (Object)this, (Object[])new Object[]{result});
                    result.completeExceptionally((Throwable)t);
                    break;
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        this.runPendingActions();
    }

    private PublisherBuilder<Message<V>> wrapInMessageStream(ConsumerRecords<K, V> records) {
        Map<TopicPartition, PartitionTracker> trackers = this.partitionTrackers;
        return ReactiveStreams.fromIterable(records).map(r -> {
            try {
                TopicPartition partition = this.kafkaAdapterFactory.newTopicPartition(r.topic(), r.partition());
                PartitionTracker tracker = (PartitionTracker)trackers.get(partition);
                Message message = this.kafkaAdapterFactory.newIncomingKafkaMessage(r, () -> {
                    this.unackedMessageCounter.decrement();
                    CompletionStage<Void> ackResult = tracker.recordDone(r.offset(), r.leaderEpoch());
                    return this.fastAck ? CompletableFuture.completedFuture(null) : ackResult;
                }, t -> {
                    KafkaInput.logNackedMessage(r, t);
                    this.error = t;
                    this.unackedMessageCounter.decrement();
                    return CompletableFuture.completedFuture(null);
                });
                return new TrackedMessage(message, tracker);
            }
            catch (Throwable t2) {
                Tr.error((TraceComponent)tc, (String)"internal.kafka.connector.error.CWMRX1000E", (Object[])new Object[]{t2});
                throw t2;
            }
        }).filter(m -> !((TrackedMessage)m).tracker.isClosed()).map(m -> ((TrackedMessage)m).message);
    }

    private static void logNackedMessage(ConsumerRecord<?, ?> record, Throwable exception) {
        Tr.error((TraceComponent)tc, (String)"kafka.input.message.nacked.CWMRX1011E", (Object[])new Object[]{record, exception});
        FFDCFilter.processException((Throwable)exception, (String)KafkaInput.class.getName(), (String)"message-nack");
    }

    public void runAction(KafkaConsumerAction action) {
        this.tasks.add(action);
        this.kafkaConsumer.wakeup();
        this.runPendingActions();
    }

    /*
     * WARNING - void declaration
     */
    public void runPendingActions() {
        while (!this.tasks.isEmpty() && this.lock.tryLock()) {
            try {
                if (this.running) {
                    KafkaConsumerAction task = null;
                    while ((task = this.tasks.poll()) != null) {
                        try {
                            task.run(this.kafkaConsumer);
                        }
                        catch (Throwable throwable) {
                            void t;
                            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.microprofile.reactive.messaging.kafka.KafkaInput", (String)"376", (Object)this, (Object[])new Object[0]);
                            Tr.error((TraceComponent)tc, (String)"internal.kafka.connector.error.CWMRX1000E", (Object[])new Object[]{t});
                            throw t;
                        }
                    }
                    continue;
                }
                break;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && this.newPartitionsPending != null) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"onPartitionsRevoked called while new partitions pending:", (Object[])new Object[]{this.newPartitionsPending});
        }
        HashMap<TopicPartition, PartitionTracker> newMap = new HashMap<TopicPartition, PartitionTracker>(this.partitionTrackers);
        for (TopicPartition partition : partitions) {
            PartitionTracker tracker = (PartitionTracker)newMap.get(partition);
            if (tracker != null) {
                tracker.close();
                newMap.remove(partition);
                continue;
            }
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Partition revoked that we didn't know we were assigned", (Object[])new Object[]{partition});
        }
        this.partitionTrackers = newMap;
    }

    public void onPartitionsAssigned(Collection<TopicPartition> newPartitions) {
        if (this.newPartitionsPending != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"onPartitionsAssigned called with pending partitions", (Object[])new Object[]{this.newPartitionsPending});
            }
            this.newPartitionsPending.addAll(newPartitions);
        } else {
            this.newPartitionsPending = new HashSet<TopicPartition>(newPartitions);
        }
        HashMap<TopicPartition, PartitionTracker> newMap = new HashMap<TopicPartition, PartitionTracker>(this.partitionTrackers);
        for (TopicPartition partition : this.newPartitionsPending) {
            newMap.put(partition, this.partitionTrackerFactory.create(this, partition, this.kafkaConsumer.position(partition)));
        }
        this.newPartitionsPending = null;
        this.partitionTrackers = newMap;
    }

    @FunctionalInterface
    public static interface KafkaConsumerAction {
        public void run(KafkaConsumer<?, ?> var1);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class TrackedMessage<V> {
        private final Message<V> message;
        private final PartitionTracker tracker;
        static final long serialVersionUID = -1747247204024794888L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public TrackedMessage(Message<V> message, PartitionTracker tracker) {
            this.message = message;
            this.tracker = tracker;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.reactive.messaging.kafka.KafkaInput$TrackedMessage", TrackedMessage.class, (String)"REACTIVEMESSAGE", (String)"com.ibm.ws.microprofile.reactive.messaging.kafka.resources.ReactiveMessaging");
        }
    }
}

