/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.concurrent.internal.processor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.concurrency.policy.ConcurrencyPolicy;
import com.ibm.ws.concurrent.WSManagedExecutorService;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.resource.ResourceFactory;
import com.ibm.ws.resource.ResourceFactoryBuilder;
import com.ibm.wsspi.kernel.service.location.VariableRegistry;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.FilterUtils;
import io.openliberty.concurrent.internal.processor.AppDefinedResourceFactory;
import io.openliberty.concurrent.internal.processor.ContextServiceDefinitionProvider;
import io.openliberty.concurrent.internal.processor.ContextServiceResourceFactoryBuilder;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={ResourceFactoryBuilder.class}, property={"creates.objectClass=jakarta.enterprise.concurrent.ManagedExecutorService"})
public class ManagedExecutorResourceFactoryBuilder
implements ResourceFactoryBuilder {
    private static final TraceComponent tc = Tr.register(ManagedExecutorResourceFactoryBuilder.class, (String)"concurrent", (String)"io.openliberty.concurrent.internal.resources.CWWKCMessages");
    private static final String CONFIG_DISPLAY_ID = "config.displayId";
    private static final String CONFIG_SOURCE = "config.source";
    private static final String FILE = "file";
    private static final String ID = "id";
    static final String DECLARING_APPLICATION = "declaringApplication";
    static final String UNIQUE_JNDI_NAME = "jndiName.unique";
    private final AtomicServiceReference<ConfigurationAdmin> configAdminRef = new AtomicServiceReference("ConfigAdmin");
    private final AtomicServiceReference<VariableRegistry> variableRegistryRef = new AtomicServiceReference("VariableRegistry");
    static final long serialVersionUID = 2819586505205600070L;

    protected void activate(ComponentContext context) {
        this.configAdminRef.activate(context);
        this.variableRegistryRef.activate(context);
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    public ResourceFactory createResourceFactory(Map<String, Object> props) throws Exception {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createResourceFactory", (Object[])new Object[]{props});
        }
        Hashtable<String, Object> execSvcProps = new Hashtable<String, Object>();
        Hashtable<String, Object> concurrencyPolicyProps = new Hashtable<String, Object>();
        VariableRegistry variableRegistry = (VariableRegistry)this.variableRegistryRef.getServiceWithException();
        for (Map.Entry<String, Object> prop : props.entrySet()) {
            Object value = prop.getValue();
            if (value instanceof String) {
                value = variableRegistry.resolveRawString((String)value);
            } else if (value instanceof String[]) {
                String[] v = (String[])value;
                String[] s = new String[v.length];
                for (int i = 0; i < v.length; ++i) {
                    s[i] = variableRegistry.resolveRawString(v[i]);
                }
            }
            execSvcProps.put(prop.getKey(), value);
        }
        String declaringApplication = (String)execSvcProps.remove(DECLARING_APPLICATION);
        String application = (String)execSvcProps.get("application");
        String module = (String)execSvcProps.get("module");
        String component = (String)execSvcProps.get("component");
        String jndiName = (String)execSvcProps.get("jndiName");
        String contextSvcJndiName = (String)execSvcProps.remove("context");
        Long hungTaskThreshold = (Long)execSvcProps.remove("hungTaskThreshold");
        Integer maxAsync = (Integer)execSvcProps.remove("maxAsync");
        String[] properties = (String[])execSvcProps.remove("properties");
        String managedExecutorServiceID = ManagedExecutorResourceFactoryBuilder.getManagedExecutorServiceID(application, module, component, jndiName);
        String concurrencyPolicyId = managedExecutorServiceID + "/concurrencyPolicy";
        String contextServiceId = contextSvcJndiName == null || "java:comp/DefaultContextService".equals(contextSvcJndiName) ? "DefaultContextService" : ContextServiceResourceFactoryBuilder.getContextServiceID(application, module, component, contextSvcJndiName);
        StringBuilder filter = new StringBuilder(FilterUtils.createPropertyFilter((String)ID, (String)managedExecutorServiceID));
        filter.insert(filter.length() - 1, '*');
        if (!this.removeExistingConfigurations(filter.toString())) {
            throw new IllegalArgumentException(managedExecutorServiceID);
        }
        execSvcProps.put(ID, managedExecutorServiceID);
        execSvcProps.put(CONFIG_DISPLAY_ID, managedExecutorServiceID);
        execSvcProps.put(UNIQUE_JNDI_NAME, managedExecutorServiceID);
        execSvcProps.put("ConcurrencyPolicy.target", FilterUtils.createPropertyFilter((String)ID, (String)concurrencyPolicyId));
        execSvcProps.put("ConcurrencyPolicy.cardinality.minimum", 1);
        String contextSvcFilter = FilterUtils.createPropertyFilter((String)ID, (String)contextServiceId);
        execSvcProps.put("ContextService.target", contextSvcFilter);
        execSvcProps.put("ContextService.cardinality.minimum", 1);
        execSvcProps.put("LongRunningPolicy.target", "(service.pid=unbound)");
        execSvcProps.put("LongRunningPolicy.cardinality.minimum", 0);
        StringBuilder managedExecutorSvcFilter = new StringBuilder(200);
        managedExecutorSvcFilter.append("(&").append(FilterUtils.createPropertyFilter((String)ID, (String)managedExecutorServiceID));
        managedExecutorSvcFilter.append("(component.name=com.ibm.ws.concurrent.internal.ManagedExecutorServiceImpl)(jndiName=*))");
        concurrencyPolicyProps.put(ID, concurrencyPolicyId);
        concurrencyPolicyProps.put(CONFIG_DISPLAY_ID, concurrencyPolicyId);
        concurrencyPolicyProps.put("expedite", 0);
        if (maxAsync != null) {
            if (maxAsync > 0) {
                concurrencyPolicyProps.put("max", maxAsync);
            } else if (maxAsync != -1) {
                throw new IllegalArgumentException(jndiName + " maxAsync=" + maxAsync);
            }
        }
        concurrencyPolicyProps.put("maxPolicy", "loose");
        concurrencyPolicyProps.put("maxWaitForEnqueue", 0L);
        concurrencyPolicyProps.put("runIfQueueFull", false);
        BundleContext concurrencyBundleCtx = ContextServiceDefinitionProvider.priv.getBundleContext(FrameworkUtil.getBundle(WSManagedExecutorService.class));
        BundleContext concurrencyPolicyBundleCtx = ContextServiceDefinitionProvider.priv.getBundleContext(FrameworkUtil.getBundle(ConcurrencyPolicy.class));
        AppDefinedResourceFactory factory = new AppDefinedResourceFactory(this, concurrencyBundleCtx, declaringApplication, managedExecutorServiceID, jndiName, managedExecutorSvcFilter.toString(), contextSvcJndiName, contextSvcFilter);
        try {
            String concurrencyBundleLocation = concurrencyBundleCtx.getBundle().getLocation();
            String concurrencyPolicyBundleLocation = concurrencyPolicyBundleCtx.getBundle().getLocation();
            ConfigurationAdmin configAdmin = (ConfigurationAdmin)this.configAdminRef.getService();
            Configuration concurrencyPolicyConfig = configAdmin.createFactoryConfiguration("com.ibm.ws.concurrency.policy.concurrencyPolicy", concurrencyPolicyBundleLocation);
            concurrencyPolicyConfig.update(concurrencyPolicyProps);
            Configuration managedExecutorSvcConfig = configAdmin.createFactoryConfiguration("com.ibm.ws.concurrent.managedExecutorService", concurrencyBundleLocation);
            managedExecutorSvcConfig.update(execSvcProps);
        }
        catch (Exception concurrencyBundleLocation) {
            void x;
            FFDCFilter.processException((Throwable)concurrencyBundleLocation, (String)"io.openliberty.concurrent.internal.processor.ManagedExecutorResourceFactoryBuilder", (String)"208", (Object)this, (Object[])new Object[]{props});
            factory.destroy();
            throw x;
        }
        catch (Error x) {
            FFDCFilter.processException((Throwable)x, (String)"io.openliberty.concurrent.internal.processor.ManagedExecutorResourceFactoryBuilder", (String)"211", (Object)this, (Object[])new Object[]{props});
            factory.destroy();
            throw x;
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createResourceFactory", (Object)factory);
        }
        return factory;
    }

    protected void deactivate(ComponentContext context) {
        this.configAdminRef.deactivate(context);
        this.variableRegistryRef.deactivate(context);
    }

    private static final String getManagedExecutorServiceID(String application, String module, String component, String jndiName) {
        StringBuilder sb = new StringBuilder(jndiName.length() + 80);
        if (application != null) {
            sb.append("application[").append(application).append("]/");
            if (module != null) {
                sb.append("module[").append(module).append("]/");
                if (component != null) {
                    sb.append("component[").append(component).append("]/");
                }
            }
        }
        return sb.append("managedExecutorService").append('[').append(jndiName).append(']').toString();
    }

    public final boolean removeExistingConfigurations(String filter) throws Exception {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        ConfigurationAdmin configAdmin = (ConfigurationAdmin)this.configAdminRef.getService();
        Configuration[] existingConfigurations = configAdmin.listConfigurations(filter);
        if (existingConfigurations != null) {
            for (Configuration config : existingConfigurations) {
                Dictionary cfgProps = config.getProperties();
                if (cfgProps != null && FILE.equals(cfgProps.get(CONFIG_SOURCE))) {
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"configuration found in server.xml: ", (Object[])new Object[]{config.getPid()});
                    }
                    return false;
                }
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"removing", (Object[])new Object[]{config.getPid()});
                }
                config.delete();
            }
        }
        return true;
    }

    @Reference(service=ConfigurationAdmin.class)
    protected void setConfigAdmin(ServiceReference<ConfigurationAdmin> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setConfigAdmin", (Object[])new Object[]{ref});
        }
        this.configAdminRef.setReference(ref);
    }

    protected void unsetConfigAdmin(ServiceReference<ConfigurationAdmin> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"unsetConfigAdmin", (Object[])new Object[]{ref});
        }
        this.configAdminRef.unsetReference(ref);
    }

    @Reference(service=VariableRegistry.class)
    protected void setVariableRegistry(ServiceReference<VariableRegistry> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setVariableRegistry", (Object[])new Object[]{ref});
        }
        this.variableRegistryRef.setReference(ref);
    }

    protected void unsetVariableRegistry(ServiceReference<VariableRegistry> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"unsetVariableRegistry", (Object[])new Object[]{ref});
        }
        this.variableRegistryRef.unsetReference(ref);
    }
}

