/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transport.sip.chfw;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sip.container.pmi.PerformanceMgr;
import com.ibm.ws.sip.parser.MessageParser;
import com.ibm.ws.sip.parser.StreamMessageParser;
import com.ibm.ws.sip.stack.context.MessageContext;
import com.ibm.ws.sip.stack.transaction.SIPTransactionStack;
import com.ibm.ws.sip.stack.transaction.transport.UseCompactHeaders;
import com.ibm.ws.sip.stack.transaction.transport.connections.SipMessageByteBuffer;
import com.ibm.ws.sip.stack.transport.GenericEndpointImpl;
import com.ibm.ws.sip.stack.transport.sip.chfw.BaseConnection;
import com.ibm.ws.sip.stack.transport.sip.chfw.SipInboundChannel;
import com.ibm.ws.sip.stack.util.StackTaskDurationMeasurer;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.channelfw.ConnectionLink;
import com.ibm.wsspi.channelfw.ConnectionReadyCallback;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.tcpchannel.TCPConnectionContext;
import com.ibm.wsspi.tcpchannel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcpchannel.TCPReadRequestContext;
import com.ibm.wsspi.tcpchannel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcpchannel.TCPWriteRequestContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;

public abstract class SipConnLink
extends BaseConnection
implements TCPReadCompletedCallback,
ConnectionLink {
    private static final TraceComponent tc = Tr.register(SipConnLink.class);
    private ConnectionLink m_linkOnDeviceSide = null;
    private ConnectionReadyCallback m_linkOnApplicationSide = null;
    private VirtualConnection m_vc = null;
    final LinkedList<MessageContext> m_outMessages = new LinkedList();
    private boolean m_sendPending = false;
    private MessageParser m_messageParser = new StreamMessageParser(this);
    private static final int READ_BUFFER_SIZE = 2048;
    private IOException m_readError = null;
    private boolean m_closing = false;
    private boolean m_broken = false;
    private static final int s_maxOutboundPendingMessages = SIPTransactionStack.instance().getConfiguration().getMaxOutboundPendingMessages();

    public SipConnLink(SipInboundChannel channel) {
        this(null, 0, channel);
    }

    public SipConnLink(String peerHost, int peerPort, SipInboundChannel channel) {
        super(peerHost, peerPort, channel);
    }

    private TCPConnectionContext getConnectionContext() {
        TCPConnectionContext connectionContext = (TCPConnectionContext)this.m_linkOnDeviceSide.getChannelAccessor();
        return connectionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void connectionEstablished() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"connectionEstablished", (Object[])new Object[0]);
        }
        this.logConnection();
        LinkedList<MessageContext> linkedList = this.m_outMessages;
        synchronized (linkedList) {
            super.connectionEstablished();
            this.sendPendingMessages();
        }
        TCPConnectionContext connectionContext = this.getConnectionContext();
        TCPReadRequestContext readCtx = connectionContext.getReadInterface();
        if (readCtx == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"connectionEstablished", (Object[])new Object[]{"no read context"});
            }
            return;
        }
        WsByteBuffer[] buffers = readCtx.getBuffers();
        if (buffers == null || buffers.length == 0) {
            WsByteBuffer buffer = GenericEndpointImpl.getBufferManager().allocate(2048);
            readCtx.setBuffer(buffer);
            VirtualConnection connection = readCtx.read(1L, (TCPReadCompletedCallback)this, true, -1);
            if (connection != null) {
                this.complete(connection, readCtx);
            }
        } else {
            this.complete(this.m_vc, readCtx);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"connectionEstablished", (Object[])new Object[]{"exit"});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(MessageContext messageContext, boolean considerMtu, UseCompactHeaders useCompactHeaders) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"connectionEstablished", (Object[])new Object[]{"entry [" + System.identityHashCode(messageContext) + ']'});
        }
        this.logConnection();
        this.prepareBuffer(messageContext, considerMtu, useCompactHeaders);
        try {
            LinkedList<MessageContext> linkedList = this.m_outMessages;
            synchronized (linkedList) {
                boolean empty;
                if (PerformanceMgr.getInstance().isTaskDurationOutboundQueuePMIEnabled() && messageContext != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"write", (Object[])new Object[]{"start measuring task duration"});
                    }
                    messageContext.setStackTaskDurationMeasurer(new StackTaskDurationMeasurer());
                    messageContext.getSipContainerQueueDuration().startMeasuring();
                }
                if (messageContext != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"write", (Object[])new Object[]{"update QueueMonitoring outbound queue statistics - task queued"});
                    }
                    PerformanceMgr.getInstance().updateQueueMonitoringTaskQueuedInOutboundQueue();
                }
                boolean bl = empty = !this.m_sendPending && this.m_outMessages.isEmpty();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"write", (Object[])new Object[]{"m_sendPending = " + this.m_sendPending + ", m_outMessages.isEmpty() = " + this.m_outMessages.isEmpty() + ", isConnected() = " + this.isConnected() + ", isClosed() = " + this.isClosed() + ", m_closing = " + this.m_closing});
                }
                if (empty && this.isConnected() && !this.m_closing) {
                    if (this.sendNow(messageContext)) {
                        messageContext.writeComplete();
                    }
                } else {
                    if (this.isClosed()) {
                        String exceptionMessage = "connection is closed: " + this + " could not send messsage: " + messageContext.getSipMessage();
                        throw new IOException(exceptionMessage);
                    }
                    if (this.m_closing) {
                        String exceptionMessage = "connection is closing: " + this + " could not send messsage: " + messageContext.getSipMessage();
                        throw new IOException(exceptionMessage);
                    }
                    if (s_maxOutboundPendingMessages > 0 && this.m_outMessages.size() >= s_maxOutboundPendingMessages) {
                        String exceptionMessage = "too many [" + this.m_outMessages.size() + "] outbound messages pending on [" + this + ']';
                        throw new IOException(exceptionMessage);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"write", (Object[])new Object[]{"adding messageContext = " + messageContext + "\n to m_outMessages"});
                    }
                    this.m_outMessages.addLast(messageContext);
                }
            }
        }
        catch (IOException e2) {
            this.connectionError(e2);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"write", (Object[])new Object[]{"exit [" + System.identityHashCode(messageContext) + ']'});
        }
    }

    private boolean sendNow(MessageContext messageContext) throws IOException {
        TCPWriteRequestContext writeCtx;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"sendNow", (Object[])new Object[]{"entry [" + System.identityHashCode(messageContext) + ']'});
        }
        if (PerformanceMgr.getInstance().isTaskDurationOutboundQueuePMIEnabled() && messageContext != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"sendNow", (Object[])new Object[]{"measure task duration"});
            }
            PerformanceMgr.getInstance().measureTaskDurationOutboundQueue(messageContext.getSipContainerQueueDuration().takeTimeMeasurement());
        }
        if (messageContext != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"sendNow", (Object[])new Object[]{"update QueueMonitoring outbound queue statistics - task dequeued"});
            }
            PerformanceMgr.getInstance().updateQueueMonitoringTaskDequeuedFromOutboundQueue();
        }
        SipMessageByteBuffer sipBuffer = messageContext.getSipMessageByteBuffer();
        messageContext.setSipMessageByteBuffer(null);
        WsByteBuffer buffer = SipConnLink.stackBufferToWsBuffer(sipBuffer);
        if (buffer == null) {
            throw new IOException("message is null in SipConnLink.sendNow");
        }
        TCPConnectionContext connectionContext = this.getConnectionContext();
        TCPWriteRequestContext tCPWriteRequestContext = writeCtx = connectionContext == null ? null : connectionContext.getWriteInterface();
        if (writeCtx == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"sendNow", (Object[])new Object[]{"Error: no write context"});
            }
            throw new IOException("Error: no write context");
        }
        writeCtx.setBuffer(buffer);
        messageContext.setWsByteBuffer(buffer);
        messageContext.setSipConnection(this);
        this.m_sendPending = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"sendNow", (Object[])new Object[]{"m_sendPending = " + this.m_sendPending});
        }
        VirtualConnection connection = writeCtx.write(-1L, (TCPWriteCompletedCallback)messageContext, false, -1);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"sendNow", (Object[])new Object[]{"exit [" + System.identityHashCode(messageContext) + ']'});
        }
        return connection != null;
    }

    @Override
    public MessageParser getMessageParser() {
        return this.m_messageParser;
    }

    public Object getChannelAccessor() {
        Object channelAccessor;
        ConnectionLink device = this.getDeviceLink();
        if (device == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Error in SipConnLink.getChannelAccessor - no device link", (Object[])new Object[0]);
            }
            channelAccessor = null;
        } else {
            channelAccessor = device.getChannelAccessor();
        }
        return channelAccessor;
    }

    public void close(VirtualConnection vc, Exception e2) {
        this.connectionError(e2);
    }

    public void destroy(Exception e2) {
        this.connectionError(e2);
    }

    public VirtualConnection getVirtualConnection() {
        return this.m_vc;
    }

    protected void setVirtualConnection(VirtualConnection vc) {
        this.m_vc = vc;
    }

    public ConnectionReadyCallback getApplicationCallback() {
        return this.m_linkOnApplicationSide;
    }

    public void setApplicationCallback(ConnectionReadyCallback next) {
        this.m_linkOnApplicationSide = next;
    }

    public ConnectionLink getDeviceLink() {
        return this.m_linkOnDeviceSide;
    }

    public void setDeviceLink(ConnectionLink deviceLink) {
        if (deviceLink == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"setDeviceLink", (Object[])new Object[]{"null conn link"});
            }
            return;
        }
        this.m_linkOnDeviceSide = deviceLink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeComplete(MessageContext messageContext) {
        WsByteBuffer oldBuffer;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"writeComplete", (Object[])new Object[]{"entry [" + System.identityHashCode(messageContext) + ']'});
        }
        if ((oldBuffer = messageContext.getWsByteBuffer()) != null) {
            messageContext.setWsByteBuffer(null);
            oldBuffer.release();
        }
        LinkedList<MessageContext> linkedList = this.m_outMessages;
        synchronized (linkedList) {
            this.m_sendPending = false;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"writeComplete", (Object[])new Object[]{"m_sendPending = " + this.m_sendPending});
            }
            if (this.m_readError == null) {
                this.sendPendingMessages();
            } else {
                IOException readError = this.m_readError;
                this.m_readError = null;
                this.connectionError(readError);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"writeComplete", (Object[])new Object[]{"exit"});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPendingMessages() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"sendPendingMessages", (Object[])new Object[0]);
        }
        this.logConnection();
        LinkedList<MessageContext> linkedList = this.m_outMessages;
        synchronized (linkedList) {
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"sendPendingMessages", (Object[])new Object[]{"m_sendPending = " + this.m_sendPending + "m_outMessages.isEmpty() = " + this.m_outMessages.isEmpty()});
                }
                while (!this.m_sendPending && !this.m_outMessages.isEmpty()) {
                    MessageContext messageSendingContext;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"sendPendingMessages", (Object[])new Object[]{"sending pending messages"});
                    }
                    if (!this.sendNow(messageSendingContext = this.m_outMessages.removeFirst())) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                        Tr.debug((TraceComponent)tc, (String)"sendPendingMessages", (Object[])new Object[]{"send will complete later"});
                        break;
                    }
                    messageSendingContext.writeComplete();
                }
                if (this.m_closing && !this.m_sendPending && this.m_outMessages.isEmpty()) {
                    this.close();
                }
            }
            catch (IOException e2) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"sendPendingMessages", (Object[])new Object[]{"IOException", e2});
                }
                this.connectionError(e2);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"sendPendingMessages", (Object[])new Object[0]);
        }
    }

    public void complete(VirtualConnection connection, TCPReadRequestContext readCtx) {
        do {
            for (WsByteBuffer buffer : readCtx.getBuffers()) {
                super.messageReceived(buffer);
                buffers[i] = buffer = GenericEndpointImpl.getBufferManager().allocate(2048);
            }
        } while (this.isConnected() && (connection = readCtx.read(1L, (TCPReadCompletedCallback)this, true, -1)) != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(VirtualConnection virtualConnection, TCPReadRequestContext readContext, IOException e2) {
        boolean empty;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"error", (Object[])new Object[]{"error received from TCP"});
        }
        LinkedList<MessageContext> linkedList = this.m_outMessages;
        synchronized (linkedList) {
            empty = this.m_outMessages.isEmpty();
        }
        if (empty) {
            this.connectionError(e2);
        } else {
            this.m_readError = e2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"close", (Object[])new Object[]{"[" + this + "] closed [" + this.isClosed() + "] closing [" + this.m_closing + "] broken [" + this.m_broken + ']'});
        }
        this.logConnection();
        if (this.isClosed()) {
            return;
        }
        if (!this.m_broken) {
            LinkedList<MessageContext> linkedList = this.m_outMessages;
            synchronized (linkedList) {
                if (this.m_sendPending || !this.m_outMessages.isEmpty()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"close", (Object[])new Object[]{"Waiting for outbound messages pending on [" + this + ']'});
                    }
                    this.m_closing = true;
                    return;
                }
            }
        }
        super.close();
        ConnectionLink device = this.m_linkOnDeviceSide;
        if (device != null) {
            device.close(this.m_vc, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionError(Exception e2) {
        ArrayList<MessageContext> pendingMessageContextList;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"connectionError", (Object[])new Object[0]);
        }
        this.logConnection();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"connectionError", (Object[])new Object[]{"error", e2});
        }
        this.m_broken = true;
        if (!this.isClosed()) {
            super.connectionError(e2);
        }
        LinkedList<MessageContext> linkedList = this.m_outMessages;
        synchronized (linkedList) {
            pendingMessageContextList = new ArrayList<MessageContext>(this.m_outMessages);
            this.m_outMessages.clear();
        }
        this.cleanPendingMessages(pendingMessageContextList, e2);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"connectionError", (Object[])new Object[0]);
        }
    }
}

