/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.common.cl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.ibm.oauth.core.api.error.OAuthException;
import com.ibm.oauth.core.api.error.oauth20.InvalidGrantException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.openidconnect.token.JWSHeader;
import com.ibm.ws.security.openidconnect.token.JWTPayload;
import com.ibm.ws.security.openidconnect.token.JsonTokenUtil;
import com.ibm.ws.security.openidconnect.token.WSJsonToken;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.keys.HmacKey;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JWTVerifier {
    private static final TraceComponent tc = Tr.register(JWTVerifier.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.common.internal.resources.OidcCommonMessages");
    String _tokenString = null;
    String _clientId = null;
    @Sensitive
    Object _key = null;
    long _lSkewSeconds = 0L;
    static final List<String> signAlgorithms = new ArrayList<String>();
    String _signAlgorithm = null;
    String[] _jwtParts = null;
    WSJsonToken _jsonToken = null;
    JWSHeader _header;
    JWTPayload _payload;
    static final long serialVersionUID = 2702933660206342049L;

    public JWTVerifier(String clientId, @Sensitive Object key, String signAlgorithm, String tokenString, long lSkewSeconds) throws InvalidGrantException {
        this._tokenString = tokenString;
        this._clientId = clientId;
        this._key = key;
        this._signAlgorithm = signAlgorithm;
        this._lSkewSeconds = lSkewSeconds;
        if (tokenString != null) {
            this._jwtParts = this.splitTokenString(tokenString);
        }
    }

    public JWTVerifier(String tokenString) throws InvalidGrantException {
        this._tokenString = tokenString;
        if (tokenString != null) {
            this._jwtParts = this.splitTokenString(tokenString);
        }
    }

    void initJsonToken() {
        this._jsonToken = JsonTokenUtil.deserialize((String[])this._jwtParts, (String)this._tokenString);
        this._payload = new JWTPayload();
        JsonTokenUtil.fromJsonToken((WSJsonToken)this._jsonToken, (JWTPayload)this._payload);
        this._header = new JWSHeader();
        JsonTokenUtil.fromJsonToken((WSJsonToken)this._jsonToken, (JWSHeader)this._header);
    }

    public JWSHeader getJwsHeader() {
        if (this._jsonToken == null) {
            this.initJsonToken();
        }
        return this._header;
    }

    public String getAlgHeader() {
        JWSHeader jwsHeader = this.getJwsHeader();
        return (String)jwsHeader.get((Object)"alg");
    }

    public JWTPayload getPayload() {
        if (this._jsonToken == null) {
            this.initJsonToken();
        }
        return this._payload;
    }

    public String getIssFromPayload() {
        JWTPayload payload = this.getPayload();
        return (String)payload.get((Object)"iss");
    }

    WSJsonToken getJsonToken() {
        if (this._jsonToken == null) {
            this.initJsonToken();
        }
        return this._jsonToken;
    }

    public boolean verifySignature() throws OAuthException {
        return this.verifySignature(this._lSkewSeconds);
    }

    @FFDCIgnore(value={InvalidJwtException.class})
    boolean verifySignature(long skewSeconds) throws OAuthException {
        String tmpAlg;
        if (this._jwtParts == null) {
            Tr.error((TraceComponent)tc, (String)"JWT_JWTTOKEN_NO_TOKEN_ERR", (Object[])new Object[0]);
            throw this.formatException("JWT_JWTTOKEN_NO_TOKEN_ERR", null, new Object[0]);
        }
        String jwtHeaderSegment = this._jwtParts[0];
        JsonParser simpleParser = new JsonParser();
        JsonObject header = simpleParser.parse(JsonTokenUtil.fromBase64ToJsonString((String)jwtHeaderSegment)).getAsJsonObject();
        JsonElement elmAlg = header.get("alg");
        String signAlgorithm = this._signAlgorithm;
        if (elmAlg != null && !(tmpAlg = elmAlg.getAsString()).equalsIgnoreCase(signAlgorithm)) {
            Tr.error((TraceComponent)tc, (String)"JWT_JWTTOKEN_SIGNATURE_VERIFY_ERR_ALG_MISMATCH", (Object[])new Object[]{this._clientId, tmpAlg, signAlgorithm});
            throw this.formatException("JWT_JWTTOKEN_SIGNATURE_VERIFY_ERR_ALG_MISMATCH", null, this._clientId, tmpAlg, signAlgorithm);
        }
        if (this._jwtParts.length <= 2) {
            Tr.error((TraceComponent)tc, (String)"JWT_JWTTOKEN_SIGNATURE_VERIFY_SEGMENT_ERR", (Object[])new Object[]{this._clientId, this._signAlgorithm});
            throw this.formatException("JWT_JWTTOKEN_SIGNATURE_VERIFY_SEGMENT_ERR", null, this._clientId, this._signAlgorithm);
        }
        try {
            Object theKey = null;
            if (this._key instanceof String) {
                try {
                    theKey = new HmacKey(((String)this._key).getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.security.openidconnect.common.cl.JWTVerifier", (String)"166", (Object)this, (Object[])new Object[]{skewSeconds});
                }
            } else if (this._key instanceof byte[]) {
                theKey = new HmacKey((byte[])this._key);
            } else if (this._key instanceof Key) {
                theKey = (Key)this._key;
            }
            JsonTokenUtil.validateTokenString((String)this._tokenString, (String)this._signAlgorithm, (Key)theKey, (long)this._lSkewSeconds, (boolean)false);
            this._payload = new JWTPayload();
            JsonTokenUtil.fromJsonToken((WSJsonToken)this.getJsonToken(), (JWTPayload)this._payload);
            this._header = new JWSHeader();
            JsonTokenUtil.fromJsonToken((WSJsonToken)this._jsonToken, (JWSHeader)this._header);
        }
        catch (InvalidJwtException e) {
            Object[] objs = new Object[]{this._clientId, e.getMessage() == null ? ((Object)((Object)e)).getClass().getSimpleName() : e.getMessage()};
            Tr.error((TraceComponent)tc, (String)"JWT_JWTTOKEN_ILLEGAL_STATE_ERR", (Object[])objs);
            throw this.formatException("JWT_JWTTOKEN_ILLEGAL_STATE_ERR", e, objs);
        }
        return true;
    }

    public String[] splitTokenString(String tokenString) throws InvalidGrantException {
        boolean isPlainTextJWT = false;
        if (tokenString.endsWith(".")) {
            isPlainTextJWT = true;
        }
        String[] pieces = tokenString.split(Pattern.quote("."));
        if (!isPlainTextJWT && pieces.length != 3) {
            Tr.error((TraceComponent)tc, (String)"JWT_JWTTOKEN_BAD_SEGMENTS_ERR", (Object[])new Object[]{(long)pieces.length});
            throw this.formatException("JWT_JWTTOKEN_BAD_SEGMENTS_ERR", null, pieces.length);
        }
        return pieces;
    }

    private InvalidGrantException formatException(String msgKey, Throwable cause, Object ... objs) {
        String message = Tr.formatMessage((TraceComponent)tc, (String)msgKey, (Object[])objs);
        return new InvalidGrantException(message, cause);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        signAlgorithms.add("RS256");
        signAlgorithms.add("HS256");
    }
}

