/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsat.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxws.wsat.Constants;
import com.ibm.ws.jaxws.wsat.components.WSATConfigService;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsat.service.Handler;
import com.ibm.ws.wsat.service.Protocol;
import com.ibm.ws.wsat.service.WSATContext;
import com.ibm.ws.wsat.utils.WSCoorConstants;
import com.ibm.ws.wsat.webservice.client.wscoor.CoordinationContext;
import com.ibm.ws.wsat.webservice.client.wscoor.CoordinationContextType;
import com.ibm.ws.wsat.webservice.client.wscoor.Expires;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import jakarta.xml.soap.SOAPBody;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPMessage;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.saaj.SAAJUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.jaxws.handler.soap.SOAPMessageContextImpl;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceModelUtil;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.policy.EffectivePolicy;
import org.apache.cxf.ws.policy.PolicyEngine;
import org.apache.neethi.All;
import org.apache.neethi.Assertion;
import org.apache.neethi.ExactlyOne;
import org.apache.neethi.PolicyComponent;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(name="com.ibm.ws.wsat.utils.CommonService", immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class WSCoorUtil {
    private static final TraceComponent tc = Tr.register(WSCoorUtil.class, (String)"WSAT");
    private static final String PROTOCOLSERVICE_REFERENCE_NAME = "protocol";
    private static final AtomicServiceReference<Protocol> protocolService = new AtomicServiceReference("protocol");
    private static final String WSATCONFIGSERVICE_REFERENCE_NAME = "config";
    private static final AtomicServiceReference<WSATConfigService> configService = new AtomicServiceReference("config");
    private static final String WSATHANDLERSERVICE_REFERENCE_NAME = "handler";
    private static final AtomicServiceReference<Handler> handlerService = new AtomicServiceReference("handler");
    static final long serialVersionUID = -6495352336009944609L;

    @Reference(name="protocol", service=Protocol.class)
    protected void setProtocolService(ServiceReference<Protocol> ref) {
        protocolService.setReference(ref);
    }

    protected void unsetProtocolService(ServiceReference<Protocol> ref) {
        protocolService.unsetReference(ref);
    }

    @Reference(name="config", service=WSATConfigService.class)
    protected void setConfigService(ServiceReference<WSATConfigService> ref) {
        configService.setReference(ref);
    }

    protected void unsetConfigService(ServiceReference<WSATConfigService> ref) {
        configService.unsetReference(ref);
    }

    @Reference(name="handler", service=Handler.class)
    protected void setHandlerService(ServiceReference<Handler> ref) {
        handlerService.setReference(ref);
    }

    protected void unsetHandlerService(ServiceReference<Handler> ref) {
        handlerService.unsetReference(ref);
    }

    @Activate
    protected void activate(ComponentContext cc, Map<String, Object> properties) {
        handlerService.activate(cc);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Handler service: ", (Object[])new Object[]{handlerService.getService()});
        }
        configService.activate(cc);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Config service: ", (Object[])new Object[]{configService.getService()});
        }
        protocolService.activate(cc);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Protocol service: ", (Object[])new Object[]{protocolService.getService()});
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        handlerService.deactivate(cc);
        configService.deactivate(cc);
        protocolService.deactivate(cc);
    }

    public static void checkHandlerServiceReady() {
        if (handlerService.getService() == null) {
            RuntimeException re = new RuntimeException("Handler service is not ready");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Handler service is not ready", (Object[])new Object[]{re});
            }
            throw re;
        }
    }

    public static WSATConfigService getConfigService() {
        return (WSATConfigService)configService.getService();
    }

    public static Protocol getProtocolService() {
        return (Protocol)protocolService.getService();
    }

    public static CoordinationContext createCoordinationContext(WSATContext ctx, EndpointReferenceType epr) {
        CoordinationContext cc = new CoordinationContext();
        Expires expires = new Expires();
        expires.setValue(ctx.getExpires());
        cc.setExpires(expires);
        cc.setCoordinationType("http://docs.oasis-open.org/ws-tx/wsat/2006/06");
        CoordinationContextType.Identifier id = new CoordinationContextType.Identifier();
        id.setValue(ctx.getId());
        cc.setIdentifier(id);
        cc.setRegistrationService(epr);
        return cc;
    }

    public static boolean assertAT(Message message) {
        boolean needFurtherCheck = true;
        AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
        Collection ais = null;
        if (aim != null && null != (ais = (Collection)aim.get((Object)Constants.AT_ASSERTION_QNAME)) && ais.size() != 0) {
            for (AssertionInfo ai : ais) {
                ai.setAsserted(true);
                needFurtherCheck = false;
            }
        }
        return needFurtherCheck;
    }

    private static Constants.AssertionStatus isOptionalAssertion(PolicyComponent pc) {
        Constants.AssertionStatus result;
        block8: {
            block7: {
                result = Constants.AssertionStatus.NULL;
                if (!(pc instanceof ExactlyOne)) break block7;
                List components = ((ExactlyOne)pc).getPolicyComponents();
                if (components == null || components.isEmpty()) break block8;
                boolean wsatPolicy = false;
                boolean isOptional = false;
                for (PolicyComponent p : components) {
                    Constants.AssertionStatus result2 = WSCoorUtil.isOptionalAssertion(p);
                    if (result2 == Constants.AssertionStatus.FALSE) {
                        wsatPolicy = true;
                        continue;
                    }
                    if (result2 != Constants.AssertionStatus.TRUE) continue;
                    isOptional = true;
                }
                if (wsatPolicy) {
                    result = isOptional ? Constants.AssertionStatus.TRUE : Constants.AssertionStatus.FALSE;
                }
                break block8;
            }
            if (pc instanceof All) {
                List assertions = ((All)pc).getAssertions();
                if (assertions == null || assertions.isEmpty()) {
                    result = Constants.AssertionStatus.TRUE;
                } else {
                    for (PolicyComponent p : assertions) {
                        if (!(p instanceof Assertion) || !((Assertion)p).getName().equals(Constants.AT_ASSERTION_QNAME)) continue;
                        result = Constants.AssertionStatus.FALSE;
                        break;
                    }
                }
            }
        }
        return result;
    }

    public static Constants.AssertionStatus isOptional(Message msg, boolean isServer) {
        Constants.AssertionStatus result;
        block8: {
            PolicyComponent pc;
            List pList;
            result = Constants.AssertionStatus.NULL;
            Exchange ex = msg.getExchange();
            Bus bus = (Bus)ex.get(Bus.class);
            Endpoint e = (Endpoint)ex.get(Endpoint.class);
            if (null == e) {
                return result;
            }
            EndpointInfo ei = e.getEndpointInfo();
            PolicyEngine pe = (PolicyEngine)bus.getExtension(PolicyEngine.class);
            EffectivePolicy ep = null;
            if (isServer) {
                WSCoorUtil.setupBindingOperationInfo((SoapMessage)msg);
                BindingOperationInfo boi = ex.getBindingOperationInfo();
                if (boi == null) {
                    boi = WSCoorUtil.getBindingOperationForInvoke(ex);
                }
                if (boi != null) {
                    ep = pe.getEffectiveServerRequestPolicy(ei, boi, msg);
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"isOptional", (Object[])new Object[]{"Could not determine BindingOperationInfo"});
                }
            } else {
                Conduit conduit = ex.getConduit(msg);
                BindingOperationInfo boi = ex.getBindingOperationInfo();
                ep = pe.getEffectiveClientRequestPolicy(ei, boi, conduit, msg);
            }
            if (ep == null || (pList = ep.getPolicy().getPolicyComponents()) == null || pList.isEmpty()) break block8;
            Iterator iterator = pList.iterator();
            while (iterator.hasNext() && (result = WSCoorUtil.isOptionalAssertion(pc = (PolicyComponent)iterator.next())) == Constants.AssertionStatus.NULL) {
            }
        }
        return result;
    }

    @ManualTrace
    private static BindingOperationInfo getBindingOperationForInvoke(Exchange ex) {
        BindingOperationInfo boi;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getBindingOperationForInvoke", (Object[])new Object[]{ex != null});
        }
        if ((boi = ServiceModelUtil.getOperationForWrapperElement((Exchange)ex, (QName)new QName("http://cxf.apache.org/jaxws/provider", "invoke"), (boolean)false)) == null) {
            boi = ServiceModelUtil.getOperation((Exchange)ex, (String)"invoke");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getBindingOperationForInvoke", (Object)boi);
        }
        return boi;
    }

    public static AssertionInfo checkWSATAssertion(SoapMessage message) {
        Iterator iterator;
        Collection ais;
        AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"checkWSATAssertion", (Object[])new Object[]{"Checking if there's any ATAssertion present in the AssertionInfoMap", aim});
        }
        if (aim != null && (ais = (Collection)aim.get((Object)WSCoorConstants.AT_ASSERTION_QNAME)) != null && (iterator = ais.iterator()).hasNext()) {
            AssertionInfo a = (AssertionInfo)iterator.next();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"checkWSATAssertion", (Object[])new Object[]{"Get one ATAssertion in the AssertionInfoMap", a});
            }
            return a;
        }
        return null;
    }

    private static void setupBindingOperationInfo(SoapMessage message) {
        Exchange exch = message.getExchange();
        if (exch.get(BindingOperationInfo.class) == null) {
            QName opName = WSCoorUtil.getOpQName(message);
            if (opName == null) {
                return;
            }
            BindingOperationInfo bop = ServiceModelUtil.getOperationForWrapperElement((Exchange)exch, (QName)opName, (boolean)false);
            if (bop == null) {
                bop = ServiceModelUtil.getOperation((Exchange)exch, (QName)opName);
            }
            if (bop != null) {
                exch.put(BindingOperationInfo.class, (Object)bop);
                exch.put(OperationInfo.class, (Object)bop.getOperationInfo());
                if (bop.getOutput() == null) {
                    exch.setOneWay(true);
                }
            }
        }
    }

    private static QName getOpQName(SoapMessage message) {
        SOAPMessageContextImpl sm = new SOAPMessageContextImpl((Message)message);
        try {
            Node nd;
            SOAPMessage msg = sm.getMessage();
            if (msg == null) {
                return null;
            }
            SOAPBody body = SAAJUtils.getBody((SOAPMessage)msg);
            if (body == null) {
                return null;
            }
            for (nd = body.getFirstChild(); nd != null && !(nd instanceof Element); nd = nd.getNextSibling()) {
            }
            if (nd != null) {
                return new QName(nd.getNamespaceURI(), nd.getLocalName());
            }
            Collection boi = message.getExchange().getEndpoint().getEndpointInfo().getBinding().getOperations();
            if (boi.size() > 0) {
                return ((BindingOperationInfo)boi.iterator().next()).getName();
            }
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, (String)"com.ibm.ws.wsat.utils.WSCoorUtil", (String)"366", null, (Object[])new Object[]{message});
        }
        return null;
    }

    public static Handler getHandlerService() {
        return (Handler)handlerService.getService();
    }
}

