/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.security.AccessController;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import javax.json.bind.JsonbException;
import javax.json.bind.annotation.JsonbDateFormat;
import javax.json.bind.annotation.JsonbNillable;
import javax.json.bind.annotation.JsonbNumberFormat;
import javax.json.bind.annotation.JsonbProperty;
import javax.json.bind.annotation.JsonbPropertyOrder;
import javax.json.bind.annotation.JsonbTransient;
import javax.json.bind.annotation.JsonbTypeAdapter;
import javax.json.bind.annotation.JsonbTypeDeserializer;
import javax.json.bind.annotation.JsonbTypeSerializer;
import javax.json.bind.annotation.JsonbVisibility;
import javax.json.bind.config.PropertyVisibilityStrategy;
import org.eclipse.yasson.ImplementationClass;
import org.eclipse.yasson.internal.AnnotationFinder;
import org.eclipse.yasson.internal.ClassMultiReleaseExtension;
import org.eclipse.yasson.internal.ConstructorPropertiesAnnotationIntrospector;
import org.eclipse.yasson.internal.JsonbContext;
import org.eclipse.yasson.internal.ReflectionUtils;
import org.eclipse.yasson.internal.components.AdapterBinding;
import org.eclipse.yasson.internal.components.DeserializerBinding;
import org.eclipse.yasson.internal.components.SerializerBinding;
import org.eclipse.yasson.internal.model.AnnotationTarget;
import org.eclipse.yasson.internal.model.CreatorModel;
import org.eclipse.yasson.internal.model.JsonbAnnotatedElement;
import org.eclipse.yasson.internal.model.JsonbCreator;
import org.eclipse.yasson.internal.model.Property;
import org.eclipse.yasson.internal.model.customization.ClassCustomization;
import org.eclipse.yasson.internal.model.customization.ClassCustomizationBuilder;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;
import org.eclipse.yasson.internal.serializer.DefaultSerializers;
import org.eclipse.yasson.internal.serializer.JsonbDateFormatter;
import org.eclipse.yasson.internal.serializer.JsonbNumberFormatter;

public class AnnotationIntrospector {
    private final JsonbContext jsonbContext;
    private final ConstructorPropertiesAnnotationIntrospector constructorPropertiesIntrospector;
    public static final List<Class<? extends Annotation>> TRANSIENT_INCOMPATIBLE = Arrays.asList(JsonbDateFormat.class, JsonbNumberFormat.class, JsonbProperty.class, JsonbTypeAdapter.class, JsonbTypeSerializer.class, JsonbTypeDeserializer.class);

    public AnnotationIntrospector(JsonbContext jsonbContext) {
        Objects.requireNonNull(jsonbContext);
        this.jsonbContext = jsonbContext;
        this.constructorPropertiesIntrospector = ConstructorPropertiesAnnotationIntrospector.forContext(jsonbContext);
    }

    public String getJsonbPropertyJsonWriteName(Property property) {
        Objects.requireNonNull(property);
        return this.getJsonbPropertyCustomizedName(property, property.getGetterElement());
    }

    public String getJsonbPropertyJsonReadName(Property property) {
        Objects.requireNonNull(property);
        return this.getJsonbPropertyCustomizedName(property, property.getSetterElement());
    }

    private String getJsonbPropertyCustomizedName(Property property, JsonbAnnotatedElement<Method> methodElement) {
        JsonbProperty methodAnnotation = this.getMethodAnnotation(JsonbProperty.class, methodElement);
        if (methodAnnotation != null && !methodAnnotation.value().isEmpty()) {
            return methodAnnotation.value();
        }
        JsonbProperty fieldAnnotation = this.getFieldAnnotation(JsonbProperty.class, property.getFieldElement());
        if (fieldAnnotation != null && !fieldAnnotation.value().isEmpty()) {
            return fieldAnnotation.value();
        }
        return null;
    }

    public JsonbCreator getCreator(Class<?> clazz) {
        Method[] declaredMethods;
        Constructor[] declaredConstructors;
        JsonbCreator jsonbCreator = null;
        for (Constructor constructor : declaredConstructors = AccessController.doPrivileged(clazz::getDeclaredConstructors)) {
            javax.json.bind.annotation.JsonbCreator annot = this.findAnnotation(constructor.getDeclaredAnnotations(), javax.json.bind.annotation.JsonbCreator.class);
            if (annot == null) continue;
            jsonbCreator = this.createJsonbCreator(constructor, jsonbCreator, clazz);
        }
        for (Method method : declaredMethods = AccessController.doPrivileged(clazz::getDeclaredMethods)) {
            javax.json.bind.annotation.JsonbCreator annot = this.findAnnotation(method.getDeclaredAnnotations(), javax.json.bind.annotation.JsonbCreator.class);
            if (annot == null || !Modifier.isStatic(method.getModifiers())) continue;
            if (!clazz.equals(method.getReturnType())) {
                throw new JsonbException(Messages.getMessage(MessageKeys.INCOMPATIBLE_FACTORY_CREATOR_RETURN_TYPE, method, clazz));
            }
            jsonbCreator = this.createJsonbCreator(method, jsonbCreator, clazz);
        }
        if (jsonbCreator == null && (jsonbCreator = ClassMultiReleaseExtension.findCreator(clazz, declaredConstructors, this)) == null) {
            jsonbCreator = this.constructorPropertiesIntrospector.getCreator(declaredConstructors);
        }
        return jsonbCreator;
    }

    JsonbCreator createJsonbCreator(Executable executable, JsonbCreator existing, Class<?> clazz) {
        if (existing != null) {
            throw new JsonbException(Messages.getMessage(MessageKeys.MULTIPLE_JSONB_CREATORS, clazz));
        }
        Parameter[] parameters = executable.getParameters();
        CreatorModel[] creatorModels = new CreatorModel[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            JsonbProperty jsonbPropertyAnnotation = parameter.getAnnotation(JsonbProperty.class);
            creatorModels[i] = jsonbPropertyAnnotation != null && !jsonbPropertyAnnotation.value().isEmpty() ? new CreatorModel(jsonbPropertyAnnotation.value(), parameter, this.jsonbContext) : new CreatorModel(parameter.getName(), parameter, this.jsonbContext);
        }
        return new JsonbCreator(executable, creatorModels);
    }

    public AdapterBinding getAdapterBinding(Property property) {
        Objects.requireNonNull(property);
        JsonbTypeAdapter adapterAnnotation = this.getAnnotationFromProperty(JsonbTypeAdapter.class, property).orElseGet(() -> this.getAnnotationFromPropertyType(property, JsonbTypeAdapter.class));
        if (adapterAnnotation == null) {
            return null;
        }
        return this.getAdapterBindingFromAnnotation(adapterAnnotation, ReflectionUtils.getOptionalRawType(property.getPropertyType()));
    }

    public AdapterBinding getAdapterBinding(JsonbAnnotatedElement<Class<?>> clsElement) {
        Objects.requireNonNull(clsElement);
        JsonbTypeAdapter adapterAnnotation = clsElement.getElement().getAnnotation(JsonbTypeAdapter.class);
        if (adapterAnnotation == null) {
            return null;
        }
        return this.getAdapterBindingFromAnnotation(adapterAnnotation, Optional.ofNullable(clsElement.getElement()));
    }

    private AdapterBinding getAdapterBindingFromAnnotation(JsonbTypeAdapter adapterAnnotation, Optional<Class<?>> expectedClass) {
        Class adapterClass = adapterAnnotation.value();
        AdapterBinding adapterBinding = this.jsonbContext.getComponentMatcher().introspectAdapterBinding(adapterClass, null);
        if (expectedClass.isPresent() && !ReflectionUtils.getRawType(adapterBinding.getBindingType()).isAssignableFrom(expectedClass.get())) {
            throw new JsonbException(Messages.getMessage(MessageKeys.ADAPTER_INCOMPATIBLE, adapterBinding.getBindingType(), expectedClass.get()));
        }
        return adapterBinding;
    }

    public DeserializerBinding getDeserializerBinding(Property property) {
        Objects.requireNonNull(property);
        JsonbTypeDeserializer deserializerAnnotation = this.getAnnotationFromProperty(JsonbTypeDeserializer.class, property).orElseGet(() -> this.getAnnotationFromPropertyType(property, JsonbTypeDeserializer.class));
        if (deserializerAnnotation == null) {
            return null;
        }
        Class deserializerClass = deserializerAnnotation.value();
        return this.jsonbContext.getComponentMatcher().introspectDeserializerBinding(deserializerClass, null);
    }

    public DeserializerBinding getDeserializerBinding(JsonbAnnotatedElement<Class<?>> clsElement) {
        Objects.requireNonNull(clsElement);
        JsonbTypeDeserializer deserializerAnnotation = clsElement.getElement().getAnnotation(JsonbTypeDeserializer.class);
        if (deserializerAnnotation == null) {
            return null;
        }
        Class deserializerClass = deserializerAnnotation.value();
        return this.jsonbContext.getComponentMatcher().introspectDeserializerBinding(deserializerClass, null);
    }

    public SerializerBinding getSerializerBinding(Property property) {
        Objects.requireNonNull(property);
        JsonbTypeSerializer serializerAnnotation = this.getAnnotationFromProperty(JsonbTypeSerializer.class, property).orElseGet(() -> this.getAnnotationFromPropertyType(property, JsonbTypeSerializer.class));
        if (serializerAnnotation == null) {
            return null;
        }
        Class serializerClass = serializerAnnotation.value();
        return this.jsonbContext.getComponentMatcher().introspectSerializerBinding(serializerClass, null);
    }

    public SerializerBinding getSerializerBinding(JsonbAnnotatedElement<Class<?>> clsElement) {
        Objects.requireNonNull(clsElement);
        JsonbTypeSerializer serializerAnnotation = clsElement.getElement().getAnnotation(JsonbTypeSerializer.class);
        if (serializerAnnotation == null) {
            return null;
        }
        Class serializerClass = serializerAnnotation.value();
        return this.jsonbContext.getComponentMatcher().introspectSerializerBinding(serializerClass, null);
    }

    private <T extends Annotation> T getAnnotationFromPropertyType(Property property, Class<T> annotationClass) {
        Optional<Class<?>> optionalRawType = ReflectionUtils.getOptionalRawType(property.getPropertyType());
        if (!optionalRawType.isPresent()) {
            return null;
        }
        return this.findAnnotation(this.collectAnnotations(optionalRawType.get()).getAnnotations(), annotationClass);
    }

    public Optional<Boolean> isPropertyNillable(Property property) {
        Objects.requireNonNull(property);
        Optional<JsonbProperty> jsonbProperty = this.getAnnotationFromProperty(JsonbProperty.class, property);
        return jsonbProperty.map(JsonbProperty::nillable);
    }

    public boolean isClassNillable(JsonbAnnotatedElement<Class<?>> clazzElement) {
        JsonbNillable jsonbNillable = this.findAnnotation(clazzElement.getAnnotations(), JsonbNillable.class);
        if (jsonbNillable != null) {
            return jsonbNillable.value();
        }
        Class<?> clazz = clazzElement.getElement();
        if (clazz == Optional.class || clazz == OptionalDouble.class || clazz == OptionalInt.class || clazz == OptionalLong.class) {
            return true;
        }
        return this.jsonbContext.getConfigProperties().getConfigNullable();
    }

    public String[] getPropertyOrder(JsonbAnnotatedElement<Class<?>> clazzElement) {
        JsonbPropertyOrder jsonbPropertyOrder = clazzElement.getElement().getAnnotation(JsonbPropertyOrder.class);
        return jsonbPropertyOrder != null ? jsonbPropertyOrder.value() : null;
    }

    public EnumSet<AnnotationTarget> getJsonbTransientCategorized(Property property) {
        Objects.requireNonNull(property);
        EnumSet<AnnotationTarget> transientTarget = EnumSet.noneOf(AnnotationTarget.class);
        Map<AnnotationTarget, JsonbTransient> annotationFromPropertyCategorized = this.getAnnotationFromPropertyCategorized(JsonbTransient.class, property);
        if (annotationFromPropertyCategorized.size() > 0) {
            transientTarget.addAll(annotationFromPropertyCategorized.keySet());
            return transientTarget;
        }
        return transientTarget;
    }

    public Map<AnnotationTarget, JsonbDateFormatter> getJsonbDateFormatCategorized(Property property) {
        Class<?> rawType;
        Optional<Class<?>> propertyRawTypeOptional;
        Objects.requireNonNull(property);
        HashMap<AnnotationTarget, JsonbDateFormatter> result = new HashMap<AnnotationTarget, JsonbDateFormatter>();
        Map<AnnotationTarget, JsonbDateFormat> annotationFromPropertyCategorized = this.getAnnotationFromPropertyCategorized(JsonbDateFormat.class, property);
        if (annotationFromPropertyCategorized.size() != 0) {
            annotationFromPropertyCategorized.forEach((key, annotation) -> result.put((AnnotationTarget)((Object)key), this.createJsonbDateFormatter(annotation.value(), annotation.locale(), property)));
        }
        if ((propertyRawTypeOptional = ReflectionUtils.getOptionalRawType(property.getPropertyType())).isPresent() && !Date.class.isAssignableFrom(rawType = propertyRawTypeOptional.get()) && !Calendar.class.isAssignableFrom(rawType) && !TemporalAccessor.class.isAssignableFrom(rawType)) {
            return new HashMap<AnnotationTarget, JsonbDateFormatter>();
        }
        JsonbDateFormat classLevelDateFormatter = this.findAnnotation(property.getDeclaringClassElement().getAnnotations(), JsonbDateFormat.class);
        if (classLevelDateFormatter != null) {
            result.put(AnnotationTarget.CLASS, this.createJsonbDateFormatter(classLevelDateFormatter.value(), classLevelDateFormatter.locale(), property));
        }
        return result;
    }

    public JsonbDateFormatter getJsonbDateFormat(JsonbAnnotatedElement<Class<?>> clazzElement) {
        Objects.requireNonNull(clazzElement);
        JsonbDateFormat format = this.findAnnotation(clazzElement.getAnnotations(), JsonbDateFormat.class);
        if (format == null) {
            return this.jsonbContext.getConfigProperties().getConfigDateFormatter();
        }
        return new JsonbDateFormatter(format.value(), format.locale());
    }

    public JsonbNumberFormatter getJsonbNumberFormat(JsonbAnnotatedElement<Class<?>> clazzElement) {
        JsonbNumberFormat formatAnnotation = this.findAnnotation(clazzElement.getAnnotations(), JsonbNumberFormat.class);
        if (formatAnnotation == null) {
            return null;
        }
        return new JsonbNumberFormatter(formatAnnotation.value(), formatAnnotation.locale());
    }

    public Map<AnnotationTarget, JsonbNumberFormatter> getJsonNumberFormatter(Property property) {
        HashMap<AnnotationTarget, JsonbNumberFormatter> result = new HashMap<AnnotationTarget, JsonbNumberFormatter>();
        Map<AnnotationTarget, JsonbNumberFormat> annotationFromPropertyCategorized = this.getAnnotationFromPropertyCategorized(JsonbNumberFormat.class, property);
        if (annotationFromPropertyCategorized.size() == 0) {
            Class<?> rawType;
            Optional<Class<?>> propertyRawTypeOptional = ReflectionUtils.getOptionalRawType(property.getPropertyType());
            if (propertyRawTypeOptional.isPresent() && !Number.class.isAssignableFrom(rawType = propertyRawTypeOptional.get())) {
                return new HashMap<AnnotationTarget, JsonbNumberFormatter>();
            }
        } else {
            annotationFromPropertyCategorized.forEach((key, annotation) -> result.put((AnnotationTarget)((Object)key), new JsonbNumberFormatter(annotation.value(), annotation.locale())));
        }
        JsonbNumberFormat classLevelNumberFormatter = this.findAnnotation(property.getDeclaringClassElement().getAnnotations(), JsonbNumberFormat.class);
        if (classLevelNumberFormatter != null) {
            result.put(AnnotationTarget.CLASS, new JsonbNumberFormatter(classLevelNumberFormatter.value(), classLevelNumberFormatter.locale()));
        }
        return result;
    }

    public JsonbNumberFormatter getConstructorNumberFormatter(JsonbAnnotatedElement<Parameter> param) {
        JsonbNumberFormat annotation = param.getAnnotation(JsonbNumberFormat.class);
        if (annotation != null) {
            return new JsonbNumberFormatter(annotation.value(), annotation.locale());
        }
        return null;
    }

    public JsonbDateFormatter getConstructorDateFormatter(JsonbAnnotatedElement<Parameter> param) {
        JsonbDateFormat annotation = param.getAnnotation(JsonbDateFormat.class);
        if (annotation != null) {
            return new JsonbDateFormatter(DateTimeFormatter.ofPattern(annotation.value(), Locale.forLanguageTag(annotation.locale())), annotation.value(), annotation.locale());
        }
        return null;
    }

    private JsonbDateFormatter createJsonbDateFormatter(String format, String locale, Property property) {
        if ("##time-in-millis".equals(format) || "##default".equals(format)) {
            return new JsonbDateFormatter(format, locale);
        }
        Optional<Class<?>> optionalRawType = ReflectionUtils.getOptionalRawType(property.getPropertyType());
        Class propertyRawType = optionalRawType.orElse(null);
        if (!(propertyRawType == null || TemporalAccessor.class.isAssignableFrom(propertyRawType) || Date.class.isAssignableFrom(propertyRawType) || Calendar.class.isAssignableFrom(propertyRawType))) {
            throw new IllegalStateException(Messages.getMessage(MessageKeys.UNSUPPORTED_DATE_TYPE, propertyRawType));
        }
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
        builder.appendPattern(format);
        if (this.jsonbContext.getConfigProperties().isZeroTimeDefaulting()) {
            builder.parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L);
            builder.parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L);
            builder.parseDefaulting(ChronoField.HOUR_OF_DAY, 0L);
        }
        DateTimeFormatter dateTimeFormatter = builder.toFormatter(Locale.forLanguageTag(locale));
        return new JsonbDateFormatter(dateTimeFormatter, format, locale);
    }

    public PropertyVisibilityStrategy getPropertyVisibilityStrategy(Class<?> clazz) {
        JsonbVisibility visibilityAnnotation = this.findAnnotation(clazz.getDeclaredAnnotations(), JsonbVisibility.class);
        if (visibilityAnnotation == null && clazz.getPackage() != null) {
            visibilityAnnotation = this.findAnnotation(clazz.getPackage().getDeclaredAnnotations(), JsonbVisibility.class);
        }
        if (visibilityAnnotation != null) {
            return (PropertyVisibilityStrategy)ReflectionUtils.createNoArgConstructorInstance(ReflectionUtils.getDefaultConstructor(visibilityAnnotation.value(), true));
        }
        return this.jsonbContext.getConfigProperties().getPropertyVisibilityStrategy();
    }

    private <T extends Annotation> Optional<T> getAnnotationFromProperty(Class<T> annotationClass, Property property) {
        T fieldAnnotation = this.getFieldAnnotation(annotationClass, property.getFieldElement());
        if (fieldAnnotation != null) {
            return Optional.of(fieldAnnotation);
        }
        T getterAnnotation = this.getMethodAnnotation(annotationClass, property.getGetterElement());
        if (getterAnnotation != null) {
            return Optional.of(getterAnnotation);
        }
        T setterAnnotation = this.getMethodAnnotation(annotationClass, property.getSetterElement());
        if (setterAnnotation != null) {
            return Optional.of(setterAnnotation);
        }
        return Optional.empty();
    }

    private <T extends Annotation> Map<AnnotationTarget, T> getAnnotationFromPropertyCategorized(Class<T> annotationClass, Property property) {
        T setterAnnotation;
        T getterAnnotation;
        HashMap<AnnotationTarget, T> result = new HashMap<AnnotationTarget, T>();
        T fieldAnnotation = this.getFieldAnnotation(annotationClass, property.getFieldElement());
        if (fieldAnnotation != null) {
            result.put(AnnotationTarget.PROPERTY, fieldAnnotation);
        }
        if ((getterAnnotation = this.getMethodAnnotation(annotationClass, property.getGetterElement())) != null) {
            result.put(AnnotationTarget.GETTER, getterAnnotation);
        }
        if ((setterAnnotation = this.getMethodAnnotation(annotationClass, property.getSetterElement())) != null) {
            result.put(AnnotationTarget.SETTER, setterAnnotation);
        }
        return result;
    }

    private <T extends Annotation> T getFieldAnnotation(Class<T> annotationClass, JsonbAnnotatedElement<Field> fieldElement) {
        if (fieldElement == null) {
            return null;
        }
        return this.findAnnotation(fieldElement.getAnnotations(), annotationClass);
    }

    private <T extends Annotation> T findAnnotation(Annotation[] declaredAnnotations, Class<T> annotationClass) {
        return AnnotationFinder.findAnnotation(declaredAnnotations, annotationClass, new HashSet<Annotation>());
    }

    public void checkTransientIncompatible(JsonbAnnotatedElement<?> target) {
        if (target == null) {
            return;
        }
        for (Class<? extends Annotation> ann : TRANSIENT_INCOMPATIBLE) {
            Annotation annotation = this.findAnnotation(target.getAnnotations(), ann);
            if (annotation == null) continue;
            throw new JsonbException(Messages.getMessage(MessageKeys.JSONB_TRANSIENT_WITH_OTHER_ANNOTATIONS, new Object[0]));
        }
    }

    private <T extends Annotation> T getMethodAnnotation(Class<T> annotationClass, JsonbAnnotatedElement<Method> methodElement) {
        if (methodElement == null) {
            return null;
        }
        return this.findAnnotation(methodElement.getAnnotations(), annotationClass);
    }

    private <T extends Annotation> void collectFromInterfaces(Class<T> annotationClass, Class clazz, Map<Class<?>, T> collectedAnnotations) {
        for (Class<?> interfaceClass : clazz.getInterfaces()) {
            T annotation = this.findAnnotation(interfaceClass.getDeclaredAnnotations(), annotationClass);
            if (annotation != null) {
                collectedAnnotations.put(interfaceClass, annotation);
            }
            this.collectFromInterfaces(annotationClass, interfaceClass, collectedAnnotations);
        }
    }

    public Set<Class<?>> collectInterfaces(Class<?> cls) {
        Class nextIfc;
        LinkedHashSet collected = new LinkedHashSet();
        LinkedList toScan = new LinkedList();
        toScan.addAll(Arrays.asList(cls.getInterfaces()));
        while ((nextIfc = (Class)toScan.poll()) != null) {
            collected.add(nextIfc);
            toScan.addAll(Arrays.asList(nextIfc.getInterfaces()));
        }
        return collected;
    }

    public ClassCustomization introspectCustomization(JsonbAnnotatedElement<Class<?>> clsElement) {
        ClassCustomizationBuilder builder = new ClassCustomizationBuilder();
        builder.setNillable(this.isClassNillable(clsElement));
        builder.setDateFormatter(this.getJsonbDateFormat(clsElement));
        builder.setNumberFormatter(this.getJsonbNumberFormat(clsElement));
        builder.setCreator(this.getCreator(clsElement.getElement()));
        builder.setPropertyOrder(this.getPropertyOrder(clsElement));
        builder.setAdapterInfo(this.getAdapterBinding(clsElement));
        builder.setSerializerBinding(this.getSerializerBinding(clsElement));
        builder.setDeserializerBinding(this.getDeserializerBinding(clsElement));
        builder.setPropertyVisibilityStrategy(this.getPropertyVisibilityStrategy(clsElement.getElement()));
        return builder.buildClassCustomization();
    }

    public Class<?> getImplementationClass(Property property) {
        Optional<ImplementationClass> annotationFromProperty = this.getAnnotationFromProperty(ImplementationClass.class, property);
        return annotationFromProperty.map(ImplementationClass::value).orElse(null);
    }

    public JsonbAnnotatedElement<Class<?>> collectAnnotations(Class<?> clazz) {
        JsonbAnnotatedElement classElement = new JsonbAnnotatedElement(clazz);
        if (DefaultSerializers.getInstance().isKnownType(clazz)) {
            return classElement;
        }
        for (Class<?> ifc : this.collectInterfaces(clazz)) {
            this.addIfNotPresent(classElement, ifc.getDeclaredAnnotations());
        }
        if (!clazz.isPrimitive() && !clazz.isArray() && clazz.getPackage() != null) {
            this.addIfNotPresent(classElement, clazz.getPackage().getAnnotations());
        }
        return classElement;
    }

    private void addIfNotPresent(JsonbAnnotatedElement<?> element, Annotation ... annotations) {
        for (Annotation annotation : annotations) {
            if (element.getAnnotation(annotation.annotationType()) != null) continue;
            element.putAnnotation(annotation);
        }
    }
}

