/*
 * Decompiled with CFR 0.152.
 */
package wlp.lib.extract;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.ResourceBundle;
import wlp.lib.extract.SelfExtract;

public class ReturnCode {
    public static final ReturnCode OK = new ReturnCode(0);
    public static final int OK_INT = 0;
    public static final int NOT_FOUND = 1;
    public static final int UNREADABLE = 2;
    public static final int BAD_INPUT = 3;
    public static final int BAD_OUTPUT = 4;
    public static final int NOT_APPLICABLE_FEATURE = 5;
    private final int code;
    private final String msgKey;
    private final Object[] params;
    private ResourceBundle resourceBundle = null;

    public ReturnCode(int code, String msgKey, Object ... params) {
        this.code = code;
        this.msgKey = msgKey;
        this.params = params;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.code;
        result = 31 * result + (this.msgKey == null ? 0 : this.msgKey.hashCode());
        return result;
    }

    public ReturnCode(int code) {
        this(code, null, (Object[])null);
    }

    public ReturnCode(int code, String msgKey, String params) {
        this(code, msgKey, new Object[]{params});
    }

    public int getCode() {
        return this.code;
    }

    public synchronized String getErrorMessage() {
        if (this.msgKey == null) {
            return "";
        }
        if (this.resourceBundle == null) {
            this.resourceBundle = ResourceBundle.getBundle(SelfExtract.class.getName() + "Messages");
        }
        return MessageFormat.format(this.resourceBundle.getString(this.msgKey), this.params);
    }

    public String getMessageKey() {
        return this.msgKey;
    }

    public Object[] getParameters() {
        return null == this.params || this.params.length == 0 ? new Object[]{} : Arrays.copyOf(this.params, this.params.length);
    }

    public static boolean isReturnCodeOK(ReturnCode rc) {
        return rc.getCode() == OK.getCode();
    }
}

