/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ui.internal.persistence;

import com.ibm.websphere.jsonsupport.JSON;
import com.ibm.websphere.jsonsupport.JSONFactory;
import com.ibm.websphere.jsonsupport.JSONMarshallException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ui.internal.persistence.FilePersistenceDebugger;
import com.ibm.ws.ui.persistence.IPersistenceDebugger;
import com.ibm.ws.ui.persistence.IPersistenceProvider;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.location.WsResource;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={IPersistenceProvider.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM", "service.ranking:Integer=0", "com.ibm.ws.ui.persistence.provider=FILE"})
public class FilePersistenceProvider
implements IPersistenceProvider {
    private static final TraceComponent tc = Tr.register(FilePersistenceProvider.class);
    static final String DEFAULT_PERSIST_LOCATION = "${server.output.dir}/resources/adminCenter-1.0/";
    static final String KEY_LOCATION_SERVICE = "locationServiceRef";
    private final AtomicServiceReference<WsLocationAdmin> locationServiceRef = new AtomicServiceReference("locationServiceRef");
    protected static final String KEY_JSON_SERVICE = "jsonService";
    private final Map<String, File> fileLockObjs = new HashMap<String, File>();
    private JSON json;
    private final IPersistenceDebugger fDebug;
    private ComponentContext cc = null;

    public FilePersistenceProvider() {
        this.fDebug = new FilePersistenceDebugger();
    }

    FilePersistenceProvider(JSON json, IPersistenceDebugger fDebug) {
        this.json = json;
        this.fDebug = fDebug;
    }

    @Reference(service=WsLocationAdmin.class, name="locationServiceRef", policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setLocationService(ServiceReference<WsLocationAdmin> reference) {
        this.locationServiceRef.setReference(reference);
    }

    protected void unsetLocationService(ServiceReference<WsLocationAdmin> reference) {
        this.locationServiceRef.unsetReference(reference);
    }

    protected JSON getJSONService() throws JSONMarshallException {
        if (this.json != null) {
            return this.json;
        }
        JSON jsonService = JSONFactory.newInstance();
        return jsonService;
    }

    @Activate
    protected void activate(ComponentContext context) {
        this.cc = context;
        this.locationServiceRef.activate(this.cc);
    }

    @Deactivate
    protected void deactivate() {
        this.cc = null;
        this.locationServiceRef.deactivate(this.cc);
    }

    @Trivial
    private File getPersistenceFile(String name) {
        WsResource persistenceFile = ((WsLocationAdmin)this.locationServiceRef.getServiceWithException()).resolveResource(DEFAULT_PERSIST_LOCATION + name + ".json");
        File file = persistenceFile.asFile();
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Persistence for [" + name + "] file: " + file.getAbsolutePath()), (Object[])new Object[0]);
        }
        return file;
    }

    @Trivial
    private synchronized File getPersistenceFileLockObj(String name) {
        File lockObj = this.fileLockObjs.get(name);
        if (lockObj == null) {
            lockObj = this.getPersistenceFile(name);
            this.fileLockObjs.put(name, lockObj);
        }
        return lockObj;
    }

    @Trivial
    private void createParentIfNeeded(File file) throws IOException {
        File parentDir = file.getParentFile();
        if (!com.ibm.wsspi.kernel.service.utils.FileUtils.fileExists((File)parentDir)) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Parent directories do not exist. Attempting creation.", (Object[])new Object[0]);
            }
            if (!com.ibm.wsspi.kernel.service.utils.FileUtils.fileMkDirs((File)parentDir)) {
                throw new IOException("Unable to create required parent directories for " + file.getAbsolutePath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(String name, Object pojo) throws JSONMarshallException, IOException {
        File file = this.getPersistenceFileLockObj(name);
        try {
            File file2 = file;
            synchronized (file2) {
                this.createParentIfNeeded(file);
                JSON jsonService = this.getJSONService();
                jsonService.serializeToFile(file, pojo);
            }
        }
        catch (JSONMarshallException e) {
            String msg;
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Unexpected JSONMarshallException caught while storing data to the file. THIS SHOULD NEVER HAPPEN.", (Object[])new Object[]{e});
            }
            if ((msg = e.getMessage()) != null && msg.equals("I/O exception of some sort has occurred")) {
                Tr.error((TraceComponent)tc, (String)"FILE_PERSISTENCE_STORE_IO_ERROR", (Object[])new Object[]{file.getAbsolutePath(), e.getMessage()});
            }
            throw e;
        }
        catch (IOException e) {
            Tr.error((TraceComponent)tc, (String)"FILE_PERSISTENCE_STORE_IO_ERROR", (Object[])new Object[]{file.getAbsolutePath(), e.getMessage()});
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storePlainText(String name, String content) throws JSONMarshallException, IOException {
        File file = this.getPersistenceFileLockObj(name);
        try {
            File file2 = file;
            synchronized (file2) {
                this.createParentIfNeeded(file);
                FileUtils.writeStringToFile((File)file, (String)content, (String)"UTF-8");
            }
        }
        catch (IOException e) {
            Tr.error((TraceComponent)tc, (String)"FILE_PERSISTENCE_STORE_IO_ERROR", (Object[])new Object[]{file.getAbsolutePath(), e.getMessage()});
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @FFDCIgnore(value={FileNotFoundException.class})
    public <T> T load(String name, Class<T> clazz) throws JSONMarshallException, IOException {
        File file = this.getPersistenceFileLockObj(name);
        try {
            File file2 = file;
            synchronized (file2) {
                JSON jsonService = this.getJSONService();
                return (T)jsonService.parse(file, clazz);
            }
        }
        catch (JSONMarshallException e) {
            String msg = e.getMessage();
            if (msg != null && msg.equals("Unable to parse non-well-formed content")) {
                Tr.error((TraceComponent)tc, (String)"FILE_PERSISTENCE_BAD_JSON", (Object[])new Object[]{file.getAbsolutePath(), this.fDebug.getFileContents(file)});
            } else if (msg != null && msg.equals("Fatal problems occurred while mapping content")) {
                Tr.error((TraceComponent)tc, (String)"FILE_PERSISTENCE_WRONG_CLASS", (Object[])new Object[]{file.getAbsolutePath(), clazz.getCanonicalName(), this.fDebug.getFileContents(file)});
            }
            throw e;
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            Tr.error((TraceComponent)tc, (String)"FILE_PERSISTENCE_IO_ERROR", (Object[])new Object[]{file.getAbsolutePath(), e.getMessage()});
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @FFDCIgnore(value={FileNotFoundException.class})
    public String loadPlainText(String name) throws FileNotFoundException, IOException {
        File file = this.getPersistenceFileLockObj(name);
        try {
            File file2 = file;
            synchronized (file2) {
                return FileUtils.readFileToString((File)file, (String)"UTF-8");
            }
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (NoSuchFileException e) {
            throw e;
        }
        catch (IOException e) {
            Tr.error((TraceComponent)tc, (String)"FILE_PERSISTENCE_IO_ERROR", (Object[])new Object[]{file.getAbsolutePath(), e.getMessage()});
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLastModified(String name) {
        File file;
        File file2 = file = this.getPersistenceFileLockObj(name);
        synchronized (file2) {
            return com.ibm.wsspi.kernel.service.utils.FileUtils.fileLastModified((File)file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(String name) throws IOException {
        File file;
        File file2 = file = this.getPersistenceFileLockObj(name);
        synchronized (file2) {
            return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    boolean deleted = file.delete();
                    File parent = file.getParentFile();
                    String[] sa = parent.list();
                    if (sa.length == 0 && !parent.delete()) {
                        Tr.warning((TraceComponent)tc, (String)"TOOLDATA_PARENT_DIR_DELETE_RESULT_FALSE", (Object[])new Object[]{parent.getAbsolutePath()});
                    }
                    return deleted;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String name) {
        File file;
        File file2 = file = this.getPersistenceFileLockObj(name);
        synchronized (file2) {
            return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return file.exists();
                }
            });
        }
    }
}

