/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.signature.support;

import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Set;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.security.SecurityException;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.keyinfo.KeyInfoGenerator;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.SignableXMLObject;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.ConfigurableContentReference;
import org.opensaml.xmlsec.signature.support.ContentReference;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.Signer;
import org.opensaml.xmlsec.signature.support.TransformsConfigurableContentReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SignatureSupport {
    private static final Set<String> C14N_ALGORITHMS = Sets.newHashSet((Object[])new String[]{"http://www.w3.org/2006/12/xml-c14n11", "http://www.w3.org/2006/12/xml-c14n11#WithComments", "http://www.w3.org/2001/10/xml-exc-c14n#", "http://www.w3.org/2001/10/xml-exc-c14n#WithComments", "http://www.w3.org/TR/2001/REC-xml-c14n-20010315", "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments"});

    private SignatureSupport() {
    }

    @Nonnull
    private static Logger getLogger() {
        return LoggerFactory.getLogger(SignatureSupport.class);
    }

    public static void prepareSignatureParams(@Nonnull Signature signature, @Nonnull SignatureSigningParameters parameters) throws SecurityException {
        Constraint.isNotNull((Object)signature, (String)"Signature cannot be null");
        Constraint.isNotNull((Object)parameters, (String)"Signature signing parameters cannot be null");
        if (signature.getSigningCredential() == null) {
            signature.setSigningCredential(parameters.getSigningCredential());
        }
        if (signature.getSigningCredential() == null) {
            throw new SecurityException("No signing credential was available on the signing parameters or Signature");
        }
        if (signature.getSignatureAlgorithm() == null) {
            signature.setSignatureAlgorithm(parameters.getSignatureAlgorithm());
        }
        if (signature.getSignatureAlgorithm() == null) {
            throw new SecurityException("No signature algorithm was available on the signing parameters or Signature");
        }
        if (signature.getHMACOutputLength() == null && AlgorithmSupport.isHMAC(signature.getSignatureAlgorithm())) {
            signature.setHMACOutputLength(parameters.getSignatureHMACOutputLength());
        }
        if (signature.getCanonicalizationAlgorithm() == null) {
            signature.setCanonicalizationAlgorithm(parameters.getSignatureCanonicalizationAlgorithm());
        }
        if (signature.getCanonicalizationAlgorithm() == null) {
            throw new SecurityException("No C14N algorithm was available on the signing parameters or Signature");
        }
        SignatureSupport.processContentReferences(signature, parameters);
        SignatureSupport.processKeyInfo(signature, parameters);
    }

    private static void processKeyInfo(Signature signature, SignatureSigningParameters parameters) throws SecurityException {
        Logger log = SignatureSupport.getLogger();
        if (signature.getKeyInfo() == null) {
            KeyInfoGenerator kiGenerator = parameters.getKeyInfoGenerator();
            if (kiGenerator != null) {
                try {
                    KeyInfo keyInfo = kiGenerator.generate(signature.getSigningCredential());
                    signature.setKeyInfo(keyInfo);
                }
                catch (SecurityException e) {
                    log.error("Error generating KeyInfo from credential", (Throwable)e);
                    throw e;
                }
            } else {
                log.info("No KeyInfoGenerator was supplied in parameters or resolveable for credential type {}, No KeyInfo will be generated for Signature", (Object)signature.getSigningCredential().getCredentialType().getName());
            }
        }
    }

    private static void processContentReferences(@Nonnull Signature signature, @Nonnull SignatureSigningParameters parameters) throws SecurityException {
        String paramsDigestAlgo = parameters.getSignatureReferenceDigestMethod();
        String paramsC14NTransform = parameters.getSignatureReferenceCanonicalizationAlgorithm();
        for (ContentReference cr : signature.getContentReferences()) {
            if (cr instanceof ConfigurableContentReference) {
                ConfigurableContentReference configurableReference = (ConfigurableContentReference)cr;
                if (paramsDigestAlgo != null) {
                    configurableReference.setDigestAlgorithm(paramsDigestAlgo);
                }
                if (configurableReference.getDigestAlgorithm() == null) {
                    throw new SecurityException("No reference digest algorithm was available on the signing parameters or Signature ContentReference");
                }
            }
            if (paramsC14NTransform == null) continue;
            SignatureSupport.addOrReplaceReferenceCanonicalizationTransform(cr, paramsC14NTransform);
        }
    }

    private static void addOrReplaceReferenceCanonicalizationTransform(@Nullable ContentReference cr, @Nullable String uri) {
        if (cr == null || uri == null) {
            return;
        }
        Logger log = SignatureSupport.getLogger();
        log.trace("Adding or replacing content reference transform: {}", (Object)uri);
        if (cr instanceof TransformsConfigurableContentReference) {
            List<String> transforms = ((TransformsConfigurableContentReference)cr).getTransforms();
            if (transforms == null) {
                return;
            }
            for (int i = 0; i < transforms.size(); ++i) {
                if (!SignatureSupport.isCanonicalizationAlgorithm(transforms.get(i))) continue;
                transforms.set(i, uri);
                return;
            }
            transforms.add(uri);
        } else {
            log.warn("A non-null signature reference c14n transform was specified, but ContentReference was not configurable for transforms: {}", (Object)cr.getClass().getName());
        }
    }

    private static boolean isCanonicalizationAlgorithm(@Nullable String uri) {
        String trimmed = StringSupport.trimOrNull((String)uri);
        if (trimmed == null) {
            return false;
        }
        return C14N_ALGORITHMS.contains(trimmed);
    }

    public static void signObject(@Nonnull SignableXMLObject signable, @Nonnull SignatureSigningParameters parameters) throws SecurityException, MarshallingException, SignatureException {
        Constraint.isNotNull((Object)signable, (String)"Signable XMLObject cannot be null");
        Constraint.isNotNull((Object)parameters, (String)"Signature signing parameters cannot be null");
        XMLObjectBuilder<?> signatureBuilder = XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(Signature.DEFAULT_ELEMENT_NAME);
        Signature signature = (Signature)signatureBuilder.buildObject(Signature.DEFAULT_ELEMENT_NAME);
        signable.setSignature(signature);
        SignatureSupport.prepareSignatureParams(signature, parameters);
        Marshaller marshaller = XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller(signable);
        marshaller.marshall(signable);
        Signer.signObject(signature);
    }
}

