/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.wsdl.interceptors;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.AbstractOutDatabindingInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessagePartInfo;

public class BareOutInterceptor
extends AbstractOutDatabindingInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(BareOutInterceptor.class);

    public BareOutInterceptor() {
        super("marshal");
    }

    /*
     * Enabled aggressive block sorting
     */
    public void handleMessage(Message message) {
        List parts;
        MessageContentsList objs;
        BindingOperationInfo operation;
        Exchange exchange;
        block12: {
            BindingMessageInfo bmsg;
            exchange = message.getExchange();
            operation = exchange.getBindingOperationInfo();
            if (operation == null) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("BareOutInterceptor: Operation is NULL, returning...");
                }
                return;
            }
            objs = MessageContentsList.getContentsList((Message)message);
            if (objs == null || objs.isEmpty()) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("BareOutInterceptor: MessageContentsList is empty, returning...");
                }
                return;
            }
            boolean client = this.isRequestor(message);
            if (!client) {
                if (operation.getOutput() != null) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("BareOutInterceptor: Getoutput for operation: " + operation.getName());
                    }
                    bmsg = operation.getOutput();
                    parts = bmsg.getMessageParts();
                    break block12;
                } else {
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.finest("BareOutInterceptor: Operation output is NULL, returning");
                    }
                    return;
                }
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("BareOutInterceptor: Get input message parts...");
            }
            bmsg = operation.getInput();
            parts = bmsg.getMessageParts();
        }
        if (LOG.isLoggable(Level.FINEST)) {
            for (MessagePartInfo mp1 : parts) {
                LOG.finest("BareOutInterceptor: Msg Part: " + mp1.toString());
            }
        }
        this.writeParts(message, exchange, operation, objs, parts);
    }
}

