/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.servlet.event;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.servlet.event.ServletEvent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import com.ibm.wsspi.webcontainer.util.ServletUtil;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public abstract class ServletInvocationEvent
extends ServletEvent {
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.websphere.servlet.event");
    private static final long serialVersionUID = 3906650803920713522L;
    private static final String CLASS_NAME = "com.ibm.websphere.servlet.event.ServletInvocationEvent";
    private ServletRequest _req;
    private ServletResponse _resp;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ServletInvocationEvent(Object source, ServletContext context, String servletName, String servletClassName, ServletRequest req, ServletResponse resp) {
        super(source, context, servletName, servletClassName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "<init>", new Object[]{source, context, servletName, servletClassName, req, resp});
        }
        this._req = req;
        this._resp = resp;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getRequestURL() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getRequestURL", new Object[0]);
        }
        HttpServletRequest httpReq = this.getRequest();
        if (httpReq == null) {
            String string = null;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting(CLASS_NAME, "getRequestURL", string);
            }
            return string;
        }
        String string = httpReq.getRequestURL().toString();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "getRequestURL", string);
        }
        return string;
    }

    public abstract long getResponseTime();

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public HttpServletRequest getRequest() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getRequest", new Object[0]);
        }
        IExtendedRequest sReq = null;
        if (this._req == null) {
            HttpServletRequest httpServletRequest = null;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                httpServletRequest = httpServletRequest;
                logger.exiting(CLASS_NAME, "getRequest", httpServletRequest);
            }
            return httpServletRequest;
        }
        try {
            sReq = ServletUtil.unwrapRequest(this._req);
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, (String)CLASS_NAME, (String)"102", (Object)this, (Object[])new Object[0]);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                void re;
                logger.logp(Level.FINE, CLASS_NAME, "getRequest", "Caught RuntimeException unwrapping the request", (Throwable)re);
            }
            HttpServletRequest httpServletRequest = null;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                httpServletRequest = httpServletRequest;
                logger.exiting(CLASS_NAME, "getRequest", httpServletRequest);
            }
            return httpServletRequest;
        }
        if (sReq instanceof HttpServletRequest) {
            HttpServletRequest httpServletRequest = sReq;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                httpServletRequest = httpServletRequest;
                logger.exiting(CLASS_NAME, "getRequest", httpServletRequest);
            }
            return httpServletRequest;
        }
        HttpServletRequest httpServletRequest = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            httpServletRequest = httpServletRequest;
            logger.exiting(CLASS_NAME, "getRequest", httpServletRequest);
        }
        return httpServletRequest;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public HttpServletResponse getResponse() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getResponse", new Object[0]);
        }
        ServletResponse sRes = null;
        if (this._resp == null) {
            HttpServletResponse httpServletResponse = null;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                httpServletResponse = httpServletResponse;
                logger.exiting(CLASS_NAME, "getResponse", httpServletResponse);
            }
            return httpServletResponse;
        }
        try {
            sRes = ServletUtil.unwrapResponse(this._resp);
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, (String)CLASS_NAME, (String)"140", (Object)this, (Object[])new Object[0]);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                void re;
                logger.logp(Level.FINE, CLASS_NAME, "getResponse", "Caught RuntimeException unwrapping the response", (Throwable)re);
            }
            HttpServletResponse httpServletResponse = null;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                httpServletResponse = httpServletResponse;
                logger.exiting(CLASS_NAME, "getResponse", httpServletResponse);
            }
            return httpServletResponse;
        }
        if (sRes instanceof HttpServletResponse) {
            HttpServletResponse httpServletResponse = (HttpServletResponse)sRes;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                httpServletResponse = httpServletResponse;
                logger.exiting(CLASS_NAME, "getResponse", httpServletResponse);
            }
            return httpServletResponse;
        }
        HttpServletResponse httpServletResponse = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            httpServletResponse = httpServletResponse;
            logger.exiting(CLASS_NAME, "getResponse", httpServletResponse);
        }
        return httpServletResponse;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setRequest(HttpServletRequest req) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setRequest", new Object[]{req});
        }
        this._req = req;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "setRequest");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setResponse(HttpServletResponse res) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setResponse", new Object[]{res});
        }
        this._resp = res;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "setResponse");
        }
    }
}

