/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.restfulws.mpmetrics;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.state.ApplicationStateListener;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.metrics.internal.monitor.MonitorMetricsHandler;
import io.openliberty.microprofile.metrics50.SharedMetricRegistries;
import io.openliberty.restfulws.mpmetrics.RestfulWsMonitorFilter;
import java.util.Map;
import java.util.stream.Stream;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(immediate=true, property={"service.vendor=IBM"}, configurationPid={"com.ibm.ws.monitor.internal.MonitoringFrameworkExtender"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, service={ApplicationStateListener.class})
public class MonitorAppStateListener
implements ApplicationStateListener {
    static SharedMetricRegistries sharedMetricRegistries;
    static MonitorMetricsHandler monitorMetricsHandler;
    private static final String MONITORING_GROUP_FILTER = "filter";
    private static final TraceComponent tc;
    private static boolean isRESTEnabled;
    static final long serialVersionUID = -5684731865106209630L;

    public static boolean isRESTEnabled() {
        return isRESTEnabled;
    }

    public void applicationStarting(ApplicationInfo appInfo) {
        String appName = appInfo.getDeploymentName();
        RestfulWsMonitorFilter.RestMetricInfo metricInfo = RestfulWsMonitorFilter.getMetricInfo(appName);
        if (appInfo.getClass().getName().endsWith("EARApplicationInfoImpl")) {
            metricInfo.setIsEar();
        }
    }

    public void applicationStarted(ApplicationInfo appInfo) {
    }

    public void applicationStopping(ApplicationInfo appInfo) {
    }

    public void applicationStopped(ApplicationInfo appInfo) {
        String appName = appInfo.getDeploymentName();
        RestfulWsMonitorFilter.cleanApplication(appName);
        monitorMetricsHandler.unregisterComputedRESTMetrics(appName);
    }

    @Reference
    public void setSharedMetricRegistries(SharedMetricRegistries sharedMetricRegistryService) {
        sharedMetricRegistries = sharedMetricRegistryService;
    }

    @Reference
    public void setMonitorMetricsHandler(MonitorMetricsHandler monitorMetricsHandlerService) {
        monitorMetricsHandler = monitorMetricsHandlerService;
    }

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> properties) {
        this.resolveMonitorFilter(properties);
    }

    @Modified
    protected void modified(ComponentContext context, Map<String, Object> properties) {
        this.resolveMonitorFilter(properties);
    }

    private void resolveMonitorFilter(Map<String, Object> properties) {
        String filter = (String)properties.get(MONITORING_GROUP_FILTER);
        if (filter != null && filter.length() != 0) {
            isRESTEnabled = filter.length() > 0 ? Stream.of(filter.split(",")).anyMatch(item -> item.equals("REST")) : true;
        } else if (filter == null) {
            isRESTEnabled = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)String.format("Restful-WS filter is enabled set to: [%s]", isRESTEnabled), (Object[])new Object[0]);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        tc = Tr.register(MonitorAppStateListener.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.monitor.resources.MonitorMetrics");
        isRESTEnabled = true;
    }
}

