/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.concurrent.internal.cdi;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.cdi.CDIServiceUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import io.openliberty.concurrent.internal.cdi.ConcurrencyExtensionMetadata;
import io.openliberty.concurrent.internal.cdi.ContextServiceBean;
import io.openliberty.concurrent.internal.cdi.ManagedExecutorBean;
import io.openliberty.concurrent.internal.cdi.ManagedScheduledExecutorBean;
import io.openliberty.concurrent.internal.cdi.ManagedThreadFactoryBean;
import io.openliberty.concurrent.internal.cdi.interceptor.AsyncInterceptor;
import io.openliberty.concurrent.internal.qualified.QualifiedResourceFactories;
import io.openliberty.concurrent.internal.qualified.QualifiedResourceFactory;
import jakarta.enterprise.concurrent.Asynchronous;
import jakarta.enterprise.concurrent.ContextService;
import jakarta.enterprise.concurrent.ManagedExecutorService;
import jakarta.enterprise.concurrent.ManagedScheduledExecutorService;
import jakarta.enterprise.concurrent.ManagedThreadFactory;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AfterDeploymentValidation;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.inject.spi.Extension;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ConcurrencyExtension
implements Extension {
    private static final Annotation[] DEFAULT_QUALIFIER_ARRAY;
    private static final Set<Annotation> DEFAULT_QUALIFIER_SET;
    private ConcurrencyExtensionMetadata extSvc;
    private List<Set<Annotation>> qualifierSetsPerMTF;
    static final long serialVersionUID = -1688878881498038379L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public void beforeBeanDiscovery(@Observes BeforeBeanDiscovery beforeBeanDiscovery, BeanManager beanManager) {
        AnnotatedType bindingType = beanManager.createAnnotatedType(Asynchronous.class);
        beforeBeanDiscovery.addInterceptorBinding(bindingType);
        AnnotatedType interceptorType = beanManager.createAnnotatedType(AsyncInterceptor.class);
        beforeBeanDiscovery.addAnnotatedType(interceptorType, CDIServiceUtils.getAnnotatedTypeIdentifier((AnnotatedType)interceptorType, this.getClass()));
    }

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        List<Map<List<String>, QualifiedResourceFactory>> listFromApp;
        List<Map<List<String>, QualifiedResourceFactory>> listFromModule;
        ComponentMetaData cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        if (cmd == null) {
            throw new IllegalStateException();
        }
        J2EEName jeeName = cmd.getJ2EEName();
        BundleContext bundleContext = FrameworkUtil.getBundle(ConcurrencyExtension.class).getBundleContext();
        ServiceReference ref = bundleContext.getServiceReference(QualifiedResourceFactories.class);
        this.extSvc = (ConcurrencyExtensionMetadata)bundleContext.getService(ref);
        CDI cdi = CDI.current();
        if (!cdi.select(ContextService.class, DEFAULT_QUALIFIER_ARRAY).isResolvable()) {
            event.addBean((Bean)new ContextServiceBean(this.extSvc.defaultContextServiceFactory, DEFAULT_QUALIFIER_SET));
        }
        if (!cdi.select(ManagedExecutorService.class, DEFAULT_QUALIFIER_ARRAY).isResolvable()) {
            event.addBean((Bean)new ManagedExecutorBean(this.extSvc.defaultManagedExecutorFactory, DEFAULT_QUALIFIER_SET));
        }
        if (!cdi.select(ManagedScheduledExecutorService.class, DEFAULT_QUALIFIER_ARRAY).isResolvable()) {
            event.addBean((Bean)new ManagedScheduledExecutorBean(this.extSvc.defaultManagedScheduledExecutorFactory, DEFAULT_QUALIFIER_SET));
        }
        if (!cdi.select(ManagedThreadFactory.class, DEFAULT_QUALIFIER_ARRAY).isResolvable()) {
            event.addBean((Bean)new ManagedThreadFactoryBean(cmd, this.extSvc, DEFAULT_QUALIFIER_SET));
            this.qualifierSetsPerMTF = new ArrayList<Set<Annotation>>();
            this.qualifierSetsPerMTF.add(Collections.emptySet());
        }
        if ((listFromModule = this.extSvc.removeAll(cmd.getJ2EEName().toString())) != null) {
            this.addBeans(event, listFromModule);
        }
        if ((listFromApp = this.extSvc.removeAll(jeeName.getApplication())) != null) {
            this.addBeans(event, listFromApp);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addBeans(AfterBeanDiscovery event, List<Map<List<String>, QualifiedResourceFactory>> list) {
        Map<List<String>, QualifiedResourceFactory> qualifiedContextServices = list.get(QualifiedResourceFactory.Type.ContextService.ordinal());
        for (QualifiedResourceFactory qualifiedResourceFactory : qualifiedContextServices.values()) {
            try {
                event.addBean((Bean)new ContextServiceBean(qualifiedResourceFactory));
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"io.openliberty.concurrent.internal.cdi.ConcurrencyExtension", (String)"151", (Object)this, (Object[])new Object[]{event, list});
                System.out.println(" E Unable to create a bean for the " + qualifiedResourceFactory + " ContextServiceDefinition with the " + qualifiedResourceFactory.getQualifiers() + " qualifiers due to the following error: ");
                throwable.printStackTrace();
            }
        }
        Map<List<String>, QualifiedResourceFactory> qualifiedManagedExecutors = list.get(QualifiedResourceFactory.Type.ManagedExecutorService.ordinal());
        for (QualifiedResourceFactory qualifiedResourceFactory : qualifiedManagedExecutors.values()) {
            try {
                event.addBean((Bean)new ManagedExecutorBean(qualifiedResourceFactory));
            }
            catch (Throwable throwable) {
                void x;
                FFDCFilter.processException((Throwable)throwable, (String)"io.openliberty.concurrent.internal.cdi.ConcurrencyExtension", (String)"166", (Object)this, (Object[])new Object[]{event, list});
                System.out.println(" E Unable to create a bean for the " + qualifiedResourceFactory + " ManagedExecutorDefinition with the " + qualifiedResourceFactory.getQualifiers() + " qualifiers due to the following error: ");
                x.printStackTrace();
            }
        }
        Map<List<String>, QualifiedResourceFactory> map = list.get(QualifiedResourceFactory.Type.ManagedScheduledExecutorService.ordinal());
        for (QualifiedResourceFactory factory : map.values()) {
            try {
                event.addBean((Bean)new ManagedScheduledExecutorBean(factory));
            }
            catch (Throwable throwable) {
                void x;
                FFDCFilter.processException((Throwable)throwable, (String)"io.openliberty.concurrent.internal.cdi.ConcurrencyExtension", (String)"181", (Object)this, (Object[])new Object[]{event, list});
                System.out.println(" E Unable to create a bean for the " + factory + " ManagedScheduledExecutorDefinition with the " + factory.getQualifiers() + " qualifiers due to the following error: ");
                x.printStackTrace();
            }
        }
        Map<List<String>, QualifiedResourceFactory> map2 = list.get(QualifiedResourceFactory.Type.ManagedThreadFactory.ordinal());
        for (QualifiedResourceFactory factory : map2.values()) {
            try {
                event.addBean((Bean)new ManagedThreadFactoryBean(factory, this.extSvc));
            }
            catch (Throwable throwable) {
                void x;
                FFDCFilter.processException((Throwable)throwable, (String)"io.openliberty.concurrent.internal.cdi.ConcurrencyExtension", (String)"196", (Object)this, (Object[])new Object[]{event, list});
                System.out.println(" E Unable to create a bean for the " + factory + " ManagedThreadFactoryDefinition with the " + factory.getQualifiers() + " qualifiers due to the following error: ");
                x.printStackTrace();
            }
        }
    }

    public void afterDeploymentValidation(@Observes AfterDeploymentValidation event, BeanManager beanManager) {
        if (this.qualifierSetsPerMTF != null) {
            CDI cdi = CDI.current();
            for (Set<Annotation> qualifierSet : this.qualifierSetsPerMTF) {
                Instance instance = cdi.select(ManagedThreadFactory.class, qualifierSet.toArray(new Annotation[qualifierSet.size()]));
                ManagedThreadFactory mtf = (ManagedThreadFactory)instance.get();
                mtf.toString();
            }
            this.qualifierSetsPerMTF = null;
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.concurrent.internal.cdi.ConcurrencyExtension", ConcurrencyExtension.class, (String)"concurrent", (String)"io.openliberty.concurrent.internal.cdi.resources.CWWKCMessages");
        DEFAULT_QUALIFIER_ARRAY = new Annotation[]{Default.Literal.INSTANCE};
        DEFAULT_QUALIFIER_SET = Set.of(Default.Literal.INSTANCE);
    }
}

