/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.concurrent.internal.cdi.interceptor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.concurrent.WSManagedExecutorService;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.threading.ScheduledCustomExecutorTask;
import com.ibm.wsspi.threadcontext.ThreadContextDescriptor;
import io.openliberty.concurrent.internal.cdi.ConcurrencyExtensionMetadata;
import io.openliberty.concurrent.internal.cdi.interceptor.AsyncInterceptor;
import io.openliberty.concurrent.internal.cdi.interceptor.ScheduleCronTrigger;
import jakarta.enterprise.concurrent.ManagedExecutorService;
import jakarta.interceptor.InvocationContext;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class ScheduledAsyncMethod
implements Callable<CompletableFuture<Object>>,
ScheduledCustomExecutorTask {
    private static final TraceComponent tc = Tr.register(ScheduledAsyncMethod.class, (String)"concurrent", (String)"io.openliberty.concurrent.internal.cdi.resources.CWWKCMessages");
    static final ThreadLocal<CompletableFuture<?>> inlineExecutionFuture = new ThreadLocal();
    private final ThreadContextDescriptor contextDescriptor;
    private final InvocationContext firstInvocation;
    final CompletableFuture<Object> future;
    private final AsyncInterceptor interceptor;
    private boolean isFirstExecution = true;
    private long nextExecutionSkipIfLateBySeconds;
    private ZonedDateTime nextExecutionTime;
    private final List<Long> skipIfLateBySeconds;
    private final List<ScheduleCronTrigger> triggers;
    private final Executor virtualThreadExecutor;
    static final long serialVersionUID = -9192240494861909360L;

    ScheduledAsyncMethod(InvocationContext firstInvocation, AsyncInterceptor interceptor, WSManagedExecutorService managedExecutor, List<ScheduleCronTrigger> triggers, List<Long> skipIfLateBySeconds) {
        this.contextDescriptor = managedExecutor.captureThreadContext(null);
        this.firstInvocation = firstInvocation;
        this.future = ((ManagedExecutorService)managedExecutor).newIncompleteFuture();
        this.interceptor = interceptor;
        this.triggers = triggers;
        this.skipIfLateBySeconds = skipIfLateBySeconds;
        this.virtualThreadExecutor = managedExecutor.getNormalPolicyExecutor().getVirtualThreadExecutor();
        ConcurrencyExtensionMetadata.scheduledExecutor.schedule(this, this.computeDelayNanos(), TimeUnit.NANOSECONDS);
    }

    /*
     * Exception decompiling
     */
    @Override
    @Trivial
    @ManualTrace
    @FFDCIgnore(value={CompletionException.class})
    public CompletableFuture<Object> call() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Trivial
    @ManualTrace
    private long computeDelayNanos() {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"computeDelayNanos", (Object[])new Object[0]);
        }
        ZonedDateTime now = null;
        this.nextExecutionTime = null;
        for (int i = 0; i < this.triggers.size(); ++i) {
            ScheduleCronTrigger trigger = this.triggers.get(i);
            now = now == null ? ZonedDateTime.now(trigger.getZoneId()) : now;
            ZonedDateTime time = trigger.next(now);
            if (this.nextExecutionTime != null && !this.nextExecutionTime.isAfter(time)) continue;
            this.nextExecutionTime = time;
            this.nextExecutionSkipIfLateBySeconds = this.skipIfLateBySeconds.get(i);
        }
        long delayNanos = ZonedDateTime.now(this.nextExecutionTime.getZone()).until(this.nextExecutionTime, ChronoUnit.NANOS);
        long l = delayNanos = delayNanos < 0L ? 0L : delayNanos;
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"computeDelayNanos", (Object)(delayNanos / 1000000000L + "s " + delayNanos % 1000000000L / 1000000L + "ms " + delayNanos % 1000000L + "ns"));
        }
        return delayNanos;
    }

    @Trivial
    public Executor getExecutor() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("getExecutor for virtual threads: " + this.virtualThreadExecutor), (Object[])new Object[0]);
        }
        return this.virtualThreadExecutor;
    }

    private /* synthetic */ void lambda$call$0(Object result, Throwable x) {
        if (x == null) {
            this.future.complete(result);
        } else {
            this.future.completeExceptionally(x);
        }
    }
}

