/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openid20.internal;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.openid20.OpenidClientAuthenticator;
import com.ibm.ws.security.openid20.OpenidClientConfig;
import com.ibm.ws.security.openid20.consumer.OpenidClientAuthenticatorImpl;
import com.ibm.ws.webcontainer.security.ProviderAuthenticationResult;
import com.ibm.ws.webcontainer.security.openid20.OpenidClientService;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import com.ibm.wsspi.ssl.SSLConfiguration;
import com.ibm.wsspi.ssl.SSLSupport;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OpenidClientServiceImpl
implements OpenidClientService {
    private static final TraceComponent tc = Tr.register(OpenidClientServiceImpl.class, (String)"OpenId", (String)"com.ibm.ws.security.openid20.internal.resources.OpenIDMessages");
    public static final String KEY_OPENID_CLIENT_CONFIG = "openidClientConfig";
    public static final String KEY_SSL_SUPPORT = "sslSupport";
    public static final String KEY_SSL_CONFIG = "sslConfig";
    static final String CFG_ID = "id";
    protected final AtomicServiceReference<OpenidClientConfig> openidClientConfigRef = new AtomicServiceReference("openidClientConfig");
    protected final AtomicServiceReference<SSLSupport> sslSupportRef = new AtomicServiceReference("sslSupport");
    protected final ConcurrentServiceReferenceMap<String, SSLConfiguration> sslConfigRef = new ConcurrentServiceReferenceMap("sslConfig");
    private OpenidClientConfig openidClientConfig = null;
    private OpenidClientAuthenticator openidAuthenticator;
    private String defaultSslConfig = null;
    private boolean lazyInitOpenidAuth = false;
    static final long serialVersionUID = -1040239966328546688L;

    protected void setOpenidAuthenticator(OpenidClientAuthenticator openidAuthenticator) {
        this.openidAuthenticator = openidAuthenticator;
    }

    protected void setOpenidClientConfig(ServiceReference<OpenidClientConfig> ref) {
        this.openidClientConfigRef.setReference(ref);
        this.openidClientConfig = (OpenidClientConfig)this.openidClientConfigRef.getService();
    }

    protected void updatedOpenidClientConfig(ServiceReference<OpenidClientConfig> ref) {
        this.openidClientConfigRef.setReference(ref);
        this.openidClientConfig = (OpenidClientConfig)this.openidClientConfigRef.getService();
        this.lazyInitOpenidAuth = true;
    }

    protected void unsetOpenidClientConfig(ServiceReference<OpenidClientConfig> ref) {
        this.openidClientConfigRef.unsetReference(ref);
        this.openidClientConfig = null;
    }

    protected void setSslSupport(ServiceReference<SSLSupport> ref) {
        this.sslSupportRef.setReference(ref);
        this.defaultSslConfig = (String)ref.getProperty("sslRef");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("defaultSslConfig: " + this.defaultSslConfig), (Object[])new Object[0]);
        }
        this.lazyInitOpenidAuth = true;
    }

    protected void updatedSslSupport(ServiceReference<SSLSupport> ref) {
        this.sslSupportRef.setReference(ref);
        this.defaultSslConfig = (String)ref.getProperty("sslRef");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("defaultSslConfig: " + this.defaultSslConfig), (Object[])new Object[0]);
        }
        this.lazyInitOpenidAuth = true;
    }

    protected void unsetSslSupport(ServiceReference<SSLSupport> ref) {
        this.sslSupportRef.unsetReference(ref);
        this.defaultSslConfig = null;
        this.lazyInitOpenidAuth = true;
    }

    protected void updatedSslConfig(ServiceReference<SSLConfiguration> ref) {
        String id = (String)ref.getProperty(CFG_ID);
        this.sslConfigRef.putReference((Object)id, ref);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("sslConfig:" + id), (Object[])new Object[0]);
        }
        this.initOpenidAuthIfNeeded(id);
    }

    protected void setSslConfig(ServiceReference<SSLConfiguration> ref) {
        String id = (String)ref.getProperty(CFG_ID);
        this.sslConfigRef.putReference((Object)id, ref);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("sslConfig: " + id), (Object[])new Object[0]);
        }
        this.initOpenidAuthIfNeeded(id);
    }

    protected void unsetSslConfig(ServiceReference<SSLConfiguration> ref) {
        String id = (String)ref.getProperty(CFG_ID);
        this.sslConfigRef.removeReference((Object)id, ref);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("sslConfig: " + id), (Object[])new Object[0]);
        }
        this.initOpenidAuthIfNeeded(id);
    }

    protected synchronized void activate(ComponentContext cc) {
        this.openidClientConfigRef.activate(cc);
        this.sslSupportRef.activate(cc);
        this.sslConfigRef.activate(cc);
        this.openidAuthenticator = new OpenidClientAuthenticatorImpl();
        this.lazyInitOpenidAuth = true;
    }

    protected synchronized void modify(Map<String, Object> properties) {
    }

    protected synchronized void deactivate(ComponentContext cc) {
        this.openidClientConfigRef.deactivate(cc);
        this.sslSupportRef.deactivate(cc);
        this.sslConfigRef.deactivate(cc);
        this.openidAuthenticator = null;
    }

    public String getOpenIdIdentifier(HttpServletRequest req) {
        return req.getParameter("openid_identifier");
    }

    /*
     * WARNING - void declaration
     */
    public void createAuthRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        block6: {
            if (this.lazyInitOpenidAuth) {
                SSLContext sslContext = null;
                try {
                    sslContext = this.getSSLContext();
                }
                catch (SSLException sSLException) {
                    void e;
                    FFDCFilter.processException((Throwable)sSLException, (String)"com.ibm.ws.security.openid20.internal.OpenidClientServiceImpl", (String)"169", (Object)this, (Object[])new Object[]{request, response});
                    throw new Exception(e.getMessage());
                }
                this.openidAuthenticator.initialize(this.openidClientConfig, sslContext);
                this.lazyInitOpenidAuth = false;
            }
            if (request.getCharacterEncoding() == null) {
                try {
                    request.setCharacterEncoding(this.openidClientConfig.getCharacterEncoding());
                }
                catch (UnsupportedEncodingException sslContext) {
                    void e;
                    FFDCFilter.processException((Throwable)sslContext, (String)"com.ibm.ws.security.openid20.internal.OpenidClientServiceImpl", (String)"179", (Object)this, (Object[])new Object[]{request, response});
                    if (!tc.isWarningEnabled()) break block6;
                    Tr.warning((TraceComponent)tc, (String)e.getMessage(), (Object[])new Object[0]);
                }
            }
        }
        this.openidAuthenticator.createAuthRequest((ServletRequest)request, (ServletResponse)response);
    }

    public String getRpRequestIdentifier(HttpServletRequest req, HttpServletResponse res) {
        return req.getParameter("rp_identifier");
    }

    public ProviderAuthenticationResult verifyOpResponse(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ProviderAuthenticationResult result = this.openidAuthenticator.verifyResponse((ServletRequest)request);
        return result;
    }

    public boolean isMapIdentityToRegistryUser() {
        return this.openidClientConfig == null ? false : this.openidClientConfig.isMapIdentityToRegistryUser();
    }

    protected SSLContext getSSLContext() throws SSLException {
        SSLContext sslContext = null;
        this.openidClientConfig = (OpenidClientConfig)this.openidClientConfigRef.getService();
        JSSEHelper jsseHelper = this.getJSSEHelper(this.openidClientConfig);
        if (jsseHelper != null) {
            String sslRef = this.openidClientConfig.getSslRef();
            if (sslRef != null && !jsseHelper.doesSSLConfigExist(sslRef)) {
                Tr.error((TraceComponent)tc, (String)"OPENID_RP_CONFIG_INVALID_SSLREF", (Object[])new Object[]{sslRef});
                throw new SSLException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.openid20.internal.resources.OpenIDMessages", (String)"OPENID_RP_CONFIG_INVALID_SSLREF", (Object[])new Object[]{sslRef}, (String)"CWWKS1507E: OpenID configuration requires SSL but sslRef {0} does not exist or is blank."));
            }
            sslContext = jsseHelper.getSSLContext(sslRef, null, null);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("sslContext (" + sslRef + ") get: " + sslContext), (Object[])new Object[0]);
            }
            if (sslContext == null && this.openidClientConfig.ishttpsRequired()) {
                Tr.error((TraceComponent)tc, (String)"OPENID_HTTPS_WITH_SSLCONTEXT_NULL", (Object[])new Object[0]);
                throw new SSLException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.openid20.internal.resources.OpenIDMessages", (String)"OPENID_HTTPS_WITH_SSLCONTEXT_NULL", null, (String)"CWWKS1509E: OpenID configuration requires SSL but SSL is not properly configured."));
            }
        }
        return sslContext;
    }

    protected JSSEHelper getJSSEHelper(OpenidClientConfig openidClientConfig) throws SSLException {
        SSLSupport sslSupport = (SSLSupport)this.sslSupportRef.getService();
        if (sslSupport != null) {
            return sslSupport.getJSSEHelper();
        }
        if (openidClientConfig.ishttpsRequired()) {
            Tr.error((TraceComponent)tc, (String)"OPENID_HTTPS_WITHOUT_SSL_SERVICE", (Object[])new Object[0]);
            throw new SSLException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.openid20.internal.resources.OpenIDMessages", (String)"OPENID_HTTPS_NO_SSL_SERVICE", null, (String)"CWWKS1508E: OpenID configuration requires SSL but SSL service is not available."));
        }
        return null;
    }

    protected boolean initOpenidAuthIfNeeded(String id) {
        OpenidClientConfig openidClientConfig = (OpenidClientConfig)this.openidClientConfigRef.getService();
        if (openidClientConfig != null && id.equalsIgnoreCase(openidClientConfig.getSslRef())) {
            this.lazyInitOpenidAuth = true;
        } else if (this.defaultSslConfig != null && id.equalsIgnoreCase(this.defaultSslConfig)) {
            this.lazyInitOpenidAuth = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("lazyInitConsumer:" + this.lazyInitOpenidAuth), (Object[])new Object[0]);
        }
        return this.lazyInitOpenidAuth;
    }
}

