/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openid20.tai;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.common.encoder.Base64Coder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ClientAuthnData {
    private static TraceComponent tc = Tr.register(ClientAuthnData.class, null, null);
    public static final String Authorization_Header = "Authorization";
    public static final String AUTHORIZATION_ENCODING = "Authorization-Encoding";
    public static final String BasicAuthEncoding = System.getProperty("com.ibm.websphere.security.BasicAuthEncoding", "UTF-8");
    String userName = null;
    String passWord = null;
    boolean authnData = false;
    static final long serialVersionUID = 5761418364172373584L;

    public ClientAuthnData(HttpServletRequest req, HttpServletResponse res) {
        int idx;
        String hdrValue = ClientAuthnData.decodeAuthorizationHeader(req);
        if (hdrValue != null && (idx = hdrValue.indexOf(58)) >= 0) {
            this.userName = hdrValue.substring(0, idx);
            this.passWord = hdrValue.substring(idx + 1);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Use authentication data from Authentication head for client:" + this.userName), (Object[])new Object[0]);
        }
        if (this.userName != null && this.userName.length() > 0) {
            this.authnData = true;
        }
    }

    @Sensitive
    public static String decodeAuthorizationHeader(HttpServletRequest req) {
        String hdrValue = req.getHeader(Authorization_Header);
        String encoding = req.getHeader(AUTHORIZATION_ENCODING);
        if (hdrValue == null || !hdrValue.startsWith("Basic ")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"decodeAuthorizationHeader null", (Object[])new Object[0]);
            }
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"decodeAuthorizationHeader Basic", (Object[])new Object[0]);
        }
        return ClientAuthnData.decodeAuthorizationHeader(hdrValue, encoding);
    }

    /*
     * WARNING - void declaration
     */
    @Sensitive
    public static String decodeAuthorizationHeader(@Sensitive String hdrValue, String encoding) {
        block4: {
            if (hdrValue == null) {
                return null;
            }
            if (encoding == null) {
                encoding = BasicAuthEncoding;
            }
            try {
                hdrValue = Base64Coder.base64Decode((String)hdrValue.substring(6), (String)encoding);
            }
            catch (Exception exception) {
                void e;
                Object[] objectArray = new Object[2];
                objectArray[0] = "<sensitive java.lang.String>";
                objectArray[1] = encoding;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.openid20.tai.ClientAuthnData", (String)"77", null, (Object[])objectArray);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("Decoding fails with encoding:" + encoding), (Object[])new Object[]{e.getMessage()});
            }
        }
        return hdrValue;
    }

    public String getUserName() {
        return this.userName;
    }

    @Sensitive
    public String getPassWord() {
        return this.passWord;
    }

    public boolean hasAuthnData() {
        return this.authnData;
    }
}

